/*
 * Decompiled with CFR 0.152.
 */
package act.crypto;

import act.session.JWT;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.osgl.util.Codec;
import org.osgl.util.E;
import org.osgl.util.S;

public class HMAC {
    private Mac mac;
    private String algoName;
    protected Algorithm algo;
    private final Charset UTF_8 = Charset.forName("UTF-8");
    private static Map<String, Algorithm> algoLookup = new HashMap<String, Algorithm>();

    protected HMAC(String algoKey) {
        this.algo = algoLookup.get(algoKey.toUpperCase());
        E.illegalArgumentIf((null == this.algo ? 1 : 0) != 0, (String)"Algorithm not found");
        this.algoName = this.algo.jwtName();
    }

    protected HMAC(Algorithm algo) {
        this.algoName = algo.jwtName();
        this.algo = algo;
    }

    public HMAC(String key, String algoKey) {
        this(algoKey);
        this.mac = this.algo.macOf(key);
    }

    public HMAC(String key, Algorithm algo) {
        this(algo);
        this.mac = algo.macOf(key);
    }

    public String toString(JWT.Token token) {
        token.header(JWT.Header.ALGO, this.algoName);
        String headers = token.headerJsonString();
        String payloads = token.payloadJsonString();
        String encodedHeaders = HMAC.encodePart(headers);
        String encodedPayloads = HMAC.encodePart(payloads);
        StringBuilder buf = new StringBuilder(encodedHeaders).append(".").append(encodedPayloads);
        String hash = this.hash(buf.toString());
        return buf.append(".").append(hash).toString();
    }

    public String hash(String text) {
        return this.hash(text.getBytes(this.UTF_8));
    }

    public String hash(byte[] bytes) {
        byte[] hashed = this.doHash(bytes);
        return HMAC.encodePart(hashed);
    }

    protected byte[] doHash(byte[] bytes) {
        return this.doHash(bytes, this.mac);
    }

    protected final byte[] doHash(byte[] bytes, Mac mac) {
        return mac.doFinal(bytes);
    }

    public boolean verifyHash(String content, String hash) {
        int len = hash.length();
        int padding = 4 - len % 4;
        if (padding > 0) {
            hash = S.concat((String)hash, (String)S.times((char)'~', (int)padding));
        }
        byte[] yourHash = Codec.decodeUrlSafeBase64((String)hash);
        return this.verifyHash(content.getBytes(this.UTF_8), yourHash);
    }

    protected boolean verifyHash(byte[] payload, byte[] hash) {
        return this.verifyHash(payload, hash, this.mac);
    }

    protected final boolean verifyHash(byte[] payload, byte[] hash, Mac mac) {
        byte[] myHash = this.doHash(payload, mac);
        return MessageDigest.isEqual(myHash, hash);
    }

    public boolean verifyArgo(String algoName) {
        Algorithm algorithm = algoLookup.get(algoName);
        return null != algorithm && S.eq((String)this.algoName, (String)algorithm.jwtName());
    }

    protected static String encodePart(String part) {
        return Codec.encodeUrlSafeBase64((String)part);
    }

    protected static String encodePart(byte[] part) {
        return Codec.encodeUrlSafeBase64((byte[])part);
    }

    static {
        for (Algorithm algo : Algorithm.values()) {
            algoLookup.put(algo.javaName.toUpperCase(), algo);
            algoLookup.put(algo.name().toUpperCase(), algo);
            algoLookup.put(algo.jwtName().toUpperCase(), algo);
        }
    }

    public static enum Algorithm {
        SHA256,
        SHA384,
        SHA512;

        private final String javaName = S.concat((String)"Hmac", (String)this.name());
        private final String jwtName = S.concat((String)"HS", (String)this.name().substring(3));

        Mac macOf(String key) {
            try {
                SecretKeySpec spec = new SecretKeySpec(key.getBytes(Charset.forName("UTF-8")), this.javaName);
                Mac mac = Mac.getInstance(this.javaName);
                mac.init(spec);
                return mac;
            }
            catch (Exception e) {
                throw E.unexpected((Throwable)e);
            }
        }

        public String jwtName() {
            return this.jwtName;
        }
    }
}

