/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.app.ActionContext;
import act.data.ContentTypeWithEncoding;
import act.data.MapUtil;
import act.data.MultipartStream;
import act.data.RequestBodyParser;
import act.util.UploadFileStorageService;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ParameterParser;
import org.apache.commons.fileupload.util.Closeable;
import org.apache.commons.fileupload.util.LimitedInputStream;
import org.osgl.exception.UnexpectedException;
import org.osgl.http.H;
import org.osgl.storage.ISObject;
import org.osgl.util.E;

public class ApacheMultipartParser
extends RequestBodyParser {
    private static final String CONTENT_TYPE = "Content-type";
    private static final String CONTENT_DISPOSITION = "Content-disposition";
    private static final String FORM_DATA = "form-data";
    private static final String ATTACHMENT = "attachment";
    private static final String MULTIPART = "multipart/";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String MULTIPART_MIXED = "multipart/mixed";
    private long sizeMax = -1L;
    private long fileSizeMax = -1L;

    @Override
    public Map<String, String[]> parse(ActionContext context) {
        H.Request request = context.req();
        InputStream body = request.inputStream();
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        try {
            FileItemIteratorImpl iter = new FileItemIteratorImpl(body, request.header("content-type"), request.characterEncoding());
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                ISObject sobj = UploadFileStorageService.store(item, context.app());
                if (sobj.getLength() == 0L) continue;
                String fieldName = item.getFieldName();
                if (item.isFormField()) {
                    String _encoding = request.characterEncoding();
                    String _contentType = item.getContentType();
                    if (_contentType != null) {
                        ContentTypeWithEncoding contentTypeEncoding = ContentTypeWithEncoding.parse(_contentType);
                        if (contentTypeEncoding.encoding != null) {
                            _encoding = contentTypeEncoding.encoding;
                        }
                    }
                    MapUtil.mergeValueInMap(result, fieldName, sobj.asString(Charset.forName(_encoding)));
                    continue;
                }
                context.addUpload(item.getFieldName(), sobj);
                MapUtil.mergeValueInMap(result, fieldName, fieldName);
            }
        }
        catch (FileUploadIOException e) {
            throw E.ioException((String)"Error when handling upload", (Object[])new Object[]{e});
        }
        catch (IOException e) {
            throw E.ioException((String)"Error when handling upload", (Object[])new Object[]{e});
        }
        catch (FileUploadException e) {
            throw E.ioException((String)"Error when handling upload", (Object[])new Object[]{e});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
        return result;
    }

    private byte[] getBoundary(String contentType) {
        byte[] boundary;
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map params = parser.parse(contentType, ';');
        String boundaryStr = (String)params.get("boundary");
        if (boundaryStr == null) {
            return null;
        }
        try {
            boundary = boundaryStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            boundary = boundaryStr.getBytes();
        }
        return boundary;
    }

    private String getFileName(Map headers) {
        String cdl;
        String fileName = null;
        String cd = this.getHeader(headers, CONTENT_DISPOSITION);
        if (cd != null && ((cdl = cd.toLowerCase()).startsWith(FORM_DATA) || cdl.startsWith(ATTACHMENT))) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map params = parser.parse(cd, ';');
            if (params.containsKey("filename")) {
                fileName = (String)params.get("filename");
                if (fileName != null) {
                    if ((fileName = fileName.trim()).indexOf(92) != -1) {
                        fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
                    }
                } else {
                    fileName = "";
                }
            }
        }
        return fileName;
    }

    private String getFieldName(Map headers) {
        String fieldName = null;
        String cd = this.getHeader(headers, CONTENT_DISPOSITION);
        if (cd != null && cd.toLowerCase().startsWith(FORM_DATA)) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map params = parser.parse(cd, ';');
            fieldName = (String)params.get("name");
            if (fieldName != null) {
                fieldName = fieldName.trim();
            }
        }
        return fieldName;
    }

    private Map parseHeaders(String headerPart) {
        int end;
        int len = headerPart.length();
        HashMap<String, String> headers = new HashMap<String, String>();
        int start = 0;
        while (start != (end = this.parseEndOfLine(headerPart, start))) {
            String header = headerPart.substring(start, end);
            start = end + 2;
            while (start < len) {
                char c;
                int nonWs;
                for (nonWs = start; nonWs < len && ((c = headerPart.charAt(nonWs)) == ' ' || c == '\t'); ++nonWs) {
                }
                if (nonWs == start) break;
                end = this.parseEndOfLine(headerPart, nonWs);
                header = header + " " + headerPart.substring(nonWs, end);
                start = end + 2;
            }
            this.parseHeaderLine(headers, header);
        }
        return headers;
    }

    private int parseEndOfLine(String headerPart, int end) {
        int index = end;
        while (true) {
            int offset;
            if ((offset = headerPart.indexOf(13, index)) == -1 || offset + 1 >= headerPart.length()) {
                throw new IllegalStateException("Expected headers to be terminated by an empty line.");
            }
            if (headerPart.charAt(offset + 1) == '\n') {
                return offset;
            }
            index = offset + 1;
        }
    }

    private void parseHeaderLine(Map<String, String> headers, String header) {
        int colonOffset = header.indexOf(58);
        if (colonOffset == -1) {
            return;
        }
        String headerName = header.substring(0, colonOffset).trim().toLowerCase();
        String headerValue = header.substring(header.indexOf(58) + 1).trim();
        if (this.getHeader(headers, headerName) != null) {
            headers.put(headerName, this.getHeader(headers, headerName) + ',' + headerValue);
        } else {
            headers.put(headerName, headerValue);
        }
    }

    private final String getHeader(Map headers, String name) {
        return (String)headers.get(name.toLowerCase());
    }

    private static class FileSizeLimitExceededException
    extends SizeException {
        private static final long serialVersionUID = 8150776562029630058L;

        public FileSizeLimitExceededException(String message, long actual, long permitted) {
            super(message, actual, permitted);
        }
    }

    private static class SizeLimitExceededException
    extends SizeException {
        private static final long serialVersionUID = -2474893167098052828L;

        public SizeLimitExceededException(String message, long actual, long permitted) {
            super(message, actual, permitted);
        }
    }

    protected static abstract class SizeException
    extends FileUploadException {
        private final long actual;
        private final long permitted;

        protected SizeException(String message, long actual, long permitted) {
            super(message);
            this.actual = actual;
            this.permitted = permitted;
        }

        public long getActualSize() {
            return this.actual;
        }

        public long getPermittedSize() {
            return this.permitted;
        }
    }

    private static class IOFileUploadException
    extends FileUploadException {
        private static final long serialVersionUID = 1749796615868477269L;
        private final IOException cause;

        public IOFileUploadException(String pMsg, IOException pException) {
            super(pMsg);
            this.cause = pException;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }

    private static class InvalidContentTypeException
    extends FileUploadException {
        private static final long serialVersionUID = -9073026332015646668L;

        public InvalidContentTypeException(String message) {
            super(message);
        }
    }

    private static class FileUploadIOException
    extends IOException {
        private static final long serialVersionUID = -7047616958165584154L;
        private final FileUploadException cause;

        public FileUploadIOException(FileUploadException pCause) {
            this.cause = pCause;
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }
    }

    private class FileItemIteratorImpl
    implements FileItemIterator {
        private final MultipartStream multi;
        private final byte[] boundary;
        private FileItemStreamImpl currentItem;
        private String currentFieldName;
        private boolean skipPreamble;
        private boolean itemValid;
        private boolean eof;

        FileItemIteratorImpl(InputStream input, String contentType, String charEncoding) throws FileUploadException, IOException {
            if (null == contentType || !contentType.toLowerCase().startsWith(ApacheMultipartParser.MULTIPART)) {
                throw new InvalidContentTypeException("the request doesn't contain a multipart/form-data or multipart/mixed stream, content type header is " + contentType);
            }
            if (ApacheMultipartParser.this.sizeMax >= 0L) {
                input = new LimitedInputStream(input, ApacheMultipartParser.this.sizeMax){

                    protected void raiseError(long pSizeMax, long pCount) throws IOException {
                        SizeLimitExceededException ex = new SizeLimitExceededException("the request was rejected because its size (" + pCount + ") exceeds the configured maximum" + " (" + pSizeMax + ")", pCount, pSizeMax);
                        throw new FileUploadIOException(ex);
                    }
                };
            }
            this.boundary = ApacheMultipartParser.this.getBoundary(contentType);
            if (this.boundary == null) {
                throw new FileUploadException("the request was rejected because no multipart boundary was found");
            }
            this.multi = new MultipartStream(input, this.boundary, 4096, null);
            this.multi.setHeaderEncoding(charEncoding);
            this.skipPreamble = true;
            this.findNextItem();
        }

        private boolean findNextItem() throws IOException {
            if (this.eof) {
                return false;
            }
            if (this.currentItem != null) {
                this.currentItem.close();
                this.currentItem = null;
            }
            while (true) {
                boolean nextPart;
                if (!(nextPart = this.skipPreamble ? this.multi.skipPreamble() : this.multi.readBoundary())) {
                    if (this.currentFieldName == null) {
                        this.eof = true;
                        return false;
                    }
                    this.multi.setBoundary(this.boundary);
                    this.currentFieldName = null;
                    continue;
                }
                Map headers = ApacheMultipartParser.this.parseHeaders(this.multi.readHeaders());
                if (this.currentFieldName == null) {
                    String fieldName = ApacheMultipartParser.this.getFieldName(headers);
                    if (fieldName != null) {
                        String subContentType = ApacheMultipartParser.this.getHeader(headers, ApacheMultipartParser.CONTENT_TYPE);
                        if (subContentType != null && subContentType.toLowerCase().startsWith(ApacheMultipartParser.MULTIPART_MIXED)) {
                            this.currentFieldName = fieldName;
                            byte[] subBoundary = ApacheMultipartParser.this.getBoundary(subContentType);
                            this.multi.setBoundary(subBoundary);
                            this.skipPreamble = true;
                            continue;
                        }
                        String fileName = ApacheMultipartParser.this.getFileName(headers);
                        this.currentItem = new FileItemStreamImpl(fileName, fieldName, ApacheMultipartParser.this.getHeader(headers, ApacheMultipartParser.CONTENT_TYPE), fileName == null);
                        this.itemValid = true;
                        return true;
                    }
                } else {
                    String fileName = ApacheMultipartParser.this.getFileName(headers);
                    if (fileName != null) {
                        this.currentItem = new FileItemStreamImpl(fileName, this.currentFieldName, ApacheMultipartParser.this.getHeader(headers, ApacheMultipartParser.CONTENT_TYPE), false);
                        this.itemValid = true;
                        return true;
                    }
                }
                this.multi.discardBodyData();
            }
        }

        public boolean hasNext() throws FileUploadException, IOException {
            return !this.eof && (this.itemValid || this.findNextItem());
        }

        public FileItemStream next() throws FileUploadException, IOException {
            if (this.eof || !this.itemValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.itemValid = false;
            return this.currentItem;
        }

        private class FileItemStreamImpl
        implements FileItemStream {
            private final String contentType;
            private final String fieldName;
            private final String name;
            private final boolean formField;
            private final InputStream stream;
            private boolean opened;
            private FileItemHeaders fileItemHeaders;

            FileItemStreamImpl(String pName, String pFieldName, String pContentType, boolean pFormField) {
                this.name = pName;
                this.fieldName = pFieldName;
                this.contentType = pContentType;
                this.formField = pFormField;
                MultipartStream.ItemInputStream istream = FileItemIteratorImpl.this.multi.newInputStream();
                if (ApacheMultipartParser.this.fileSizeMax != -1L) {
                    istream = new LimitedInputStream(istream, ApacheMultipartParser.this.fileSizeMax){

                        protected void raiseError(long pSizeMax, long pCount) throws IOException {
                            FileSizeLimitExceededException e = new FileSizeLimitExceededException("The field " + FileItemStreamImpl.this.fieldName + " exceeds its maximum permitted " + " size of " + pSizeMax + " characters.", pCount, pSizeMax);
                            throw new FileUploadIOException(e);
                        }
                    };
                }
                this.stream = istream;
            }

            public FileItemHeaders getHeaders() {
                return this.fileItemHeaders;
            }

            public void setHeaders(FileItemHeaders fileItemHeaders) {
                this.fileItemHeaders = fileItemHeaders;
            }

            public String getContentType() {
                return this.contentType;
            }

            public String getFieldName() {
                return this.fieldName;
            }

            public String getName() {
                return this.name;
            }

            public boolean isFormField() {
                return this.formField;
            }

            public InputStream openStream() throws IOException {
                if (this.opened) {
                    throw new IllegalStateException("The stream was already opened.");
                }
                if (((Closeable)this.stream).isClosed()) {
                    throw new FileItemStream.ItemSkippedException();
                }
                return this.stream;
            }

            void close() throws IOException {
                this.stream.close();
            }
        }
    }
}

