/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.conf.AppConfig;
import act.util.ActContext;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

public abstract class DateResolverBase<T extends Date>
extends StringValueResolver<T> {
    static Logger logger = L.get(DateResolverBase.class);
    private ConcurrentMap<Locale, DateFormat> localizedDateFormats = new ConcurrentHashMap<Locale, DateFormat>();
    protected DateFormat dateFormat;
    protected DateFormat dateFormat2;
    private boolean i18n;
    private Locale defLocale;
    protected AppConfig config;

    public DateResolverBase(AppConfig config) {
        this.i18n = config.i18nEnabled();
        this.config = config;
        this.defLocale = config.locale();
        String pattern = this.configuredPattern(config);
        if (null == pattern || pattern.contains("8601") || pattern.contains("iso")) {
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            this.dateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        } else {
            this.dateFormat = new SimpleDateFormat(pattern);
        }
    }

    public DateResolverBase(String pattern) {
        this.dateFormat = new SimpleDateFormat(pattern);
    }

    public final T resolve(String value) {
        if (S.blank((String)value)) {
            return null;
        }
        Date date = this.parse(value);
        if (null == date) {
            return null;
        }
        return this.cast(date);
    }

    protected String configuredPattern(AppConfig config) {
        return config.dateTimePattern();
    }

    protected abstract T cast(Date var1);

    private Date parse(String value) {
        DateFormat dateFormat = this.dateFormat();
        try {
            return dateFormat.parse(value);
        }
        catch (ParseException e) {
            if (null == this.dateFormat2) {
                logger.error("error parsing date value from: %s", new Object[]{value});
                return null;
            }
            try {
                return this.dateFormat2.parse(value);
            }
            catch (ParseException e2) {
                logger.error("error parsing date value from: %s", new Object[]{value});
                return null;
            }
        }
    }

    private DateFormat dateFormat() {
        String pattern;
        ActContext.Base<?> ctx = ActContext.Base.currentContext();
        String string = pattern = null == ctx ? null : ctx.dateFormatPattern();
        if (S.notBlank((String)pattern)) {
            return new SimpleDateFormat(pattern);
        }
        if (!this.i18n) {
            return this.dateFormat;
        }
        if (null == ctx) {
            return this.dateFormat;
        }
        Locale locale = ctx.locale();
        if (null == locale) {
            return this.dateFormat;
        }
        if (locale.equals(this.defLocale)) {
            return this.dateFormat;
        }
        return this.dateFormat(locale);
    }

    protected DateFormat dateFormat(Locale locale) {
        DateFormat dateFormat = (DateFormat)this.localizedDateFormats.get(locale);
        if (null == dateFormat) {
            String s = this.localizedPattern(locale);
            dateFormat = new SimpleDateFormat(s);
            this.localizedDateFormats.putIfAbsent(locale, dateFormat);
        }
        return dateFormat;
    }

    protected String localizedPattern(Locale locale) {
        return this.config.localizedDateTimePattern(locale);
    }
}

