/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.Act;
import act.conf.AppConfig;
import act.data.DateTimeStyle;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.osgl.util.E;
import org.osgl.util.S;

public enum DateTimeType {
    DATE{

        @Override
        public String defaultPattern(AppConfig config) {
            return config.datePattern();
        }

        @Override
        public String defaultPattern(AppConfig config, Locale locale) {
            return config.localizedDatePattern(locale);
        }

        @Override
        protected String defaultLongPattern(Locale locale) {
            return ((SimpleDateFormat)DateFormat.getDateInstance(1, locale)).toPattern();
        }

        @Override
        protected String defaultMediumPattern(Locale locale) {
            return ((SimpleDateFormat)DateFormat.getDateInstance(2, locale)).toPattern();
        }

        @Override
        protected String defaultShortPattern(Locale locale) {
            return ((SimpleDateFormat)DateFormat.getDateInstance(3, locale)).toPattern();
        }
    }
    ,
    TIME{

        @Override
        public String defaultPattern(AppConfig config) {
            return config.timePattern();
        }

        @Override
        public String defaultPattern(AppConfig config, Locale locale) {
            return config.localizedTimePattern(locale);
        }

        @Override
        protected String defaultLongPattern(Locale locale) {
            return ((SimpleDateFormat)DateFormat.getTimeInstance(1, locale)).toPattern();
        }

        @Override
        protected String defaultMediumPattern(Locale locale) {
            return ((SimpleDateFormat)DateFormat.getTimeInstance(2, locale)).toPattern();
        }

        @Override
        protected String defaultShortPattern(Locale locale) {
            return ((SimpleDateFormat)DateFormat.getTimeInstance(3, locale)).toPattern();
        }
    }
    ,
    DATE_TIME{

        @Override
        public String defaultPattern(AppConfig config) {
            return config.dateTimePattern();
        }

        @Override
        public String defaultPattern(AppConfig config, Locale locale) {
            return config.localizedDateTimePattern(locale);
        }

        @Override
        protected String defaultLongPattern(Locale locale) {
            return ((SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1, locale)).toPattern();
        }

        @Override
        protected String defaultMediumPattern(Locale locale) {
            return ((SimpleDateFormat)DateFormat.getDateTimeInstance(2, 2, locale)).toPattern();
        }

        @Override
        protected String defaultShortPattern(Locale locale) {
            return ((SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, locale)).toPattern();
        }
    };

    private volatile DateTimeFormatter defaultJodaFormatter;

    public String suffix() {
        if (DATE == this) {
            return ".date";
        }
        if (TIME == this) {
            return ".time";
        }
        return ".date_time";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateTimeFormatter defaultJodaFormatter() {
        if (null == this.defaultJodaFormatter) {
            DateTimeType dateTimeType = this;
            synchronized (dateTimeType) {
                if (null == this.defaultJodaFormatter) {
                    this.defaultJodaFormatter = this.createDefaultJodaFormatter(Act.appConfig());
                }
            }
        }
        return this.defaultJodaFormatter;
    }

    public String defaultPattern(DateTimeStyle style, Locale locale) {
        int styleId;
        int n = styleId = null == style ? 2 : style.id();
        if (DATE == this) {
            return ((SimpleDateFormat)DateFormat.getDateInstance(styleId, locale)).toPattern();
        }
        if (TIME == this) {
            return ((SimpleDateFormat)DateFormat.getTimeInstance(styleId, locale)).toPattern();
        }
        return ((SimpleDateFormat)DateFormat.getDateTimeInstance(styleId, styleId, locale)).toPattern();
    }

    public String sanitizePattern(String dateTimePattern) {
        if (S.blank((String)dateTimePattern)) {
            return null;
        }
        if (DATE == this ? dateTimePattern.contains("h") || dateTimePattern.contains("H") || dateTimePattern.contains("m") || dateTimePattern.contains("s") || dateTimePattern.contains("S") : TIME == this && (dateTimePattern.contains("M") || dateTimePattern.contains("y") || dateTimePattern.contains("d") || dateTimePattern.contains("Y") || dateTimePattern.contains("c") || dateTimePattern.contains("e") || dateTimePattern.contains("x") || dateTimePattern.contains("C") || dateTimePattern.contains("D") || dateTimePattern.contains("F") || dateTimePattern.contains("w") || dateTimePattern.contains("W") || dateTimePattern.contains("k") || dateTimePattern.contains("K"))) {
            return null;
        }
        return dateTimePattern;
    }

    public abstract String defaultPattern(AppConfig var1, Locale var2);

    protected abstract String defaultPattern(AppConfig var1);

    protected abstract String defaultLongPattern(Locale var1);

    protected abstract String defaultMediumPattern(Locale var1);

    protected abstract String defaultShortPattern(Locale var1);

    protected DateTimeFormatter createDefaultJodaFormatter(AppConfig config) {
        String pattern = this.defaultPattern(config);
        return DateTimeFormat.forPattern((String)pattern).withLocale(config.locale());
    }

    public static DateTimeType of(ReadablePartial partial) {
        E.NPE((Object)partial);
        if (partial instanceof LocalDate) {
            return DATE;
        }
        if (partial instanceof LocalTime) {
            return TIME;
        }
        if (partial instanceof LocalDateTime) {
            return DATE_TIME;
        }
        throw E.unsupport((String)("ReadablePartial not supported: " + partial.getClass()), (Object[])new Object[0]);
    }
}

