/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.conf.AppConfig;
import act.data.DateTimeType;
import act.data.JodaDateTimeCodecBase;
import act.data.JodaReadablePatialCodecBase;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@Singleton
public class JodaLocalDateCodec
extends JodaReadablePatialCodecBase<LocalDate> {
    public JodaLocalDateCodec(DateTimeFormatter formatter) {
        super(formatter);
    }

    public JodaLocalDateCodec(String pattern) {
        super(pattern);
    }

    @Inject
    public JodaLocalDateCodec(AppConfig config) {
        this(config.datePattern());
    }

    @Override
    protected JodaDateTimeCodecBase<LocalDate> create(String pattern) {
        return new JodaLocalDateCodec(pattern);
    }

    @Override
    protected LocalDate parse(DateTimeFormatter formatter, String value) {
        return formatter.parseLocalDate(value);
    }

    @Override
    protected DateTimeFormatter isoFormatter() {
        return ISODateTimeFormat.localDateParser();
    }

    @Override
    protected LocalDate now() {
        return LocalDate.now();
    }

    @Override
    protected String sanitize(String dateTimePattern) {
        return DateTimeType.DATE.sanitizePattern(dateTimePattern);
    }

    @Override
    protected String dateTimePattern(AppConfig config, Locale locale) {
        return config.localizedDatePattern(locale);
    }
}

