/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.conf.AppConfig;
import act.data.DateTimeType;
import act.data.JodaDateTimeCodecBase;
import act.data.JodaReadablePatialCodecBase;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@Singleton
public class JodaLocalTimeCodec
extends JodaReadablePatialCodecBase<LocalTime> {
    private boolean isIso;

    public JodaLocalTimeCodec(DateTimeFormatter formatter, boolean isIso) {
        super(formatter);
        this.isIso = isIso;
    }

    public JodaLocalTimeCodec(String pattern) {
        super(pattern);
        this.isIso = JodaLocalTimeCodec.isIsoStandard(pattern);
    }

    @Inject
    public JodaLocalTimeCodec(AppConfig config) {
        this(config.timePattern());
    }

    @Override
    protected LocalTime parse(DateTimeFormatter formatter, String value) {
        if (formatter == this.formatter) {
            String amended = this.isIso && !value.endsWith("Z") ? value + "Z" : value;
            return formatter.parseLocalTime(amended);
        }
        return formatter.parseLocalTime(value);
    }

    @Override
    protected DateTimeFormatter isoFormatter() {
        return ISODateTimeFormat.timeNoMillis();
    }

    @Override
    protected LocalTime now() {
        return LocalTime.now();
    }

    @Override
    protected JodaDateTimeCodecBase<LocalTime> create(String pattern) {
        return new JodaLocalTimeCodec(pattern);
    }

    @Override
    protected String sanitize(String dateTimePattern) {
        return DateTimeType.TIME.sanitizePattern(dateTimePattern);
    }

    @Override
    protected String dateTimePattern(AppConfig config, Locale locale) {
        return config.localizedTimePattern(locale);
    }
}

