/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.app.ActionContext;
import act.data.MapUtil;
import act.data.RequestBodyParser;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osgl.exception.UnexpectedException;
import org.osgl.http.H;
import org.osgl.mvc.result.ErrorResult;
import org.osgl.mvc.result.Result;
import org.osgl.util.C;
import org.osgl.util.Codec;

public class UrlEncodedParser
extends RequestBodyParser {
    boolean forQueryString = false;

    @Override
    public Map<String, String[]> parse(ActionContext context) {
        H.Request request = context.req();
        String encoding = request.characterEncoding();
        InputStream is = request.inputStream();
        try {
            int bytesRead;
            LinkedHashMap<String, String[]> params = new LinkedHashMap<String, String[]>();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = is.read(buffer)) > 0) {
                os.write(buffer, 0, bytesRead);
            }
            String data = new String(os.toByteArray(), encoding);
            if (data.length() == 0) {
                return new HashMap<String, String[]>(0);
            }
            if (data.startsWith("{") && data.endsWith("}") || data.startsWith("[") && data.endsWith("]")) {
                return C.Map((Object[])new Object[]{"_body", new String[]{data}});
            }
            String[] keyValues = data.split("&");
            int httpMaxParams = context.app().config().httpMaxParams();
            if (httpMaxParams != 0 && keyValues.length > httpMaxParams) {
                logger.warn("Number of request parameters %d is higher than maximum of %d, aborting. Can be configured using 'act.http.params.max'", new Object[]{keyValues.length, httpMaxParams});
                throw new ErrorResult(H.Status.valueOf((int)413));
            }
            for (String keyValue : keyValues) {
                int i = keyValue.indexOf(61);
                String key2 = null;
                String value = null;
                if (i > 0) {
                    key2 = keyValue.substring(0, i);
                    value = keyValue.substring(i + 1);
                } else {
                    key2 = keyValue;
                }
                if (key2.length() <= 0) continue;
                MapUtil.mergeValueInMap(params, key2, value);
            }
            Charset charset = Charset.forName(encoding);
            if (params.containsKey("_charset_")) {
                String providedCharset = ((String[])params.get("_charset_"))[0];
                try {
                    "test".getBytes(providedCharset);
                    charset = Charset.forName(providedCharset);
                }
                catch (Exception e) {
                    logger.debug("Got invalid _charset_ in form: " + providedCharset);
                }
            }
            LinkedHashMap<String, String[]> decodedParams = new LinkedHashMap<String, String[]>(params.size());
            for (Map.Entry e : params.entrySet()) {
                String key = (String)e.getKey();
                try {
                    key = Codec.decodeUrl((String)((String)e.getKey()), (Charset)charset);
                }
                catch (Throwable key2) {
                    // empty catch block
                }
                for (String value : (String[])e.getValue()) {
                    try {
                        MapUtil.mergeValueInMap(decodedParams, key, value == null ? null : Codec.decodeUrl((String)value, (Charset)charset));
                    }
                    catch (Throwable z) {
                        MapUtil.mergeValueInMap(decodedParams, key, value);
                    }
                }
            }
            if (!this.forQueryString) {
                decodedParams.put("_body", new String[]{data});
            }
            return decodedParams;
        }
        catch (Result s) {
            throw s;
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }
}

