/*
 * Decompiled with CFR 0.152.
 */
package act.db;

import act.Act;
import act.app.App;
import act.db.Model;
import act.plugin.AppServicePlugin;
import act.util.SimpleBean;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.beans.Transient;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.inject.BeanSpec;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;
import org.osgl.util.ValueObject;

public interface AdaptiveRecord<ID_TYPE, MODEL_TYPE extends AdaptiveRecord>
extends Model<ID_TYPE, MODEL_TYPE> {
    public Map<String, Object> internalMap();

    public MODEL_TYPE putValue(String var1, Object var2);

    public MODEL_TYPE mergeValue(String var1, Object var2);

    public MODEL_TYPE putValues(Map<String, Object> var1);

    public MODEL_TYPE mergeValues(Map<String, Object> var1);

    public <T> T getValue(String var1);

    public Map<String, Object> toMap();

    public int size();

    public boolean containsKey(String var1);

    public Set<String> keySet();

    public Set<Map.Entry<String, Object>> entrySet();

    public Set<Map.Entry<String, Object>> entrySet(Lang.Function<BeanSpec, Boolean> var1);

    public Map<String, Object> asMap();

    @Transient
    public MetaInfo metaInfo();

    public static class MetaInfo {
        private Class<? extends AdaptiveRecord> arClass;
        public String className;
        public Map<String, BeanSpec> getterFieldSpecs;
        public Map<String, Class> getterFieldClasses;
        public Map<String, BeanSpec> setterFieldSpecs;
        public Map<String, Class> setterFieldClasses;
        public Map<String, Lang.Function> fieldGetters;
        public Map<String, Lang.Func2> fieldSetters;
        public Map<String, Lang.Func2> fieldMergers;
        private SimpleBean.MetaInfo metaInfo;

        public MetaInfo(Class<? extends AdaptiveRecord> clazz) {
            this.className = clazz.getName();
            this.metaInfo = Act.app().classLoader().simpleBeanInfoManager().get(this.className);
            this.arClass = clazz;
            this.discoverProperties(clazz);
        }

        @Deprecated
        public Class fieldClass(String fieldName) {
            Class clazz = this.setterFieldClasses.get(fieldName);
            return null == clazz ? this.getterFieldClasses.get(fieldName) : clazz;
        }

        public Class getterFieldClass(String fieldName) {
            return this.getterFieldClasses.get(fieldName);
        }

        public Class setterFieldClass(String fieldName) {
            return this.setterFieldClasses.get(fieldName);
        }

        public Type getterFieldType(String fieldName) {
            BeanSpec spec = this.getterFieldSpecs.get(fieldName);
            return null == spec ? null : spec.type();
        }

        public Type setterFieldType(String fieldName) {
            BeanSpec spec = this.setterFieldSpecs.get(fieldName);
            return null == spec ? null : spec.type();
        }

        private void discoverProperties(Class<? extends AdaptiveRecord> clazz) {
            this.getterFieldSpecs = new HashMap<String, BeanSpec>();
            this.getterFieldClasses = new HashMap<String, Class>();
            this.setterFieldSpecs = new HashMap<String, BeanSpec>();
            this.setterFieldClasses = new HashMap<String, Class>();
            this.fieldGetters = new HashMap<String, Lang.Function>();
            this.fieldSetters = new HashMap<String, Lang.Func2>();
            this.fieldMergers = new HashMap<String, Lang.Func2>();
            Object injector = Act.app().injector();
            for (final Method m : clazz.getMethods()) {
                Class<?> fieldType;
                boolean hasAlias;
                String name = this.propertyName(m);
                if (S.blank((String)name)) continue;
                name = S.lowerFirst((String)name);
                String alias = null == this.metaInfo ? name : this.metaInfo.aliasOf(name);
                boolean bl = hasAlias = name != alias;
                if ("idAsStr".equals(name)) continue;
                Class<?> returnClass = m.getReturnType();
                Class<?> returnType = m.getGenericReturnType();
                Class<?> paramClass = null;
                Type paramType = null;
                Class<?>[] params = m.getParameterTypes();
                Type[] paramTypes = m.getGenericParameterTypes();
                if (null != params && params.length == 1) {
                    paramClass = params[0];
                    paramType = paramTypes[0];
                }
                Class<?> fieldClass = null == paramClass ? returnClass : paramClass;
                Type type = fieldType = null == paramType ? returnType : paramType;
                if (!(fieldType instanceof ParameterizedType)) {
                    fieldType = fieldClass;
                }
                if (null == paramClass) {
                    BeanSpec spec = BeanSpec.of(fieldType, (Annotation[])m.getDeclaredAnnotations(), (String)name, injector);
                    this.getterFieldSpecs.put(name, spec);
                    this.getterFieldClasses.put(name, fieldClass);
                    if (hasAlias) {
                        this.getterFieldSpecs.put(alias, spec);
                        this.getterFieldClasses.put(alias, fieldClass);
                    }
                } else {
                    BeanSpec existingSpec = this.setterFieldSpecs.get(name);
                    if (null == existingSpec && hasAlias) {
                        existingSpec = this.setterFieldSpecs.get(alias);
                    }
                    if (null != existingSpec) {
                        BeanSpec spec;
                        Field field = $.fieldOf(clazz, (String)name, (boolean)true);
                        if (null != field) {
                            spec = BeanSpec.of((Field)field, injector);
                            this.setterFieldSpecs.put(name, spec);
                            this.setterFieldClasses.put(name, field.getType());
                            if (hasAlias) {
                                this.setterFieldSpecs.put(alias, spec);
                                this.setterFieldClasses.put(alias, field.getType());
                            }
                        } else if (fieldClass != Object.class && existingSpec.rawType() == Object.class) {
                            spec = BeanSpec.of(fieldType, (Annotation[])m.getDeclaredAnnotations(), (String)name, injector);
                            this.setterFieldSpecs.put(name, spec);
                            this.setterFieldClasses.put(name, fieldClass);
                            if (hasAlias) {
                                this.setterFieldSpecs.put(alias, spec);
                                this.setterFieldClasses.put(alias, fieldClass);
                            }
                        }
                    } else {
                        BeanSpec spec = BeanSpec.of(fieldType, (Annotation[])m.getDeclaredAnnotations(), (String)name, injector);
                        this.setterFieldSpecs.put(name, spec);
                        this.setterFieldClasses.put(name, fieldClass);
                        if (hasAlias) {
                            this.setterFieldSpecs.put(alias, spec);
                            this.setterFieldClasses.put(alias, fieldClass);
                        }
                    }
                }
                if (null != paramClass) {
                    final String fieldName = name;
                    Object fn = new Lang.Func2(){

                        public Object apply(Object host, Object value) throws NotAppliedException, Lang.Break {
                            BeanSpec spec = MetaInfo.this.setterFieldSpecs.get(fieldName);
                            if (null != value && !spec.isInstance(value)) {
                                if (value instanceof String) {
                                    value = Act.app().resolverManager().resolve((String)value, spec.rawType());
                                } else if (value instanceof JSONObject) {
                                    value = JSON.parseObject((String)((JSONObject)value).toJSONString(), (Class)spec.rawType());
                                }
                            }
                            $.invokeVirtual((Object)host, (Method)m, (Object[])new Object[]{value});
                            return null;
                        }
                    };
                    this.fieldSetters.put(name, (Lang.Func2)fn);
                    if (hasAlias) {
                        this.fieldSetters.put(alias, (Lang.Func2)fn);
                    }
                    fn = new Lang.Func2(){

                        public Object apply(Object host, Object value) throws NotAppliedException, Lang.Break {
                            Lang.Function getter;
                            BeanSpec spec = MetaInfo.this.setterFieldSpecs.get(fieldName);
                            if (null != value && !spec.isInstance(value) && value instanceof String) {
                                value = Act.app().resolverManager().resolve((String)value, spec.rawType());
                            }
                            if (null == (getter = MetaInfo.this.fieldGetters.get(fieldName))) {
                                $.invokeVirtual((Object)host, (Method)m, (Object[])new Object[]{value});
                                return null;
                            }
                            Object value0 = getter.apply(host);
                            value = MetaInfo.merge(value0, value);
                            $.invokeVirtual((Object)host, (Method)m, (Object[])new Object[]{value});
                            return null;
                        }
                    };
                    this.fieldMergers.put(name, (Lang.Func2)fn);
                    if (!hasAlias) continue;
                    this.fieldMergers.put(alias, (Lang.Func2)fn);
                    continue;
                }
                Lang.F1 fn = new Lang.F1(){

                    public Object apply(Object host) throws NotAppliedException, Lang.Break {
                        return $.invokeVirtual((Object)host, (Method)m, (Object[])new Object[0]);
                    }
                };
                this.fieldGetters.put(name, (Lang.Function)fn);
                if (!hasAlias) continue;
                this.fieldGetters.put(alias, (Lang.Function)fn);
            }
        }

        private String propertyName(Method m) {
            String name = m.getName();
            if ("getClass".equals(name)) {
                return null;
            }
            Type[] paramTypes = m.getGenericParameterTypes();
            if (name.startsWith("set") && Void.TYPE == m.getReturnType() && null != paramTypes && paramTypes.length == 1) {
                return name.substring(3);
            }
            boolean isGet = name.startsWith("get");
            boolean isIs = name.startsWith("is");
            if ((isGet || isIs) && Void.TYPE != m.getReturnType() && (null == paramTypes || paramTypes.length == 0)) {
                return isGet ? name.substring(3) : name.substring(2);
            }
            return null;
        }

        public static Object merge(Object to, Object from) {
            if (null == to) {
                return from;
            }
            if (null == from) {
                return to;
            }
            if (MetaInfo.canBeMerged(to.getClass())) {
                return MetaInfo._merge(to, from);
            }
            return from;
        }

        private static Object _merge(Object to, Object from) {
            if (to instanceof ValueObject) {
                if (from instanceof ValueObject) {
                    return ValueObject.of((Object)MetaInfo.merge(((ValueObject)to).value(), ((ValueObject)from).value()));
                }
                return ValueObject.of((Object)MetaInfo.merge(((ValueObject)to).value(), from));
            }
            if (to instanceof AdaptiveRecord) {
                AdaptiveRecord ar = (AdaptiveRecord)to;
                return MetaInfo.mergeIntoAdaptiveRecord(ar, from);
            }
            if (to instanceof Map) {
                Map map = (Map)to;
                return MetaInfo.mergeIntoMap(map, from);
            }
            if (to instanceof Set) {
                Set set = (Set)to;
                return MetaInfo.mergeIntoSet(set, from);
            }
            if (to instanceof List) {
                List list = (List)to;
                return MetaInfo.mergeIntoList(list, from);
            }
            if (to.getClass().isArray()) {
                ArrayList<Object> list = new ArrayList<Object>();
                int len = Array.getLength(to);
                for (int i = 0; i < len; ++i) {
                    list.add(Array.get(to, i));
                }
                List list1 = MetaInfo.mergeIntoList(list, from);
                int sz1 = list1.size();
                Object a1 = Array.newInstance(to.getClass().getComponentType(), sz1);
                for (int i = 0; i < sz1; ++i) {
                    Array.set(a1, i, list1.get(i));
                }
                return a1;
            }
            return MetaInfo.mergeIntoPojo(to, from);
        }

        private static String getterName(Field field) {
            boolean isBoolean = field.getType() == Boolean.class || field.getType() == Boolean.TYPE;
            return (isBoolean ? "is" : "get") + S.capFirst((String)field.getName());
        }

        private static String setterName(Field field) {
            return "set" + S.capFirst((String)field.getName());
        }

        private static boolean canBeMerged(Class<?> c) {
            return !$.isSimpleType(c) && !MetaInfo.isDateType(c);
        }

        private static boolean isDateType(Class<?> c) {
            String name = c.getSimpleName();
            return name.endsWith("Date") || name.endsWith("DateTime") || name.endsWith("Calendar");
        }

        private static AdaptiveRecord mergeIntoAdaptiveRecord(AdaptiveRecord ar, Object value) {
            if (value instanceof Map) {
                return MetaInfo.mergeMapIntoAdaptiveRecord(ar, (Map)value);
            }
            if (value instanceof AdaptiveRecord) {
                return MetaInfo.mergeMapIntoAdaptiveRecord(ar, ((AdaptiveRecord)value).asMap());
            }
            List fields = $.fieldsOf(value.getClass(), (boolean)true);
            for (Field f2 : fields) {
                f2.setAccessible(true);
                try {
                    String fn = f2.getName();
                    Object fv = f2.get(value);
                    Object o0 = ar.getValue(fn);
                    ar.putValue(fn, MetaInfo.merge(o0, fv));
                }
                catch (IllegalAccessException e) {
                    throw E.unexpected((Throwable)e, (String)"error merging into adaptive record", (Object[])new Object[0]);
                }
            }
            return ar;
        }

        private static AdaptiveRecord mergeMapIntoAdaptiveRecord(AdaptiveRecord ar, Map map) {
            return ar.putValues(map);
        }

        private static Map mergeIntoMap(Map map, Object value) {
            if (value instanceof Map) {
                return MetaInfo.mergeMapIntoMap(map, (Map)value);
            }
            if (value instanceof AdaptiveRecord) {
                return MetaInfo.mergeMapIntoMap(map, ((AdaptiveRecord)value).asMap());
            }
            HashMap<String, Object> retval = new HashMap<String, Object>(map);
            List fields = $.fieldsOf(value.getClass(), (boolean)true);
            for (Field f2 : fields) {
                f2.setAccessible(true);
                try {
                    String fn = f2.getName();
                    Object fv = f2.get(value);
                    Object o0 = map.get(fn);
                    retval.put(fn, MetaInfo.merge(o0, fv));
                }
                catch (IllegalAccessException e) {
                    throw E.unexpected((Throwable)e, (String)"error merging into adaptive record", (Object[])new Object[0]);
                }
            }
            return retval;
        }

        private static Map mergeMapIntoMap(Map m0, Map<?, ?> m1) {
            Map retval = (Map)Act.injector().get(m0.getClass());
            retval.putAll(m0);
            for (Map.Entry<?, ?> entry : m1.entrySet()) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                retval.put(k, MetaInfo.merge(m0.get(k), v));
            }
            return retval;
        }

        private static Set mergeIntoSet(Set set, Object value) {
            if (value instanceof Collection) {
                return MetaInfo.mergeCollectionIntoSet(set, (Collection)value);
            }
            if (value.getClass().isArray()) {
                ArrayList<Object> list = new ArrayList<Object>();
                int len = Array.getLength(value);
                for (int i = 0; i < len; ++i) {
                    list.add(Array.get(value, i));
                }
                return MetaInfo.mergeCollectionIntoSet(set, list);
            }
            throw new IllegalArgumentException("Cannot merge " + value.getClass() + " into Set");
        }

        private static Set mergeCollectionIntoSet(Set set, Collection col) {
            Set set1 = (Set)Act.injector().get(set.getClass());
            set1.addAll(col);
            return set1;
        }

        private static List mergeIntoList(List list, Object value) {
            if (value instanceof Set) {
                return MetaInfo.mergeSetIntoList(list, (Set)value);
            }
            if (value instanceof List) {
                return MetaInfo.mergeListIntoList(list, (List)value);
            }
            if (value.getClass().isArray()) {
                ArrayList<Object> list0 = new ArrayList<Object>();
                int len = Array.getLength(value);
                for (int i = 0; i < len; ++i) {
                    list0.add(Array.get(value, i));
                }
                return MetaInfo.mergeListIntoList(list, list0);
            }
            throw new IllegalArgumentException("Cannot merge " + value.getClass() + " into List");
        }

        private static List mergeSetIntoList(List list, Set set) {
            List retval = (List)Act.injector().get(list.getClass());
            retval.addAll(list);
            retval.addAll(set);
            return retval;
        }

        private static List mergeListIntoList(List to, List from) {
            List retval;
            block4: {
                int i;
                int szFrom;
                int szTo;
                block3: {
                    retval = (List)Act.injector().get(to.getClass());
                    szTo = to.size();
                    szFrom = from.size();
                    int szMin = Math.min(szTo, szFrom);
                    for (i = 0; i < szMin; ++i) {
                        Object o0 = to.get(i);
                        Object o1 = from.get(i);
                        retval.add(MetaInfo.merge(o0, o1));
                    }
                    if (szTo <= szFrom) break block3;
                    for (i = szMin; i < szTo; ++i) {
                        retval.add(to.get(i));
                    }
                    break block4;
                }
                if (szFrom <= szTo) break block4;
                for (i = szMin; i < szFrom; ++i) {
                    retval.add(from.get(i));
                }
            }
            return retval;
        }

        private static Object mergeIntoPojo(Object o0, Object o1) {
            if (o1 instanceof Map) {
                return MetaInfo.mergeMapIntoPojo(o0, (Map)o1);
            }
            if (o1 instanceof AdaptiveRecord) {
                return MetaInfo.mergeMapIntoPojo(o0, ((AdaptiveRecord)o1).asMap());
            }
            if (o1 instanceof Collection || o1.getClass().isArray()) {
                throw E.unexpected((String)("cannot merge " + o1.getClass() + " into " + o0.getClass()), (Object[])new Object[0]);
            }
            Class<?> c0 = o0.getClass();
            List fields = $.fieldsOf(o1.getClass(), (boolean)true);
            for (Field f2 : fields) {
                f2.setAccessible(true);
                try {
                    String fn = f2.getName();
                    Field f0 = $.fieldOf(c0, (String)fn);
                    if (null == f0) continue;
                    Object fv = f2.get(o1);
                    f0.setAccessible(true);
                    Object fv0 = MetaInfo.merge(f0.get(o0), fv);
                    f0.set(o0, fv0);
                }
                catch (IllegalAccessException e) {
                    throw E.unexpected((Throwable)e, (String)"error merging into POJO", (Object[])new Object[0]);
                }
            }
            return o0;
        }

        private static Object mergeMapIntoPojo(Object o0, Map map) {
            List fields = $.fieldsOf(o0.getClass(), (boolean)true);
            for (Field f2 : fields) {
                String fn = f2.getName();
                if (!map.containsKey(fn)) continue;
                f2.setAccessible(true);
                try {
                    Object v = f2.get(o0);
                    f2.set(o0, MetaInfo.merge(v, map.get(fn)));
                }
                catch (IllegalAccessException e) {
                    throw E.unexpected((Throwable)e, (String)"error merging into POJO", (Object[])new Object[0]);
                }
            }
            return o0;
        }

        public static class Repository
        extends AppServicePlugin {
            private ConcurrentMap<Class<?>, MetaInfo> map = new ConcurrentHashMap();

            @Override
            protected void applyTo(App app) {
            }

            public MetaInfo get(Class<? extends AdaptiveRecord> clazz, Lang.Function<Class<? extends AdaptiveRecord>, MetaInfo> factory) {
                MetaInfo theInfo;
                MetaInfo info = (MetaInfo)this.map.get(clazz);
                if (null == info && null == (info = this.map.putIfAbsent(clazz, theInfo = (MetaInfo)factory.apply(clazz)))) {
                    info = theInfo;
                }
                return info;
            }
        }
    }

    public static class Util {
        public static <MODEL_TYPE extends AdaptiveRecord> MODEL_TYPE putValue(MODEL_TYPE ar, String key, Object val) {
            Map<String, Object> kv = ar.internalMap();
            Lang.Func2 setter = ar.metaInfo().fieldSetters.get(key);
            if (null != setter) {
                setter.apply(ar, val);
            } else {
                kv.put(key, val);
            }
            return ar;
        }

        public static <MODEL_TYPE extends AdaptiveRecord> MODEL_TYPE mergeValue(MODEL_TYPE ar, String key, Object val) {
            Map<String, Object> kv = ar.internalMap();
            Lang.Func2 merger = ar.metaInfo().fieldMergers.get(key);
            if (null != merger) {
                merger.apply(ar, val);
            } else {
                Object v0 = kv.get(key);
                kv.put(key, MetaInfo.merge(v0, val));
            }
            return ar;
        }

        public static <MODEL_TYPE extends AdaptiveRecord, T> T getValue(MODEL_TYPE ar, String key) {
            Map<String, Object> kv = ar.internalMap();
            Lang.Function getter = ar.metaInfo().fieldGetters.get(key);
            if (null != getter) {
                return (T)getter.apply(ar);
            }
            return (T)kv.get(key);
        }

        public static <MODEL_TYPE extends AdaptiveRecord> MODEL_TYPE putValues(MODEL_TYPE ar, Map<String, Object> map) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                if ("id".equals(key)) continue;
                ar.putValue(entry.getKey(), entry.getValue());
            }
            return ar;
        }

        public static <MODEL_TYPE extends AdaptiveRecord> MODEL_TYPE mergeValues(MODEL_TYPE ar, Map<String, Object> map) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                ar.mergeValue(entry.getKey(), entry.getValue());
            }
            return ar;
        }

        public static <MODEL_TYPE extends AdaptiveRecord, T> boolean containsKey(MODEL_TYPE ar, String key) {
            Map<String, Object> kv = ar.internalMap();
            return kv.containsKey(key) || ar.metaInfo().getterFieldSpecs.containsKey(key);
        }

        public static Map<String, Object> toMap(AdaptiveRecord ar) {
            Map<String, Object> kv = ar.internalMap();
            HashMap<String, Object> map = new HashMap<String, Object>(kv);
            for (Map.Entry<String, Lang.Function> entry : ar.metaInfo().fieldGetters.entrySet()) {
                map.put(entry.getKey(), entry.getValue().apply((Object)ar));
            }
            return map;
        }

        private static int fieldsSize(AdaptiveRecord ar) {
            return ar.metaInfo().getterFieldSpecs.size();
        }

        public static int size(AdaptiveRecord ar) {
            Map<String, Object> kv = ar.internalMap();
            return kv.size() + Util.fieldsSize(ar);
        }

        private static boolean hasFields(AdaptiveRecord ar) {
            return !ar.metaInfo().getterFieldSpecs.isEmpty();
        }

        public static Set<String> keySet(AdaptiveRecord ar) {
            Map<String, Object> kv = ar.internalMap();
            if (!Util.hasFields(ar)) {
                return kv.keySet();
            }
            HashSet<String> set = new HashSet<String>(ar.metaInfo().getterFieldSpecs.keySet());
            set.addAll(kv.keySet());
            return set;
        }

        public static Set<Map.Entry<String, Object>> entrySet(AdaptiveRecord ar, Lang.Function<BeanSpec, Boolean> function) {
            Map<String, Object> kv = ar.internalMap();
            if (!Util.hasFields(ar)) {
                return kv.entrySet();
            }
            HashSet<Map.Entry<String, Object>> set = new HashSet<Map.Entry<String, Object>>(kv.entrySet());
            MetaInfo metaInfo = ar.metaInfo();
            boolean filter = null != function;
            for (Map.Entry<String, Lang.Function> entry : metaInfo.fieldGetters.entrySet()) {
                BeanSpec field;
                String fieldName = entry.getKey();
                if ("kv".equals(fieldName) || filter && !((Boolean)function.apply((Object)(field = metaInfo.getterFieldSpecs.get(fieldName)))).booleanValue()) continue;
                Lang.Function getter = entry.getValue();
                set.add((Map.Entry<String, Object>)new C.Map.Entry((Object)fieldName, getter.apply((Object)ar)));
            }
            return set;
        }

        public static Map<String, Object> asMap(final AdaptiveRecord ar) {
            final Map<String, Object> kv = ar.internalMap();
            return new Map<String, Object>(){

                @Override
                public int size() {
                    return ar.size();
                }

                @Override
                public boolean isEmpty() {
                    return ar.size() == 0;
                }

                @Override
                public boolean containsKey(Object key) {
                    return kv.containsKey(key) || ar.metaInfo().getterFieldSpecs.containsKey(key);
                }

                @Override
                public boolean containsValue(Object value) {
                    return kv.containsValue(value);
                }

                @Override
                public Object get(Object key) {
                    Lang.Function getter = ar.metaInfo().fieldGetters.get(key);
                    return null != getter ? getter.apply((Object)ar) : kv.get((String)key);
                }

                @Override
                public Object put(String key, Object value) {
                    Lang.Func2 setter = ar.metaInfo().fieldSetters.get(key);
                    if (null != setter) {
                        Object o = this.get(key);
                        setter.apply((Object)ar, value);
                        return o;
                    }
                    return kv.put(key, value);
                }

                @Override
                public Object remove(Object key) {
                    Lang.Function getter = ar.metaInfo().fieldGetters.get(key);
                    if (null != getter) {
                        return null;
                    }
                    return kv.remove(key);
                }

                @Override
                public void putAll(Map<? extends String, ?> m) {
                    ar.putValues(m);
                }

                @Override
                public void clear() {
                    kv.clear();
                }

                @Override
                public Set<String> keySet() {
                    return ar.keySet();
                }

                @Override
                public Collection<Object> values() {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.addAll(kv.values());
                    for (Lang.Function getter : ar.metaInfo().fieldGetters.values()) {
                        list.add(getter.apply((Object)ar));
                    }
                    return list;
                }

                @Override
                public Set<Map.Entry<String, Object>> entrySet() {
                    return ar.entrySet();
                }
            };
        }

        public static MetaInfo generateMetaInfo(AdaptiveRecord ar) {
            MetaInfo.Repository r = Act.appServicePluginManager().get(MetaInfo.Repository.class);
            return r.get(ar.getClass(), (Lang.Function<Class<? extends AdaptiveRecord>, MetaInfo>)new Lang.Transformer<Class<? extends AdaptiveRecord>, MetaInfo>(){

                public MetaInfo transform(Class<? extends AdaptiveRecord> aClass) {
                    return new MetaInfo(aClass);
                }
            });
        }
    }
}

