/*
 * Decompiled with CFR 0.152.
 */
package act.db.meta;

import act.app.AppByteCodeScannerBase;
import act.asm.AnnotationVisitor;
import act.asm.ClassVisitor;
import act.asm.FieldVisitor;
import act.asm.Type;
import act.db.CreatedAt;
import act.db.LastModifiedAt;
import act.db.meta.EntityMetaInfoRepo;
import act.db.meta.MasterEntityMetaInfoRepo;
import act.util.ByteCodeVisitor;
import javax.persistence.Column;
import javax.persistence.Id;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.S;

public class EntityInfoByteCodeScanner
extends AppByteCodeScannerBase {
    private static final Logger LOGGER = LogManager.get(EntityMetaInfoRepo.class);
    private static final String DESC_CREATED_AT = Type.getDescriptor(CreatedAt.class);
    private static final String DESC_LAST_MODIFIED_AT = Type.getDescriptor(LastModifiedAt.class);
    private static final String DESC_ID = Type.getDescriptor(Id.class);
    private static final String DESC_COLUMN = Type.getDescriptor(Column.class);
    private EntityMetaInfoRepo repo;

    @Override
    protected void onAppSet() {
        this.repo = this.app().entityMetaInfoRepo();
    }

    @Override
    protected boolean shouldScan(String className) {
        return true;
    }

    @Override
    public ByteCodeVisitor byteCodeVisitor() {
        return new _ByteCodeVisitor();
    }

    @Override
    public void scanFinished(String className) {
    }

    private class _ByteCodeVisitor
    extends ByteCodeVisitor {
        boolean isMappedSuperClass;
        boolean isEntity;
        boolean isEntityListener;
        String className;
        boolean foundCreatedAt;
        boolean foundLastModifiedAt;
        boolean foundId;
        MasterEntityMetaInfoRepo metaInfoRepo;

        public _ByteCodeVisitor(ClassVisitor cv) {
            super(cv);
        }

        public _ByteCodeVisitor() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = Type.getObjectType((String)name).getClassName();
            this.metaInfoRepo = EntityInfoByteCodeScanner.this.app().entityMetaInfoRepo();
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor av = super.visitAnnotation(desc, visible);
            if (!this.isEntity && !this.isMappedSuperClass) {
                this.isEntity = this.metaInfoRepo.isEntity(desc);
                this.isMappedSuperClass = this.metaInfoRepo.isMappedSuperClass(desc);
                if (this.isEntity || this.isMappedSuperClass) {
                    EntityInfoByteCodeScanner.this.repo.registerEntityOrMappedSuperClass(this.className);
                    if (this.isEntity) {
                        return new AnnotationVisitor(327680, av){

                            public void visit(String name, Object value) {
                                if ("name".equals(name) || "value".equals(name)) {
                                    EntityInfoByteCodeScanner.this.repo.registerEntityName(_ByteCodeVisitor.this.className, (String)value);
                                }
                                super.visit(name, value);
                            }
                        };
                    }
                }
            } else if (!this.isEntityListener) {
                this.isEntityListener = this.metaInfoRepo.isEntityListener(desc);
                if (this.isEntityListener) {
                    EntityInfoByteCodeScanner.this.repo.markEntityListenersFound(this.className);
                }
            }
            return av;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            FieldVisitor fv = super.visitField(access, name, desc, signature, value);
            if (!this.isEntity && !this.isMappedSuperClass) {
                return fv;
            }
            final String fieldName = name;
            return new FieldVisitor(327680, fv){
                String columnName;

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    AnnotationVisitor av = super.visitAnnotation(desc, visible);
                    if (S.eq((String)DESC_CREATED_AT, (String)desc)) {
                        if (_ByteCodeVisitor.this.foundCreatedAt) {
                            LOGGER.warn("multiple @CreatedAt field found in class: " + _ByteCodeVisitor.this.className);
                        } else {
                            EntityInfoByteCodeScanner.this.repo.registerCreatedField(_ByteCodeVisitor.this.className, fieldName);
                        }
                        _ByteCodeVisitor.this.foundCreatedAt = true;
                    } else if (S.eq((String)DESC_LAST_MODIFIED_AT, (String)desc)) {
                        if (_ByteCodeVisitor.this.foundLastModifiedAt) {
                            LOGGER.warn("multiple @LastModifiedAt field found in class: " + _ByteCodeVisitor.this.className);
                        } else {
                            EntityInfoByteCodeScanner.this.repo.registerLastModifiedField(_ByteCodeVisitor.this.className, fieldName);
                        }
                        _ByteCodeVisitor.this.foundLastModifiedAt = true;
                    } else if (S.eq((String)DESC_ID, (String)desc)) {
                        if (_ByteCodeVisitor.this.foundId) {
                            LOGGER.warn("multiple @Id field found in class: " + _ByteCodeVisitor.this.className);
                        } else {
                            EntityInfoByteCodeScanner.this.repo.registerIdField(_ByteCodeVisitor.this.className, fieldName);
                        }
                        _ByteCodeVisitor.this.foundId = true;
                    } else if (null != this.columnName && S.eq((String)DESC_COLUMN, (String)desc)) {
                        return new AnnotationVisitor(327680, av){

                            public void visit(String name, Object value) {
                                if (null != columnName && "name".equals(name)) {
                                    columnName = (String)value;
                                }
                            }
                        };
                    }
                    return av;
                }

                public void visitEnd() {
                    if (null != this.columnName) {
                        EntityInfoByteCodeScanner.this.repo.registerColumnName(_ByteCodeVisitor.this.className, fieldName, this.columnName);
                    }
                    super.visitEnd();
                }
            };
        }
    }
}

