/*
 * Decompiled with CFR 0.152.
 */
package act.handler.builtin;

import act.ActResponse;
import act.app.ActionContext;
import act.app.App;
import act.handler.builtin.AlwaysForbidden;
import act.handler.builtin.AlwaysNotFound;
import act.handler.builtin.controller.FastRequestHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.osgl.$;
import org.osgl.http.H;
import org.osgl.util.FastStr;
import org.osgl.util.IO;
import org.osgl.util.S;

public class FileGetter
extends FastRequestHandler {
    private File base;
    private FastRequestHandler delegate;

    public FileGetter(String base, App app) {
        this(app.file(base));
    }

    public FileGetter(File base) {
        this.base = (File)$.requireNotNull((Object)base);
        this.delegate = this.verifyBase(base);
    }

    @Override
    public boolean express(ActionContext context) {
        return null != this.delegate;
    }

    @Override
    protected void releaseResources() {
        this.base = null;
    }

    @Override
    public void handle(ActionContext context) {
        if (null != this.delegate) {
            this.delegate.handle(context);
            return;
        }
        context.handler(this);
        File file = this.base;
        if (this.base.isDirectory()) {
            String path = context.paramVal("__path");
            if (S.blank((String)path)) {
                AlwaysForbidden.INSTANCE.handle(context);
                return;
            }
            file = new File(this.base, path);
            if (!file.exists()) {
                AlwaysNotFound.INSTANCE.handle(context);
                return;
            }
            if (file.isDirectory() || !file.canRead()) {
                AlwaysForbidden.INSTANCE.handle(context);
                return;
            }
        }
        ActResponse<?> resp = context.prepareRespForWrite();
        H.Format fmt = FileGetter.contentType(file.getPath());
        resp.contentType(fmt);
        context.applyCorsSpec().applyContentSecurityPolicy().applyContentType();
        BufferedInputStream is = new BufferedInputStream(IO.is((File)file));
        IO.copy((InputStream)is, (OutputStream)resp.outputStream());
    }

    public File base() {
        return this.base;
    }

    static H.Format contentType(String path) {
        H.Format retVal = null;
        if (path.contains(".")) {
            FastStr s = FastStr.unsafeOf((String)path).afterLast('.');
            retVal = H.Format.of((String)s.toString());
        }
        return null == retVal ? H.Format.BINARY : retVal;
    }

    @Override
    public boolean supportPartialPath() {
        return this.base.isDirectory();
    }

    @Override
    public String toString() {
        boolean dir = this.supportPartialPath();
        return "file: " + (dir ? this.base().getPath() + "/**" : this.base().getPath());
    }

    private FastRequestHandler verifyBase(File base) {
        if (!base.exists()) {
            this.logger.warn("file base not exists: " + base);
            return AlwaysNotFound.INSTANCE;
        }
        if (!base.canRead()) {
            this.logger.warn("cannot read file base: " + base);
            return AlwaysForbidden.INSTANCE;
        }
        if (base.isDirectory() & !base.canExecute()) {
            this.logger.warn("cannot access directory: " + base);
            return AlwaysForbidden.INSTANCE;
        }
        return null;
    }
}

