/*
 * Decompiled with CFR 0.152.
 */
package act.handler.builtin.controller.impl;

import act.Act;
import act.Trace;
import act.annotations.LargeResponse;
import act.annotations.SmallResponse;
import act.app.ActionContext;
import act.app.App;
import act.app.AppClassLoader;
import act.conf.AppConfig;
import act.controller.CacheSupportMetaInfo;
import act.controller.Controller;
import act.controller.annotation.HandleCsrfFailure;
import act.controller.annotation.HandleMissingAuthentication;
import act.controller.annotation.Throttled;
import act.controller.builtin.ThrottleFilter;
import act.controller.meta.ActionMethodMetaInfo;
import act.controller.meta.CatchMethodMetaInfo;
import act.controller.meta.ControllerClassMetaInfo;
import act.controller.meta.HandlerMethodMetaInfo;
import act.controller.meta.HandlerParamMetaInfo;
import act.controller.meta.InterceptorMethodMetaInfo;
import act.data.annotation.DateFormatPattern;
import act.data.annotation.Pattern;
import act.db.RequireDataBind;
import act.handler.NonBlock;
import act.handler.PreventDoubleSubmission;
import act.handler.builtin.controller.ActionHandlerInvoker;
import act.handler.builtin.controller.AfterInterceptor;
import act.handler.builtin.controller.AfterInterceptorInvoker;
import act.handler.builtin.controller.BeforeInterceptor;
import act.handler.builtin.controller.ControllerAction;
import act.handler.builtin.controller.ExceptionInterceptor;
import act.handler.builtin.controller.ExceptionInterceptorInvoker;
import act.handler.builtin.controller.FinallyInterceptor;
import act.handler.builtin.controller.Handler;
import act.handler.event.ReflectedHandlerInvokerInit;
import act.handler.event.ReflectedHandlerInvokerInvoke;
import act.inject.param.JsonDTO;
import act.inject.param.JsonDTOClassManager;
import act.inject.param.ParamValueLoaderManager;
import act.inject.param.ParamValueLoaderService;
import act.job.JobManager;
import act.job.TrackableWorker;
import act.plugin.ControllerPlugin;
import act.security.CORS;
import act.security.CSP;
import act.security.CSRF;
import act.sys.Env;
import act.util.ActContext;
import act.util.Async;
import act.util.CacheFor;
import act.util.CsvView;
import act.util.DestroyableBase;
import act.util.FastJsonFeature;
import act.util.FastJsonFilter;
import act.util.JsonView;
import act.util.MissingAuthenticationHandler;
import act.util.Output;
import act.util.OutputRequestParams;
import act.util.ProgressGauge;
import act.util.ReflectedInvokerHelper;
import act.util.SimpleProgressGauge;
import act.view.ActBadRequest;
import act.view.ActNotFound;
import act.view.NoImplicitTemplateVariable;
import act.view.RenderAny;
import act.view.RenderTemplate;
import act.view.Template;
import act.view.TemplatePathResolver;
import act.ws.WebSocketConnectionManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.http.H;
import org.osgl.inject.BeanSpec;
import org.osgl.mvc.annotation.ResponseContentType;
import org.osgl.mvc.annotation.ResponseStatus;
import org.osgl.mvc.annotation.SessionFree;
import org.osgl.mvc.result.BadRequest;
import org.osgl.mvc.result.Conflict;
import org.osgl.mvc.result.RenderJSON;
import org.osgl.mvc.result.Result;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

@ApplicationScoped
public class ReflectedHandlerInvoker<M extends HandlerMethodMetaInfo>
extends DestroyableBase
implements ActionHandlerInvoker,
AfterInterceptorInvoker,
ExceptionInterceptorInvoker {
    private static final Object[] DUMP_PARAMS = new Object[0];
    private App app;
    private ClassLoader cl;
    private ControllerClassMetaInfo controller;
    private Class<?> controllerClass;
    private MethodAccess methodAccess;
    private M handler;
    private int handlerIndex;
    private ConcurrentMap<H.Format, Boolean> templateAvailabilityCache = new ConcurrentHashMap<H.Format, Boolean>();
    private Lang.Visitor<H.Format> templateChangeListener = new Lang.Visitor<H.Format>(){

        public void visit(H.Format format) throws Lang.Break {
            ReflectedHandlerInvoker.this.templateAvailabilityCache.remove(format);
        }
    };
    protected Method method;
    private ParamValueLoaderService paramLoaderService;
    private JsonDTOClassManager jsonDTOClassManager;
    private int paramCount;
    private int fieldsAndParamsCount;
    private String singleJsonFieldName;
    private boolean sessionFree;
    private boolean express;
    private List<BeanSpec> paramSpecs;
    private CORS.Spec corsSpec;
    private CSRF.Spec csrfSpec;
    private String csp;
    private boolean disableCsp;
    private boolean isStatic;
    private Object singleton;
    private H.Format forceResponseContentType;
    private H.Status forceResponseStatus;
    private boolean disabled;
    private String dspToken;
    private CacheSupportMetaInfo cacheSupport;
    private Map<Field, String> outputFields;
    private Map<Integer, String> outputParams;
    private boolean hasOutputVar;
    private String dateFormatPattern;
    private boolean noTemplateCache;
    private MissingAuthenticationHandler missingAuthenticationHandler;
    private MissingAuthenticationHandler csrfFailureHandler;
    private ThrottleFilter throttleFilter;
    private boolean async;
    private boolean byPassImplicityTemplateVariable;
    private boolean forceDataBinding;
    private boolean traceHandler;
    private boolean isLargeResponse;
    private boolean forceSmallResponse;
    private Class<? extends SerializeFilter>[] filters;
    private SerializerFeature[] features;
    private Lang.Function<ActionContext, Result> pluginBeforeHandler;
    private Lang.Func2<Result, ActionContext, Result> pluginAfterHandler;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    private ReflectedHandlerInvoker(M handlerMetaInfo, App app) {
        PreventDoubleSubmission dsp;
        ResponseStatus status;
        ResponseContentType contentType;
        CSP cspAnno;
        CSRF.Spec csrfSpec;
        CORS.Spec corsSpec;
        DateFormatPattern dfp;
        FastJsonFeature featureAnno;
        FastJsonFilter filterAnno;
        this.app = app;
        this.cl = app.classLoader();
        this.handler = handlerMetaInfo;
        this.controller = ((HandlerMethodMetaInfo)handlerMetaInfo).classInfo();
        this.controllerClass = $.classForName((String)this.controller.className(), (ClassLoader)this.cl);
        this.disabled = !Env.matches(this.controllerClass);
        this.traceHandler = app.config().traceHandler();
        this.paramLoaderService = app.service(ParamValueLoaderManager.class).get(ActionContext.class);
        this.jsonDTOClassManager = app.service(JsonDTOClassManager.class);
        Class[] paramTypes = this.paramTypes(this.cl);
        try {
            this.method = this.controllerClass.getMethod(((HandlerMethodMetaInfo)handlerMetaInfo).name(), paramTypes);
        }
        catch (NoSuchMethodException e) {
            throw E.unexpected((Throwable)e);
        }
        this.pluginBeforeHandler = ControllerPlugin.Manager.INST.beforeHandler(this.controllerClass, this.method);
        this.pluginAfterHandler = ControllerPlugin.Manager.INST.afterHandler(this.controllerClass, this.method);
        this.disabled = this.disabled || !Env.matches(this.method);
        this.forceDataBinding = this.method.isAnnotationPresent(RequireDataBind.class);
        boolean bl = this.async = null != this.method.getAnnotation(Async.class);
        if (this.async && ((HandlerMethodMetaInfo)handlerMetaInfo).hasReturnOrThrowResult()) {
            this.logger.warn("handler return result will be ignored for async method: " + this.method);
        }
        this.isStatic = ((HandlerMethodMetaInfo)handlerMetaInfo).isStatic();
        if (!this.isStatic) {
            this.methodAccess = MethodAccess.get(this.controllerClass);
            this.handlerIndex = this.methodAccess.getIndex(((HandlerMethodMetaInfo)handlerMetaInfo).name(), paramTypes);
        } else {
            this.method.setAccessible(true);
        }
        Throttled throttleControl = this.method.getAnnotation(Throttled.class);
        if (null != throttleControl) {
            int throttle = throttleControl.value();
            if (throttle < 1) {
                throttle = app.config().requestThrottle();
            }
            Throttled.ExpireScale expireScale = throttleControl.expireScale();
            this.throttleFilter = new ThrottleFilter(throttle, expireScale.enabled());
        }
        this.isLargeResponse = this.method.getAnnotation(LargeResponse.class) != null;
        boolean bl2 = this.forceSmallResponse = this.method.getAnnotation(SmallResponse.class) != null;
        if (this.isLargeResponse && this.forceSmallResponse) {
            this.warn("found both @LargeResponse and @SmallResponse, will ignore @SmallResponse", new Object[0]);
            this.forceSmallResponse = false;
        }
        if (null != (filterAnno = this.method.getAnnotation(FastJsonFilter.class))) {
            this.filters = filterAnno.value();
        }
        if (null != (featureAnno = this.method.getAnnotation(FastJsonFeature.class))) {
            this.features = featureAnno.value();
        }
        if (null != (dfp = this.method.getAnnotation(DateFormatPattern.class))) {
            this.dateFormatPattern = dfp.value();
        } else {
            Pattern pattern = this.method.getAnnotation(Pattern.class);
            if (null != pattern) {
                this.dateFormatPattern = pattern.value();
            }
        }
        if (null != this.dateFormatPattern) {
            ((HandlerMethodMetaInfo)handlerMetaInfo).dateFormatPattern(this.dateFormatPattern);
        }
        this.sessionFree = this.method.isAnnotationPresent(SessionFree.class);
        this.express = this.method.isAnnotationPresent(NonBlock.class);
        this.noTemplateCache = this.method.isAnnotationPresent(Template.NoCache.class);
        this.paramCount = ((HandlerMethodMetaInfo)this.handler).paramCount();
        this.paramSpecs = this.jsonDTOClassManager.beanSpecs(this.controllerClass, this.method);
        this.fieldsAndParamsCount = this.paramSpecs.size();
        if (this.fieldsAndParamsCount == 1) {
            this.singleJsonFieldName = this.paramSpecs.get(0).name();
        }
        this.corsSpec = corsSpec = CORS.spec(this.method).chain(CORS.spec(this.controllerClass));
        this.csrfSpec = csrfSpec = CSRF.spec(this.method).chain(CSRF.spec(this.controllerClass));
        CSP.Disable cspDisableAnno = this.getAnnotation(CSP.Disable.class);
        if (null != cspDisableAnno) {
            this.disableCsp = true;
        }
        if (!this.disableCsp && null != (cspAnno = this.getAnnotation(CSP.class))) {
            this.csp = cspAnno.value();
        }
        if (!this.isStatic) {
            this.singleton = ReflectedInvokerHelper.tryGetSingleton(this.controllerClass, app);
        }
        if (null != this.controllerClass.getAnnotation(JsonView.class)) {
            this.forceResponseContentType = H.MediaType.JSON.format();
        }
        if (null != this.controllerClass.getAnnotation(CsvView.class)) {
            this.forceResponseContentType = H.MediaType.CSV.format();
        }
        if (null != (contentType = this.controllerClass.getAnnotation(ResponseContentType.class))) {
            this.forceResponseContentType = contentType.value().format();
        }
        if (null != this.method.getAnnotation(JsonView.class)) {
            this.forceResponseContentType = H.MediaType.JSON.format();
        }
        if (null != this.method.getAnnotation(CsvView.class)) {
            this.forceResponseContentType = H.MediaType.CSV.format();
        }
        if (null != (contentType = this.method.getAnnotation(ResponseContentType.class))) {
            this.forceResponseContentType = contentType.value().format();
        }
        if (null != (status = this.method.getAnnotation(ResponseStatus.class))) {
            this.forceResponseStatus = H.Status.of((int)status.value());
        }
        if (null != (dsp = this.method.getAnnotation(PreventDoubleSubmission.class))) {
            this.dspToken = dsp.value();
            if ("--configured--".equals(this.dspToken)) {
                this.dspToken = app.config().dspToken();
            }
        }
        this.byPassImplicityTemplateVariable = this.controllerClass.isAnnotationPresent(NoImplicitTemplateVariable.class) || this.method.isAnnotationPresent(NoImplicitTemplateVariable.class);
        this.initOutputVariables();
        this.initCacheParams(app.config());
        this.initMissingAuthenticationAndCsrfCheckHandler();
        app.eventBus().emit(new ReflectedHandlerInvokerInit(this), new Object[0]);
    }

    @Override
    protected void releaseResources() {
        this.app = null;
        this.cl = null;
        this.controller = null;
        this.controllerClass = null;
        this.method = null;
        this.methodAccess = null;
        ((DestroyableBase)this.handler).destroy();
        this.handler = null;
        this.cacheSupport = null;
        super.releaseResources();
    }

    @Override
    public int priority() {
        return ((HandlerMethodMetaInfo)this.handler).priority();
    }

    @Override
    public Method invokeMethod() {
        return this.method;
    }

    public ReflectedHandlerInvoker attribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public <T> T attribute(String key) {
        return (T)$.cast((Object)this.attributes.get(key));
    }

    @Override
    public void accept(ActionHandlerInvoker.Visitor visitor) {
        ReflectedHandlerInvokerVisitor rv = (ReflectedHandlerInvokerVisitor)visitor;
        rv.apply(this.controllerClass, this.method);
    }

    public Class<?> controllerClass() {
        return this.controllerClass;
    }

    public Method method() {
        return this.method;
    }

    @Override
    public CacheSupportMetaInfo cacheSupport() {
        return this.cacheSupport;
    }

    @Override
    public MissingAuthenticationHandler missingAuthenticationHandler() {
        return this.missingAuthenticationHandler;
    }

    @Override
    public MissingAuthenticationHandler csrfFailureHandler() {
        return this.csrfFailureHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result handle(final ActionContext context) {
        String templateContext;
        Result throttleResult;
        if (this.disabled) {
            return ActNotFound.get();
        }
        if (null != this.throttleFilter && null != (throttleResult = this.throttleFilter.handle(context))) {
            return throttleResult;
        }
        Result result = (Result)((Object)this.pluginBeforeHandler.apply((Object)context));
        if (null != result) {
            return result;
        }
        context.setReflectedHandlerInvoker(this);
        this.app.eventBus().emit(new ReflectedHandlerInvokerInvoke(this, context), new Object[0]);
        if (this.fieldsAndParamsCount == 1) {
            context.allowIgnoreParamNamespace();
        } else {
            context.disallowIgnoreParamNamespace();
        }
        if (this.isLargeResponse) {
            context.setLargeResponse();
        }
        if (null != this.filters) {
            context.fastjsonFilters((Class[])this.filters);
        }
        if (null != this.features) {
            context.fastjsonFeatures(this.features);
        }
        if (null != this.dateFormatPattern) {
            context.dateFormatPattern(this.dateFormatPattern);
        }
        if (this.byPassImplicityTemplateVariable && context.state().isHandling()) {
            context.byPassImplicitVariable();
        }
        context.templateChangeListener(this.templateChangeListener);
        if (this.noTemplateCache) {
            context.disableTemplateCaching();
        }
        context.currentMethod(this.method);
        String urlContext = this.controller.urlContext();
        if (S.notBlank((String)urlContext)) {
            context.urlContext(urlContext);
        }
        if (null != (templateContext = this.controller.templateContext())) {
            context.templateContext(templateContext);
        }
        this.preventDoubleSubmission(context);
        this.processForceResponse(context);
        if (this.forceDataBinding || context.state().isHandling()) {
            this.ensureJsonDTOGenerated(context);
        }
        final Object controller = this.controllerInstance(context);
        boolean failOnViolation = context.isAjax() || context.accept() != H.Format.HTML;
        final Object[] params = this.params(controller, context);
        if (failOnViolation && context.hasViolation()) {
            String msg = context.violationMessage(";");
            return ActBadRequest.create(msg, new Object[0]);
        }
        if (this.async) {
            JobManager jobManager = context.app().jobManager();
            String jobId = jobManager.prepare((Lang.Function<ProgressGauge, ?>)new TrackableWorker(){

                @Override
                protected void run(ProgressGauge progressGauge) {
                    try {
                        ReflectedHandlerInvoker.this.invoke(ReflectedHandlerInvoker.this.handler, context, controller, params);
                    }
                    catch (Exception e) {
                        ReflectedHandlerInvoker.this.logger.warn((Throwable)e, "Error executing async handler: " + ReflectedHandlerInvoker.this.handler);
                    }
                }
            });
            context.setJobId(jobId);
            WebSocketConnectionManager wscm = this.app.getInstance(WebSocketConnectionManager.class);
            wscm.subscribe(context.session(), SimpleProgressGauge.wsJobProgressTag(jobId));
            jobManager.now(jobId);
            return new RenderJSON((Object)C.Map((Object[])new Object[]{"jobId", jobId}));
        }
        try {
            Result result2 = (Result)((Object)this.pluginAfterHandler.apply((Object)this.invoke(this.handler, context, controller, params), (Object)context));
            return result2;
        }
        finally {
            if (this.hasOutputVar) {
                this.fillOutputVariables(controller, params, context);
            }
        }
    }

    @Override
    public Result handle(Result result, ActionContext actionContext) throws Exception {
        actionContext.setResult(result);
        return this.handle(actionContext);
    }

    @Override
    public Result handle(Exception e, ActionContext actionContext) throws Exception {
        actionContext.attribute("__exception__", e);
        return this.handle(actionContext);
    }

    @Override
    public boolean sessionFree() {
        return this.sessionFree;
    }

    @Override
    public boolean express() {
        return this.express;
    }

    @Override
    public CORS.Spec corsSpec() {
        return this.corsSpec;
    }

    @Override
    public CSRF.Spec csrfSpec() {
        return this.csrfSpec;
    }

    @Override
    public String contentSecurityPolicy() {
        return this.disableCsp ? null : this.csp;
    }

    @Override
    public boolean disableContentSecurityPolicy() {
        return this.disableCsp;
    }

    public void setLargeResponseHint() {
        if (!this.forceSmallResponse) {
            this.isLargeResponse = true;
        }
    }

    private void cacheJsonDTO(ActContext<?> context, JsonDTO dto) {
        context.attribute("__json_dto__", dto);
    }

    private void ensureJsonDTOGenerated(ActionContext context) {
        if (0 == this.fieldsAndParamsCount || !context.jsonEncoded()) {
            return;
        }
        Class<? extends JsonDTO> dtoClass = this.jsonDTOClassManager.get(this.controllerClass, this.method);
        if (null == dtoClass) {
            return;
        }
        try {
            JsonDTO dto = (JsonDTO)JSON.parseObject((String)this.patchedJsonBody(context), dtoClass);
            this.cacheJsonDTO(context, dto);
        }
        catch (JSONException e) {
            if (e.getCause() != null) {
                this.warn(e.getCause(), "error parsing JSON data", new Object[0]);
            } else {
                this.warn(e, "error parsing JSON data", new Object[0]);
            }
            throw new BadRequest(e.getCause());
        }
    }

    private int fieldsAndParamsCount(ActionContext context) {
        if (this.fieldsAndParamsCount < 2) {
            return this.fieldsAndParamsCount;
        }
        return this.fieldsAndParamsCount - context.pathVarCount();
    }

    private String singleJsonFieldName(ActionContext context) {
        if (null != this.singleJsonFieldName) {
            return this.singleJsonFieldName;
        }
        for (BeanSpec spec : this.paramSpecs) {
            String name = spec.name();
            if (context.isPathVar(name)) continue;
            return name;
        }
        return null;
    }

    private String patchedJsonBody(ActionContext context) {
        boolean needPatch;
        String body = context.body();
        if (S.blank((String)body) || 1 < this.fieldsAndParamsCount(context)) {
            return body;
        }
        String theName = this.singleJsonFieldName(context);
        int theNameLen = theName.length();
        if (null == theName) {
            return body;
        }
        boolean bl = needPatch = (body = body.trim()).charAt(0) == '[';
        if (!needPatch) {
            if (body.charAt(0) != '{') {
                throw new IllegalArgumentException("Cannot parse JSON string: " + body);
            }
            boolean startCheckName = false;
            int nameStart = -1;
            for (int i = 1; i < body.length(); ++i) {
                char c = body.charAt(i);
                if (c == ' ') continue;
                if (startCheckName) {
                    if (c == '\"') break;
                    int id = i - nameStart - 1;
                    if (id < theNameLen && theName.charAt(i - nameStart - 1) == c) continue;
                    needPatch = true;
                    break;
                }
                if (c != '\"') continue;
                startCheckName = true;
                nameStart = i;
            }
        }
        return needPatch ? S.fmt((String)"{\"%s\": %s}", (Object[])new Object[]{theName, body}) : body;
    }

    private Class[] paramTypes(ClassLoader cl) {
        int sz = ((HandlerMethodMetaInfo)this.handler).paramCount();
        Class[] ca = new Class[sz];
        for (int i = 0; i < sz; ++i) {
            HandlerParamMetaInfo param = ((HandlerMethodMetaInfo)this.handler).param(i);
            ca[i] = $.classForName((String)param.type().getClassName(), (ClassLoader)cl);
        }
        return ca;
    }

    private void processForceResponse(ActionContext actionContext) {
        if (null != this.forceResponseContentType) {
            actionContext.accept(this.forceResponseContentType);
        }
        if (null != this.forceResponseStatus) {
            actionContext.forceResponseStatus(this.forceResponseStatus);
        }
    }

    private void preventDoubleSubmission(ActionContext context) {
        String cacheKey;
        if (null == this.dspToken) {
            return;
        }
        H.Request req = context.req();
        if (req.method().safe()) {
            return;
        }
        String tokenValue = context.paramVal(this.dspToken);
        if (S.blank((String)tokenValue)) {
            return;
        }
        H.Session session = context.session();
        String cached = (String)session.cached(cacheKey = S.concat((String)"DSP-", (String)this.dspToken));
        if (S.eq((String)tokenValue, (String)cached)) {
            throw Conflict.get();
        }
        session.cacheFor1Min(cacheKey, (Object)tokenValue);
    }

    private Object controllerInstance(ActionContext context) {
        if (this.isStatic) {
            return null;
        }
        if (null != this.singleton) {
            return this.singleton;
        }
        String controllerName = this.controllerClass.getName();
        Object inst = context.__controllerInstance(controllerName);
        if (null == inst) {
            inst = this.paramLoaderService.loadHostBean(this.controllerClass, context);
            context.__controllerInstance(controllerName, inst);
        }
        return inst;
    }

    private void initCacheParams(AppConfig config) {
        if (Act.isDev() && !config.cacheForOnDevMode()) {
            this.cacheSupport = CacheSupportMetaInfo.disabled();
            return;
        }
        CacheFor cacheFor = this.method.getAnnotation(CacheFor.class);
        this.cacheSupport = null == cacheFor ? CacheSupportMetaInfo.disabled() : CacheSupportMetaInfo.enabled((Lang.Function<ActionContext, String>)new CacheKeyBuilder(cacheFor, S.concat((String)this.controllerClass.getName(), (String)".", (String)this.method.getName())), cacheFor.value(), cacheFor.supportPost());
    }

    private void fillOutputVariables(Object controller, Object[] params, ActionContext context) {
        String outputName;
        if (!this.isStatic) {
            for (Map.Entry<Field, String> entry : this.outputFields.entrySet()) {
                Field field = entry.getKey();
                outputName = entry.getValue();
                try {
                    Object val = field.get(controller);
                    context.renderArg(outputName, val);
                }
                catch (IllegalAccessException e) {
                    throw E.unexpected((Throwable)e);
                }
            }
            context.fieldOutputVarCount(this.outputFields.size());
        }
        if (0 == params.length) {
            return;
        }
        for (Map.Entry<Object, String> entry : this.outputParams.entrySet()) {
            int i = (Integer)entry.getKey();
            outputName = entry.getValue();
            context.renderArg(outputName, params[i]);
        }
    }

    private void initMissingAuthenticationAndCsrfCheckHandler() {
        HandleCsrfFailure hcf;
        HandleMissingAuthentication hma = this.getAnnotation(HandleMissingAuthentication.class);
        if (null != hma) {
            this.missingAuthenticationHandler = hma.value().handler(hma.custom());
        }
        if (null != (hcf = this.getAnnotation(HandleCsrfFailure.class))) {
            this.csrfFailureHandler = hcf.value().handler(hcf.custom());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOutputVariables() {
        int len;
        Class<?>[] paramTypes;
        String outputName;
        HashSet<String> outputNames;
        block12: {
            outputNames = new HashSet<String>();
            this.outputFields = new HashMap<Field, String>();
            if (!this.isStatic) {
                List fields = $.fieldsOf(this.controllerClass);
                for (Field field : fields) {
                    Output output = field.getAnnotation(Output.class);
                    if (null == output) continue;
                    String fieldName = field.getName();
                    outputName = output.value();
                    if (S.blank((String)outputName)) {
                        outputName = fieldName;
                    }
                    E.unexpectedIf((boolean)outputNames.contains(outputName), (String)"output name already used: %s", (Object[])new Object[]{outputName});
                    field.setAccessible(true);
                    this.outputFields.put(field, outputName);
                    outputNames.add(outputName);
                }
            }
            this.outputParams = new HashMap<Integer, String>();
            paramTypes = this.method.getParameterTypes();
            len = paramTypes.length;
            if (0 != len) break block12;
            this.hasOutputVar = !outputNames.isEmpty();
            return;
        }
        try {
            OutputRequestParams outputRequestParams = this.method.getAnnotation(OutputRequestParams.class);
            if (null != outputRequestParams) {
                Object injector = this.app.injector();
                for (int i = 0; i < len; ++i) {
                    if (injector.isProvided(paramTypes[i])) continue;
                    outputName = ((HandlerMethodMetaInfo)this.handler).param(i).name();
                    this.outputParams.put(i, outputName);
                    outputNames.add(outputName);
                }
            } else {
                Annotation[][] aaa = this.method.getParameterAnnotations();
                for (int i = 0; i < len; ++i) {
                    Annotation[] aa = aaa[i];
                    if (null == aa) continue;
                    Output output = null;
                    for (int j = aa.length - 1; j >= 0; --j) {
                        Annotation a = aa[j];
                        if (a.annotationType() != Output.class) continue;
                        output = (Output)$.cast((Object)a);
                        break;
                    }
                    if (null == output) continue;
                    String outputName2 = output.value();
                    if (S.blank((String)outputName2)) {
                        HandlerParamMetaInfo paramMetaInfo = ((HandlerMethodMetaInfo)this.handler).param(i);
                        outputName2 = paramMetaInfo.name();
                    }
                    E.unexpectedIf((boolean)outputNames.contains(outputName2), (String)"output name already used: %s", (Object[])new Object[]{outputName2});
                    this.outputParams.put(i, outputName2);
                    outputNames.add(outputName2);
                }
            }
            this.hasOutputVar = !outputNames.isEmpty();
        }
        catch (Throwable throwable) {
            this.hasOutputVar = !outputNames.isEmpty();
            throw throwable;
        }
    }

    private Result invoke(M handlerMetaInfo, ActionContext context, Object controller, Object[] params) {
        Object result;
        String invocationInfo = null;
        try {
            if (this.traceHandler) {
                invocationInfo = S.fmt((String)"%s(%s)", (Object[])new Object[]{((HandlerMethodMetaInfo)handlerMetaInfo).fullName(), $.toString2((Object)params)});
                Trace.LOGGER_HANDLER.trace(invocationInfo);
            }
            result = null == this.methodAccess ? $.invokeStatic((Method)this.method, (Object[])params) : this.methodAccess.invoke(controller, this.handlerIndex, params);
        }
        catch (Result r) {
            result = r;
        }
        catch (Exception e) {
            if (this.traceHandler) {
                Trace.LOGGER_HANDLER.trace((Throwable)e, "error invoking %s", new Object[]{invocationInfo});
            }
            throw e;
        }
        if (context.resp().isClosed()) {
            return null;
        }
        if (null == result && ((HandlerMethodMetaInfo)this.handler).hasReturn() && !((HandlerMethodMetaInfo)this.handler).returnTypeInfo().isResult()) {
            return ActNotFound.create();
        }
        boolean hasTemplate = this.checkTemplate(context);
        if (hasTemplate && result instanceof RenderAny) {
            result = RenderTemplate.INSTANCE;
        }
        return Controller.Util.inferResult(handlerMetaInfo, result, context, hasTemplate);
    }

    public boolean checkTemplate(ActionContext context) {
        if (!context.state().isHandling()) {
            return false;
        }
        H.Format fmt = context.accept();
        if (this.noTemplateCache || Act.isDev()) {
            return this.probeTemplate(fmt, context);
        }
        Boolean hasTemplate = context.hasTemplate();
        if (null != hasTemplate) {
            return hasTemplate;
        }
        hasTemplate = (Boolean)this.templateAvailabilityCache.get(fmt);
        if (null == hasTemplate) {
            hasTemplate = this.probeTemplate(fmt, context);
            this.templateAvailabilityCache.putIfAbsent(fmt, hasTemplate);
        }
        context.setHasTemplate(hasTemplate);
        return hasTemplate;
    }

    private boolean probeTemplate(H.Format fmt, ActionContext context) {
        if (!TemplatePathResolver.isAcceptFormatSupported(fmt)) {
            return false;
        }
        Template t = Act.viewManager().load(context);
        return t != null;
    }

    private Object[] params(Object controller, ActionContext context) {
        if (0 == this.paramCount) {
            return DUMP_PARAMS;
        }
        return this.paramLoaderService.loadMethodParams(controller, this.method, context);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annoType) {
        T anno = this.method.getAnnotation(annoType);
        if (null == anno) {
            anno = this.controllerClass.getAnnotation(annoType);
        }
        return anno;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annoType) {
        return null != this.method.getAnnotation(annoType) || null != this.controllerClass.getAnnotation(annoType);
    }

    public static ControllerAction createControllerAction(ActionMethodMetaInfo meta, App app) {
        return new ControllerAction(new ReflectedHandlerInvoker<ActionMethodMetaInfo>(meta, app));
    }

    public static BeforeInterceptor createBeforeInterceptor(InterceptorMethodMetaInfo meta, App app) {
        return new _Before(new ReflectedHandlerInvoker<InterceptorMethodMetaInfo>(meta, app));
    }

    public static AfterInterceptor createAfterInterceptor(InterceptorMethodMetaInfo meta, App app) {
        return new _After(new ReflectedHandlerInvoker<InterceptorMethodMetaInfo>(meta, app));
    }

    public static ExceptionInterceptor createExceptionInterceptor(CatchMethodMetaInfo meta, App app) {
        return new _Exception(new ReflectedHandlerInvoker<CatchMethodMetaInfo>(meta, app), meta);
    }

    public static FinallyInterceptor createFinannyInterceptor(InterceptorMethodMetaInfo meta, App app) {
        return new _Finally(new ReflectedHandlerInvoker<InterceptorMethodMetaInfo>(meta, app));
    }

    private static class CacheKeyBuilder
    extends Lang.F1<ActionContext, String> {
        private String[] keys;
        private final String base;

        CacheKeyBuilder(CacheFor cacheFor, String actionPath) {
            this.base = this.base(actionPath);
            this.keys = cacheFor.keys();
        }

        private String base(String actionPath) {
            String[] sa;
            S.Buffer buffer = S.newBuffer();
            for (String s : sa = actionPath.split("\\.")) {
                buffer.append(s.charAt(0));
            }
            buffer.append(actionPath.hashCode());
            return buffer.toString();
        }

        public String apply(ActionContext context) throws NotAppliedException, Lang.Break {
            TreeMap<String, String> keyValues = this.keyValues(context);
            S.Buffer buffer = S.newBuffer((String)this.base);
            for (Map.Entry<String, String> entry : keyValues.entrySet()) {
                buffer.append("-").append(entry.getKey()).append(":").append(entry.getValue());
            }
            buffer.append(context.userAgent().isMobile() ? "M" : "B");
            return buffer.toString();
        }

        private TreeMap<String, String> keyValues(ActionContext context) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            if (this.keys.length > 0) {
                for (String key : this.keys) {
                    map.put(key, this.paramVal(key, context));
                }
            } else {
                for (String key : context.paramKeys()) {
                    map.put(key, this.paramVal(key, context));
                }
            }
            return map;
        }

        private String paramVal(String key, ActionContext context) {
            String[] allValues = context.paramVals(key);
            if (0 == allValues.length) {
                return "";
            }
            if (1 == allValues.length) {
                return allValues[0];
            }
            return $.toString2((Object)allValues);
        }
    }

    private static class _Finally
    extends FinallyInterceptor {
        private ActionHandlerInvoker invoker;

        _Finally(ActionHandlerInvoker invoker) {
            super(invoker.priority());
            this.invoker = invoker;
        }

        @Override
        public void handle(ActionContext actionContext) throws Exception {
            this.invoker.handle(actionContext);
        }

        @Override
        public CORS.Spec corsSpec() {
            return this.invoker.corsSpec();
        }

        @Override
        public boolean sessionFree() {
            return this.invoker.sessionFree();
        }

        @Override
        public boolean express() {
            return this.invoker.express();
        }

        @Override
        public void accept(Handler.Visitor visitor) {
            this.invoker.accept(visitor.invokerVisitor());
        }

        @Override
        protected void releaseResources() {
            this.invoker.destroy();
            this.invoker = null;
        }
    }

    private static class _Exception
    extends ExceptionInterceptor {
        private ExceptionInterceptorInvoker invoker;

        _Exception(ExceptionInterceptorInvoker invoker, CatchMethodMetaInfo metaInfo) {
            super(invoker.priority(), _Exception.exceptionClassesOf(metaInfo));
            this.invoker = invoker;
        }

        private static List<Class<? extends Exception>> exceptionClassesOf(CatchMethodMetaInfo metaInfo) {
            List<String> classNames = metaInfo.exceptionClasses();
            C.List clsList = C.newSizedList((int)classNames.size());
            AppClassLoader cl = App.instance().classLoader();
            for (String cn : classNames) {
                clsList.add($.classForName((String)cn, (ClassLoader)cl));
            }
            return clsList;
        }

        @Override
        protected Result internalHandle(Exception e, ActionContext actionContext) throws Exception {
            return this.invoker.handle(e, actionContext);
        }

        @Override
        public boolean sessionFree() {
            return this.invoker.sessionFree();
        }

        @Override
        public boolean express() {
            return this.invoker.express();
        }

        @Override
        public void accept(ActionHandlerInvoker.Visitor visitor) {
            this.invoker.accept(visitor);
        }

        @Override
        public void accept(Handler.Visitor visitor) {
            this.invoker.accept(visitor.invokerVisitor());
        }

        @Override
        public CORS.Spec corsSpec() {
            return this.invoker.corsSpec();
        }

        @Override
        protected void releaseResources() {
            this.invoker.destroy();
            this.invoker = null;
        }
    }

    private static class _After
    extends AfterInterceptor {
        private AfterInterceptorInvoker invoker;

        _After(AfterInterceptorInvoker invoker) {
            super(invoker.priority());
            this.invoker = invoker;
        }

        @Override
        public Result handle(Result result, ActionContext actionContext) throws Exception {
            return this.invoker.handle(result, actionContext);
        }

        @Override
        public CORS.Spec corsSpec() {
            return this.invoker.corsSpec();
        }

        @Override
        public boolean sessionFree() {
            return this.invoker.sessionFree();
        }

        @Override
        public boolean express() {
            return this.invoker.express();
        }

        @Override
        public void accept(Handler.Visitor visitor) {
            this.invoker.accept(visitor.invokerVisitor());
        }

        @Override
        public void accept(ActionHandlerInvoker.Visitor visitor) {
            this.invoker.accept(visitor);
        }

        @Override
        protected void releaseResources() {
            this.invoker.destroy();
            this.invoker = null;
        }
    }

    private static class _Before
    extends BeforeInterceptor {
        private ActionHandlerInvoker invoker;

        _Before(ActionHandlerInvoker invoker) {
            super(invoker.priority());
            this.invoker = invoker;
        }

        @Override
        public Result handle(ActionContext actionContext) throws Exception {
            return this.invoker.handle(actionContext);
        }

        @Override
        public boolean sessionFree() {
            return this.invoker.sessionFree();
        }

        @Override
        public boolean express() {
            return this.invoker.express();
        }

        @Override
        public void accept(Handler.Visitor visitor) {
            this.invoker.accept(visitor.invokerVisitor());
        }

        @Override
        public CORS.Spec corsSpec() {
            return this.invoker.corsSpec();
        }

        @Override
        protected void releaseResources() {
            this.invoker.destroy();
            this.invoker = null;
        }
    }

    public static interface ReflectedHandlerInvokerVisitor
    extends ActionHandlerInvoker.Visitor,
    Lang.Func2<Class<?>, Method, Void> {
    }
}

