/*
 * Decompiled with CFR 0.152.
 */
package act.handler.event;

import act.app.ActionContext;
import act.event.ActEvent;
import act.event.SystemEvent;
import act.handler.event.AfterResultCommit;
import act.handler.event.BeforeResultCommit;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.http.H;
import org.osgl.mvc.result.Result;

public abstract class ResultEvent
extends ActEvent<Result>
implements SystemEvent {
    private final H.Request req;
    private final H.Response resp;
    public static final Lang.Func3<Result, H.Request<?>, H.Response<?>, Void> BEFORE_COMMIT_HANDLER = new Lang.F3<Result, H.Request<?>, H.Response<?>, Void>(){

        public Void apply(Result result, H.Request<?> request, H.Response<?> response) throws NotAppliedException, Lang.Break {
            ActionContext context = (ActionContext)request.context();
            context.applyCorsSpec().applyContentSecurityPolicy().applyContentType(result);
            context.app().eventBus().emit(new BeforeResultCommit(result, request, response), new Object[0]);
            return null;
        }
    };
    public static final Lang.Func3<Result, H.Request<?>, H.Response<?>, Void> AFTER_COMMIT_HANDLER = new Lang.F3<Result, H.Request<?>, H.Response<?>, Void>(){

        public Void apply(Result result, H.Request<?> request, H.Response<?> response) throws NotAppliedException, Lang.Break {
            ActionContext context = (ActionContext)request.context();
            context.logAccess(response);
            context.app().eventBus().emit(new AfterResultCommit(result, request, response), new Object[0]);
            return null;
        }
    };

    public ResultEvent(Result result, H.Request req, H.Response resp) {
        super(result);
        this.req = (H.Request)$.requireNotNull((Object)req);
        this.resp = (H.Response)$.requireNotNull((Object)resp);
    }

    public Result result() {
        return (Result)this.source();
    }

    public H.Request request() {
        return this.req;
    }

    public H.Response response() {
        return this.resp;
    }
}

