/*
 * Decompiled with CFR 0.152.
 */
package act.inject;

import act.Act;
import act.app.ActionContext;
import act.app.App;
import act.cli.CliContext;
import act.cli.CliOverHttpContext;
import act.cli.CliSession;
import act.conf.AppConfig;
import act.crypto.AppCrypto;
import act.db.Dao;
import act.event.EventBus;
import act.job.JobContext;
import act.mail.MailerContext;
import act.route.Router;
import act.util.ActContext;
import act.util.ProgressGauge;
import act.util.SimpleProgressGauge;
import act.view.ViewManager;
import act.ws.SecureTicketCodec;
import act.ws.WebSocketContext;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.inject.Provider;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.cache.CacheService;
import org.osgl.exception.NotAppliedException;
import org.osgl.http.H;
import org.osgl.inject.NamedProvider;
import org.osgl.logging.Logger;
import org.osgl.util.E;
import org.osgl.util.S;
import org.osgl.web.util.UserAgent;

public final class ActProviders {
    private static Set<Class> providedTypes;
    public static final Provider<App> APP;
    public static final Provider<ActionContext> ACTION_CONTEXT;
    public static final Provider<H.Session> SESSION;
    public static final Provider<H.Flash> FLASH;
    public static final Provider<H.Request> REQUEST;
    public static final Provider<H.Response> RESPONSE;
    public static final Provider<CliContext> CLI_CONTEXT;
    public static final Provider<CliSession> CLI_SESSION;
    public static final Provider<ProgressGauge> PROGRESS_GAUGE;
    public static final Provider<MailerContext> MAILER_CONTEXT;
    public static final Provider<WebSocketContext> WEB_SOCKET_CONTEXT;
    public static final Provider<ActContext> ACT_CONTEXT;
    public static final Provider<Logger> LOGGER;
    public static final Provider<UserAgent> USER_AGENT;
    public static final Provider<AppConfig> APP_CONFIG;
    public static final Provider<AppCrypto> APP_CRYPTO;
    public static final Provider<CacheService> APP_CACHE_SERVICE;
    public static final NamedProvider<CacheService> APP_NAMED_CACHE_SERVICE;
    public static final NamedProvider<H.Cookie> COOKIE;
    public static final Provider<Router> ROUTER_PROVIDER;
    public static final NamedProvider<Router> NAMED_ROUTER_PROVIDER;
    public static final Provider<ViewManager> VIEW_MANAGER;
    public static final Provider<EventBus> EVENT_BUS;
    public static final Provider<Locale> LOCALE;
    public static final Provider<SecureTicketCodec> SECURE_TICKET_CODEC_PROVIDER;

    private ActProviders() {
    }

    public static void classInit(App app) {
        providedTypes = app.createSet();
        ActProviders.init(providedTypes);
    }

    public static void testClassInit() {
        providedTypes = new HashSet<Class>();
        ActProviders.init(providedTypes);
    }

    private static void init(final Set<Class> providedTypes) {
        ActProviders.registerBuiltInNamedProviders(ActProviders.class, new Lang.F2<Class, NamedProvider, Void>(){

            public Void apply(Class aClass, NamedProvider provider) throws NotAppliedException, Lang.Break {
                providedTypes.add(aClass);
                return null;
            }
        });
        ActProviders.registerBuiltInProviders(ActProviders.class, new Lang.F2<Class, Provider, Void>(){

            public Void apply(Class aClass, Provider provider) throws NotAppliedException, Lang.Break {
                providedTypes.add(aClass);
                return null;
            }
        });
    }

    public static void registerBuiltInProviders(Class<?> providersClass, Lang.Func2<Class, Provider, ?> register) {
        for (Field field : providersClass.getDeclaredFields()) {
            try {
                if (!Provider.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                Type type = field.getGenericType();
                if (!(type instanceof ParameterizedType)) continue;
                ParameterizedType ptype = (ParameterizedType)$.cast((Object)field.getGenericType());
                Provider provider = (Provider)$.cast((Object)field.get(null));
                register.apply((Object)((Class)ptype.getActualTypeArguments()[0]), (Object)provider);
            }
            catch (Exception e) {
                throw E.unexpected((Throwable)e);
            }
        }
    }

    public static void registerBuiltInNamedProviders(Class<?> providersClass, Lang.Func2<Class, NamedProvider, ?> register) {
        for (Field field : providersClass.getDeclaredFields()) {
            try {
                if (!NamedProvider.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                Type type = field.getGenericType();
                if (!(type instanceof ParameterizedType)) continue;
                ParameterizedType ptype = (ParameterizedType)$.cast((Object)field.getGenericType());
                NamedProvider provider = (NamedProvider)$.cast((Object)field.get(null));
                register.apply((Object)((Class)ptype.getActualTypeArguments()[0]), (Object)provider);
            }
            catch (Exception e) {
                throw E.unexpected((Throwable)e);
            }
        }
    }

    public static boolean isProvided(Class<?> aClass) {
        return providedTypes.contains(aClass) || Dao.class.isAssignableFrom(aClass);
    }

    private static App app() {
        return App.instance();
    }

    public static void addProvidedType(Class<?> aClass) {
        providedTypes.add(aClass);
    }

    static {
        APP = new Provider<App>(){

            public App get() {
                return ActProviders.app();
            }
        };
        ACTION_CONTEXT = new Provider<ActionContext>(){

            public ActionContext get() {
                return ActionContext.current();
            }
        };
        SESSION = new Provider<H.Session>(){

            public H.Session get() {
                return ActionContext.current().session();
            }
        };
        FLASH = new Provider<H.Flash>(){

            public H.Flash get() {
                return ActionContext.current().flash();
            }
        };
        REQUEST = new Provider<H.Request>(){

            public H.Request get() {
                return ActionContext.current().req();
            }
        };
        RESPONSE = new Provider<H.Response>(){

            public H.Response get() {
                return ActionContext.current().resp();
            }
        };
        CLI_CONTEXT = new Provider<CliContext>(){

            public CliContext get() {
                return CliContext.current();
            }
        };
        CLI_SESSION = new Provider<CliSession>(){

            public CliSession get() {
                CliContext context = CliContext.current();
                return null == context ? null : context.session();
            }
        };
        PROGRESS_GAUGE = new Provider<ProgressGauge>(){

            public ProgressGauge get() {
                ActContext.Base<?> context = ActContext.Base.currentContext();
                if (null != context) {
                    return context.progress();
                }
                return new SimpleProgressGauge();
            }
        };
        MAILER_CONTEXT = new Provider<MailerContext>(){

            public MailerContext get() {
                return MailerContext.current();
            }
        };
        WEB_SOCKET_CONTEXT = new Provider<WebSocketContext>(){

            public WebSocketContext get() {
                return WebSocketContext.current();
            }
        };
        ACT_CONTEXT = new Provider<ActContext>(){

            public ActContext get() {
                ActContext.Base ctx = MailerContext.current();
                if (null != ctx) {
                    return ctx;
                }
                ctx = WebSocketContext.current();
                if (null != ctx) {
                    return ctx;
                }
                ctx = ActionContext.current();
                if (null != ctx) {
                    return ctx;
                }
                ctx = CliContext.current();
                if (null != ctx) {
                    return ctx;
                }
                ctx = CliOverHttpContext.current();
                if (null != ctx) {
                    return ctx;
                }
                return JobContext.current();
            }
        };
        LOGGER = new Provider<Logger>(){

            public Logger get() {
                return Act.LOGGER;
            }
        };
        USER_AGENT = new Provider<UserAgent>(){

            public UserAgent get() {
                ActionContext actionContext = ActionContext.current();
                if (null == actionContext) {
                    throw new IllegalStateException();
                }
                return actionContext.userAgent();
            }
        };
        APP_CONFIG = new Provider<AppConfig>(){

            public AppConfig get() {
                return ActProviders.app().config();
            }
        };
        APP_CRYPTO = new Provider<AppCrypto>(){

            public AppCrypto get() {
                return ActProviders.app().crypto();
            }
        };
        APP_CACHE_SERVICE = new Provider<CacheService>(){

            public CacheService get() {
                return ActProviders.app().cache();
            }
        };
        APP_NAMED_CACHE_SERVICE = new NamedProvider<CacheService>(){

            public CacheService get(String name) {
                return ActProviders.app().cache(name);
            }
        };
        COOKIE = new NamedProvider<H.Cookie>(){

            public H.Cookie get(String s) {
                ActionContext ctx = ActionContext.current();
                if (null == ctx) {
                    return null;
                }
                H.Request req = ctx.req();
                return null == req ? null : req.cookie(S.ensure((Object)s).strippedOff("", "Cookie"));
            }
        };
        ROUTER_PROVIDER = new Provider<Router>(){

            public Router get() {
                ActionContext ctx = ActionContext.current();
                return null == ctx ? Act.app().router() : ctx.router();
            }
        };
        NAMED_ROUTER_PROVIDER = new NamedProvider<Router>(){

            public Router get(String name) {
                Router router = Act.app().router(name);
                return null == router ? Act.injector().get(Router.class) : router;
            }
        };
        VIEW_MANAGER = new Provider<ViewManager>(){

            public ViewManager get() {
                return Act.viewManager();
            }
        };
        EVENT_BUS = new Provider<EventBus>(){

            public EventBus get() {
                return ActProviders.app().eventBus();
            }
        };
        LOCALE = new Provider<Locale>(){

            public Locale get() {
                ActContext.Base<?> context = ActContext.Base.currentContext();
                return null != context ? context.locale(true) : ActProviders.app().config().locale();
            }
        };
        SECURE_TICKET_CODEC_PROVIDER = new Provider<SecureTicketCodec>(){

            public SecureTicketCodec get() {
                AppConfig config = Act.appConfig();
                return config.secureTicketCodec();
            }
        };
    }
}

