/*
 * Decompiled with CFR 0.152.
 */
package act.inject.param;

import act.inject.genie.GenieInjector;
import act.inject.param.FieldLoader;
import act.inject.param.ParamKey;
import act.inject.param.ParamValueLoader;
import act.inject.param.ParamValueLoaderService;
import act.util.ActContext;
import act.util.LogSupport;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.InjectException;

class PojoLoader
extends LogSupport
implements ParamValueLoader {
    final ParamKey key;
    final BeanSpec spec;
    final GenieInjector injector;
    final ParamValueLoaderService service;
    final boolean provided;
    protected Map<String, FieldLoader> fieldLoaders;

    public PojoLoader(ParamKey key, BeanSpec spec, ParamValueLoaderService service) {
        this.key = (ParamKey)$.requireNotNull((Object)key);
        this.spec = spec;
        this.injector = service.injector;
        this.service = service;
        this.provided = ParamValueLoaderService.provided(spec, this.injector);
        this.fieldLoaders = this.fieldLoaders(key, spec);
    }

    @Override
    public Object load(Object bean, ActContext<?> context, boolean noDefaultValue) {
        final Lang.Var beanBag = $.var((Object)bean);
        Lang.Factory<Object> beanSource = new Lang.Factory<Object>(){

            public Object create() {
                Object bean = beanBag.get();
                if (null == bean) {
                    try {
                        bean = PojoLoader.this.provided ? PojoLoader.this.injector.get(PojoLoader.this.spec) : $.newInstance((Class)PojoLoader.this.spec.rawType());
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new InjectException((Throwable)e, "cannot instantiate %s", new Object[]{PojoLoader.this.spec});
                    }
                }
                beanBag.set(bean);
                return bean;
            }
        };
        for (FieldLoader fl : this.fieldLoaders.values()) {
            fl.applyTo((Lang.Func0<Object>)beanSource, context);
        }
        return beanBag.get();
    }

    @Override
    public String bindName() {
        return this.key.toString();
    }

    private Map<String, FieldLoader> fieldLoaders(ParamKey key, BeanSpec spec) {
        HashMap<String, FieldLoader> fieldLoaders = new HashMap<String, FieldLoader>();
        for (Class current = spec.rawType(); null != current && !current.equals(Object.class); current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (ParamValueLoaderService.shouldWaive(field)) continue;
                field.setAccessible(true);
                String fieldName = field.getName();
                fieldLoaders.put(fieldName, this.service.fieldLoader(key, field, spec.field(fieldName)));
            }
        }
        return fieldLoaders;
    }
}

