/*
 * Decompiled with CFR 0.152.
 */
package act.job;

import act.Act;
import act.app.App;
import act.app.event.SysEventId;
import act.event.SysEventListenerBase;
import act.job.JobContext;
import act.job.JobManager;
import act.job.JobTrigger;
import act.route.DuplicateRouteMappingException;
import act.util.DestroyableBase;
import act.util.ProgressGauge;
import act.util.SimpleProgressGauge;
import act.ws.WebSocketConnectionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.ConfigurationException;
import org.osgl.exception.NotAppliedException;
import org.osgl.exception.UnexpectedException;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class Job
extends DestroyableBase
implements Runnable {
    static final String BRIEF_VIEW = "id,oneTime,executed,trigger";
    static final String DETAIL_VIEW = "id,oneTime,executed,trigger,worker";
    private static final C.Set<Class<? extends UnexpectedException>> FATAL_EXCEPTIONS = C.set(DuplicateRouteMappingException.class, (Object[])new Class[]{ConfigurationException.class});
    private final String id;
    private final String jobProgressTag;
    private App app;
    private boolean oneTime;
    private boolean executed;
    private JobManager manager;
    private JobTrigger trigger;
    private Lang.Func0<?> worker;
    Object callableResult;
    Exception callableException;
    private SimpleProgressGauge progress = new SimpleProgressGauge();
    private LockableJobList parallelJobs = new LockableJobList(this);
    private LockableJobList followingJobs = new LockableJobList(this);
    private LockableJobList precedenceJobs = new LockableJobList(this);

    private Job(String id) {
        this.id = id;
        this.jobProgressTag = SimpleProgressGauge.wsJobProgressTag(id);
    }

    Job(String id, JobManager manager) {
        this(id, manager, (Lang.Func0)null);
    }

    Job(String id, JobManager manager, final Callable<?> callable) {
        this.id = id;
        this.manager = (JobManager)$.requireNotNull((Object)manager);
        this.oneTime = true;
        this.app = manager.app();
        this.jobProgressTag = SimpleProgressGauge.wsJobProgressTag(id);
        this.manager.addJob(this);
        this.worker = new Lang.F0(){

            public Object apply() throws NotAppliedException, Lang.Break {
                try {
                    Job.this.callableResult = callable.call();
                }
                catch (Exception e) {
                    Job.this.callableException = e;
                }
                return null;
            }
        };
    }

    Job(String id, JobManager manager, Lang.Func0<?> worker) {
        this(id, manager, worker, true);
    }

    Job(String id, JobManager manager, Lang.Func0<?> worker, boolean oneTime) {
        this.id = id;
        this.manager = (JobManager)$.NPE((Object)manager);
        this.worker = worker;
        this.oneTime = oneTime;
        this.app = manager.app();
        this.jobProgressTag = SimpleProgressGauge.wsJobProgressTag(id);
        this.manager.addJob(this);
    }

    Job(String id, JobManager manager, Lang.Function<ProgressGauge, ?> worker) {
        this(id, manager, worker, true);
    }

    Job(String id, JobManager manager, Lang.Function<ProgressGauge, ?> worker, boolean oneTime) {
        this.id = id;
        this.manager = (JobManager)$.requireNotNull((Object)manager);
        Lang.F1 f1 = $.f1(worker);
        this.worker = f1.curry((Object)this.progress);
        this.oneTime = oneTime;
        this.app = manager.app();
        this.jobProgressTag = SimpleProgressGauge.wsJobProgressTag(id);
        this.manager.addJob(this);
    }

    public void setProgressGauge(ProgressGauge progressGauge) {
        this.progress = SimpleProgressGauge.wrap(progressGauge);
        this.progress.setId(this.getId());
        this.progress.addListener(new ProgressGauge.Listener(){

            @Override
            public void onUpdate(ProgressGauge progressGauge) {
                C.Map payload = C.Map((Object[])new Object[]{"act_job_progress", progressGauge});
                Job.this.app.getInstance(WebSocketConnectionManager.class).sendJsonToTagged((Object)payload, Job.this.jobProgressTag);
            }
        });
    }

    public SimpleProgressGauge progress() {
        return this.progress;
    }

    public int getProgressInPercent() {
        return this.progress.currentProgressPercent();
    }

    @Override
    protected void releaseResources() {
        this.worker = null;
        this.manager = null;
        this.parallelJobs.clear();
        this.followingJobs.clear();
        this.precedenceJobs.clear();
        super.releaseResources();
    }

    protected String brief() {
        return S.concat((String)"job[", (String)this.id, (String)"]\none time job:", (String)S.string((Object)this.oneTime), (String)"\ntrigger:", (String[])new String[]{S.string((Object)this.trigger)});
    }

    public String toString() {
        S.Buffer sb = S.buffer((String)this.brief());
        Job.printSubJobs(this.parallelJobs.jobList, "parallel jobs", sb);
        Job.printSubJobs(this.followingJobs.jobList, "following jobs", sb);
        Job.printSubJobs(this.precedenceJobs.jobList, "precedence jobs", sb);
        return sb.toString();
    }

    private static void printSubJobs(Collection<? extends Job> subJobs, String label, S.Buffer sb) {
        if (null != subJobs && !subJobs.isEmpty()) {
            sb.append("\n").append(label);
            for (Job job : subJobs) {
                sb.append("\n\t").append(job.brief());
            }
        }
    }

    Job setOneTime() {
        this.oneTime = true;
        return this;
    }

    boolean done() {
        return this.executed && this.oneTime;
    }

    final String id() {
        return this.id;
    }

    final void trigger(JobTrigger trigger) {
        E.NPE((Object)trigger);
        this.trigger = trigger;
    }

    final Job addParallelJob(Job thatJob) {
        return this.parallelJobs.add(thatJob);
    }

    final Job addFollowingJob(Job thatJob) {
        return this.followingJobs.add(thatJob);
    }

    final Job addPrecedenceJob(Job thatJob) {
        return this.precedenceJobs.add(thatJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.invokeParallelJobs();
        this.runPrecedenceJobs();
        try {
            if (Act.isDev() && this.app.isStarted()) {
                this.app.checkUpdates(false);
            }
            this.doJob();
        }
        catch (Throwable e) {
            block27: {
                block28: {
                    try {
                        isFatal = Job.FATAL_EXCEPTIONS.contains(e.getClass());
                        cause = e;
                        if (!isFatal) {
                            for (cause = e.getCause(); null != cause && !(isFatal = Job.FATAL_EXCEPTIONS.contains(cause.getClass())); cause = cause.getCause()) {
                            }
                        }
                        if (!isFatal) break block27;
                        if (Act.isDev()) {
                            this.app.setBlockIssue(e);
                            break block28;
                        }
                        Act.shutdown(App.instance());
                        this.destroy();
                        if (App.instance().isMainThread()) {
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            throw E.unexpected((Throwable)e);
                        }
                        this.logger.fatal(cause, "Fatal error executing job %s", new Object[]{this.id()});
                    }
                    catch (Throwable var5_7) {
                        if (!this.isDestroyed()) {
                            this.executed = true;
                            if (this.isOneTime()) {
                                app = App.instance();
                                if (app.isStarted()) {
                                    this.manager.removeJob(this);
                                } else {
                                    app.eventBus().bind(SysEventId.POST_START, new SysEventListenerBase(){

                                        @Override
                                        public void on(EventObject event) throws Exception {
                                            Job.this.manager.removeJob(Job.this);
                                        }
                                    });
                                }
                            }
                            this.progress.destroy();
                        }
                        throw var5_7;
                    }
                }
                if (!this.isDestroyed()) {
                    this.executed = true;
                    if (this.isOneTime()) {
                        app = App.instance();
                        if (app.isStarted()) {
                            this.manager.removeJob(this);
                        } else {
                            app.eventBus().bind(SysEventId.POST_START, new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                    this.progress.destroy();
                }
                return;
            }
            this.logger.warn(e, "error executing job %s", new Object[]{this.id()});
            if (!this.isDestroyed()) {
                this.executed = true;
                if (this.isOneTime()) {
                    app = App.instance();
                    if (app.isStarted()) {
                        this.manager.removeJob(this);
                    } else {
                        app.eventBus().bind(SysEventId.POST_START, new /* invalid duplicate definition of identical inner class */);
                    }
                }
                this.progress.destroy();
            } else {
                ** GOTO lbl75
            }
        }
        if (!this.isDestroyed()) {
            this.executed = true;
            if (this.isOneTime()) {
                app = App.instance();
                if (app.isStarted()) {
                    this.manager.removeJob(this);
                } else {
                    app.eventBus().bind(SysEventId.POST_START, new /* invalid duplicate definition of identical inner class */);
                }
            }
            this.progress.destroy();
        }
        this.runFollowingJobs();
    }

    protected void _before() {
        JobContext.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doJob() {
        try {
            this._before();
            if (null != this.worker) {
                this.worker.apply();
            }
        }
        finally {
            this.scheduleNextInvocation();
            this._finally();
        }
    }

    protected void _finally() {
    }

    protected void cancel() {
        this.manager.cancel(this.id());
    }

    private void runPrecedenceJobs() {
        this.precedenceJobs.runSubJobs();
    }

    private void runFollowingJobs() {
        this.followingJobs.runSubJobs();
    }

    private void invokeParallelJobs() {
        this.parallelJobs.runSubJobs(true);
    }

    protected final JobManager manager() {
        return this.manager;
    }

    protected void scheduleNextInvocation() {
        if (null != this.trigger) {
            this.trigger.scheduleFollowingCalls(this.manager(), this);
        }
    }

    private static Job of(String jobId, final Runnable runnable, JobManager manager, boolean oneTime) {
        return new Job(jobId, manager, (Lang.Func0<?>)new Lang.F0(){

            public Object apply() throws NotAppliedException, Lang.Break {
                runnable.run();
                return null;
            }
        }, oneTime);
    }

    private static Job of(Runnable runnable, JobManager manager, boolean oneTime) {
        return Job.of(Act.cuid(), runnable, manager, oneTime);
    }

    static Job once(Runnable runnable, JobManager manager) {
        return Job.of(runnable, manager, true);
    }

    static Job once(String jobId, Runnable runnable, JobManager manager) {
        return Job.of(jobId, runnable, manager, true);
    }

    static Job multipleTimes(Runnable runnable, JobManager manager) {
        return Job.of(runnable, manager, false);
    }

    static Job multipleTimes(String jobId, Runnable runnable, JobManager manager) {
        return Job.of(jobId, runnable, manager, false);
    }

    private static String uuid() {
        return UUID.randomUUID().toString();
    }

    public String getId() {
        return this.id;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public boolean isOneTime() {
        return this.oneTime;
    }

    public JobTrigger trigger() {
        return this.trigger;
    }

    static Job virtualJob(String jobId, JobManager manager) {
        Job job = new Job(jobId);
        job.manager = manager;
        return job;
    }

    private static class LockableJobList {
        boolean iterating;
        List<Job> jobList = new ArrayList<Job>();
        Job parent;

        LockableJobList(Job parent) {
            this.parent = parent;
        }

        synchronized void clear() {
            this.jobList.clear();
        }

        synchronized Job add(Job thatJob) {
            if (this.parent.isOneTime()) {
                thatJob.setOneTime();
            }
            if (this.parent.done() || this.iterating) {
                this.parent.manager.now(thatJob);
                return this.parent;
            }
            this.jobList.add(thatJob);
            return this.parent;
        }

        synchronized void runSubJobs() {
            this.runSubJobs(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void runSubJobs(boolean async) {
            if (this.jobList.isEmpty()) {
                return;
            }
            JobManager jobManager = async ? Act.jobManager() : null;
            this.iterating = true;
            try {
                for (final Job subJob : this.jobList) {
                    if (null != jobManager) {
                        jobManager.now(new Runnable(){

                            @Override
                            public void run() {
                                subJob.run();
                            }
                        });
                        continue;
                    }
                    subJob.run();
                    if (!Act.isDev() || !subJob.app.hasBlockIssue()) continue;
                    break;
                }
            }
            finally {
                this.iterating = false;
            }
        }
    }
}

