/*
 * Decompiled with CFR 0.152.
 */
package act.job;

import act.Act;
import act.Destroyable;
import act.app.App;
import act.app.AppServiceBase;
import act.app.AppThreadFactory;
import act.app.event.SysEventId;
import act.event.OnceEventListenerBase;
import act.event.SysEventListenerBase;
import act.job.Job;
import act.job.JobContext;
import act.job.JobTrigger;
import act.mail.MailerContext;
import act.util.ProgressGauge;
import act.util.SimpleProgressGauge;
import java.util.EventObject;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;
import org.rythmengine.utils.Time;

public class JobManager
extends AppServiceBase<JobManager> {
    private static final Logger LOGGER = LogManager.get(JobManager.class);
    private ScheduledThreadPoolExecutor executor;
    private ConcurrentMap<String, Job> jobs = new ConcurrentHashMap<String, Job>();
    private ConcurrentMap<String, ScheduledFuture> scheduled = new ConcurrentHashMap<String, ScheduledFuture>();

    static String sysEventJobId(SysEventId eventId) {
        return S.concat((String)"__act_sys__", (String)eventId.toString().toLowerCase());
    }

    public JobManager(App app) {
        super(app);
        this.initExecutor(app);
        for (SysEventId sysEventId : SysEventId.values()) {
            this.createSysEventListener(sysEventId);
        }
    }

    @Override
    protected void releaseResources() {
        LOGGER.trace("release job manager resources");
        for (Job job : this.jobs.values()) {
            job.destroy();
        }
        this.jobs.clear();
        this.executor.getQueue().clear();
        this.executor.shutdownNow();
    }

    public <T> Future<T> now(Callable<T> callable) {
        return this.now(this.randomJobId(), callable);
    }

    public <T> Future<T> now(String jobId, Callable<T> callable) {
        final Job job = this.wrap(jobId, callable);
        return this.executor().submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                job.run();
                if (null != job.callableException) {
                    throw job.callableException;
                }
                return job.callableResult;
            }
        });
    }

    public void now(Runnable runnable) {
        this.now(this.randomJobId(), runnable);
    }

    public void now(String jobId, Runnable runnable) {
        this.executor().submit(this.wrap(jobId, runnable));
    }

    public String now(Lang.Function<ProgressGauge, ?> worker) {
        return this.now(this.randomJobId(), worker);
    }

    public String now(String jobId, Lang.Function<ProgressGauge, ?> worker) {
        Job job = this.wrap(jobId, worker);
        this.executor().submit(job);
        return job.id();
    }

    public String prepare(Lang.Function<ProgressGauge, ?> worker) {
        Job job = this.wrap(worker);
        return job.id();
    }

    public void now(String jobId) {
        Job job = (Job)$.requireNotNull((Object)this.jobById(jobId));
        this.executor().submit(job);
    }

    public <T> Future<T> delay(Callable<T> callable, long delay, TimeUnit timeUnit) {
        return this.executor().schedule(callable, delay, timeUnit);
    }

    public void delay(Runnable runnable, long delay, TimeUnit timeUnit) {
        this.executor().schedule(this.wrap(runnable), delay, timeUnit);
    }

    public <T> Future<T> delay(Callable<T> callable, String delay) {
        int seconds = this.parseTime(delay);
        return this.executor().schedule(callable, (long)seconds, TimeUnit.SECONDS);
    }

    public void delay(Runnable runnable, String delay) {
        int seconds = this.parseTime(delay);
        this.executor().schedule(this.wrap(runnable), (long)seconds, TimeUnit.SECONDS);
    }

    public void every(String id, Runnable runnable, String interval) {
        JobTrigger.every(interval, false).schedule(this, Job.multipleTimes(id, runnable, this));
    }

    public void every(Runnable runnable, String interval) {
        JobTrigger.every(interval, false).schedule(this, Job.multipleTimes(runnable, this));
    }

    public void every(Runnable runnable, long interval, TimeUnit timeUnit) {
        JobTrigger.every(interval, timeUnit, false).schedule(this, Job.multipleTimes(runnable, this));
    }

    public void every(String id, Runnable runnable, long interval, TimeUnit timeUnit) {
        JobTrigger.every(interval, timeUnit, false).schedule(this, Job.multipleTimes(id, runnable, this));
    }

    public void fixedDelay(Runnable runnable, String interval) {
        JobTrigger.every(interval, false).schedule(this, Job.multipleTimes(runnable, this));
    }

    public void fixedDelay(String id, Runnable runnable, String interval) {
        JobTrigger.every(interval, false).schedule(this, Job.multipleTimes(id, runnable, this));
    }

    public void fixedDelay(Runnable runnable, long interval, TimeUnit timeUnit) {
        JobTrigger.fixedDelay(interval, timeUnit, false).schedule(this, Job.multipleTimes(runnable, this));
    }

    public void fixedDelay(String id, Runnable runnable, long interval, TimeUnit timeUnit) {
        JobTrigger.fixedDelay(interval, timeUnit, false).schedule(this, Job.multipleTimes(id, runnable, this));
    }

    private int parseTime(String timeDuration) {
        if (timeDuration.startsWith("${") && timeDuration.endsWith("}")) {
            timeDuration = (String)this.app().config().get(timeDuration.substring(2, timeDuration.length() - 1));
        }
        return Time.parseDuration((String)timeDuration);
    }

    public void on(DateTime instant, Runnable runnable) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("schedule runnable[%s] on %s", new Object[]{runnable, instant});
        }
        DateTime now = DateTime.now();
        E.illegalArgumentIf((boolean)instant.isBefore((ReadableInstant)now));
        Seconds seconds = Seconds.secondsBetween((ReadableInstant)now, (ReadableInstant)instant);
        this.executor().schedule(this.wrap(runnable), (long)seconds.getSeconds(), TimeUnit.SECONDS);
    }

    public <T> Future<T> on(DateTime instant, Callable<T> callable) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("schedule callable[%s] on %s", new Object[]{callable, instant});
        }
        DateTime now = DateTime.now();
        E.illegalArgumentIf((boolean)instant.isBefore((ReadableInstant)now));
        Seconds seconds = Seconds.secondsBetween((ReadableInstant)now, (ReadableInstant)instant);
        return this.executor().schedule(callable, (long)seconds.getSeconds(), TimeUnit.SECONDS);
    }

    public void on(SysEventId sysEvent, Runnable runnable) {
        this.on(sysEvent, runnable, false);
    }

    public void on(SysEventId sysEvent, Runnable runnable, boolean runImmediatelyIfEventDispatched) {
        this.on(sysEvent, runnable.toString(), runnable, runImmediatelyIfEventDispatched);
    }

    public void post(SysEventId sysEvent, Runnable runnable) {
        this.post(sysEvent, runnable, false);
    }

    public void post(SysEventId sysEvent, Runnable runnable, boolean runImmediatelyIfEventDispatched) {
        Job job = this.jobById(JobManager.sysEventJobId(sysEvent));
        if (null == job) {
            this.processDelayedJob(this.wrap(runnable), runImmediatelyIfEventDispatched);
        } else {
            job.addFollowingJob(Job.once(runnable, this));
        }
    }

    public void on(SysEventId sysEvent, String jobId, Runnable runnable) {
        this.on(sysEvent, jobId, runnable, false);
    }

    public void on(SysEventId sysEvent, String jobId, Runnable runnable, boolean runImmediatelyIfEventDispatched) {
        Job job;
        boolean traceEnabled = LOGGER.isTraceEnabled();
        if (traceEnabled) {
            LOGGER.trace("binding job[%s] to app event: %s, run immediately if event dispatched: %s", new Object[]{jobId, sysEvent, runImmediatelyIfEventDispatched});
        }
        if (null == (job = this.jobById(JobManager.sysEventJobId(sysEvent)))) {
            if (traceEnabled) {
                LOGGER.trace("process delayed job: %s", new Object[]{jobId});
            }
            this.processDelayedJob(this.wrap(runnable), runImmediatelyIfEventDispatched);
        } else {
            if (traceEnabled) {
                LOGGER.trace("schedule job: %s", new Object[]{jobId});
            }
            job.addPrecedenceJob(Job.once(jobId, runnable, this));
        }
    }

    public void post(SysEventId sysEvent, String jobId, Runnable runnable) {
        this.post(sysEvent, jobId, runnable, false);
    }

    public void post(SysEventId sysEvent, String jobId, Runnable runnable, boolean runImmediatelyIfEventDispatched) {
        Job job = this.jobById(JobManager.sysEventJobId(sysEvent));
        if (null == job) {
            this.processDelayedJob(this.wrap(runnable), runImmediatelyIfEventDispatched);
        } else {
            job.addFollowingJob(Job.once(jobId, runnable, this));
        }
    }

    public void alongWith(SysEventId sysEvent, String jobId, Runnable runnable) {
        Job job = this.jobById(JobManager.sysEventJobId(sysEvent));
        if (null == job) {
            this.processDelayedJob(this.wrap(runnable), false);
        } else {
            job.addParallelJob(Job.once(jobId, runnable, this));
        }
    }

    @Override
    protected void warn(String format, Object ... args) {
        super.warn(format, args);
    }

    private void processDelayedJob(Job job, boolean runImmediatelyIfEventDispatched) {
        if (runImmediatelyIfEventDispatched) {
            try {
                job.run();
            }
            catch (Exception e) {
                Act.LOGGER.error((Throwable)e, "Error running job");
            }
        } else {
            this.now(job);
        }
    }

    public void cancel(String jobId) {
        Job job = this.jobById(jobId);
        if (null != job) {
            this.removeJob(job);
        } else {
            ScheduledFuture future = (ScheduledFuture)this.scheduled.remove(jobId);
            if (null != future) {
                future.cancel(true);
            }
        }
    }

    public void beforeAppStart(Runnable runnable) {
        this.on(SysEventId.START, runnable);
    }

    public void afterAppStart(Runnable runnable) {
        this.post(SysEventId.START, runnable);
    }

    public void beforeAppStop(Runnable runnable) {
        this.on(SysEventId.STOP, runnable);
    }

    public SimpleProgressGauge progressGauge(String jobId) {
        return this.jobById(jobId).progress();
    }

    public void setJobProgressGauge(String jobId, ProgressGauge progressGauge) {
        Job job = this.jobById(jobId);
        if (null == job) {
            LOGGER.warn("cannot find job by Id: " + jobId);
        } else {
            job.setProgressGauge(progressGauge);
        }
    }

    C.List<Job> jobs() {
        return C.list(this.jobs.values());
    }

    C.List<Job> virtualJobs() {
        final JobManager jobManager = Act.jobManager();
        return C.list(this.scheduled.entrySet()).map((Lang.Function)new Lang.Transformer<Map.Entry<String, ScheduledFuture>, Job>(){

            public Job transform(Map.Entry<String, ScheduledFuture> entry) {
                return Job.virtualJob(entry.getKey(), jobManager);
            }
        });
    }

    void futureScheduled(String id, ScheduledFuture future) {
        this.scheduled.putIfAbsent(id, future);
    }

    Job jobById(String id) {
        Job job = (Job)this.jobs.get(id);
        if (null == job) {
            ScheduledFuture future = (ScheduledFuture)this.scheduled.get(id);
            if (null != future) {
                return new Job(id, Act.jobManager());
            }
            Act.LOGGER.warn("cannot find job by id: %s", new Object[]{id});
        }
        return job;
    }

    void addJob(Job job) {
        String id = job.id();
        E.illegalStateIf((boolean)this.jobs.containsKey(id), (String)"job already registered: %s", (Object[])new Object[]{id});
        this.jobs.put(id, job);
    }

    void removeJob(Job job) {
        String id = job.id();
        this.jobs.remove(id);
        ScheduledFuture future = (ScheduledFuture)this.scheduled.remove(id);
        if (null != future) {
            future.cancel(true);
        }
    }

    ScheduledThreadPoolExecutor executor() {
        return this.executor;
    }

    private void initExecutor(App app) {
        int poolSize = app.config().jobPoolSize();
        this.executor = new ScheduledThreadPoolExecutor(poolSize, new AppThreadFactory("jobs"), new ThreadPoolExecutor.AbortPolicy());
        this.executor.setRemoveOnCancelPolicy(true);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("init executor with thread pool: %s", new Object[]{poolSize});
        }
    }

    private void createSysEventListener(SysEventId sysEventId) {
        String jobId = JobManager.sysEventJobId(sysEventId);
        Job job = new Job(jobId, this);
        this.app().eventBus().bind(sysEventId, new _SysEventListener(jobId, job));
    }

    private Job wrap(Runnable runnable) {
        return new ContextualJob(this.randomJobId(), runnable);
    }

    private Job wrap(String name, Runnable runnable) {
        return new ContextualJob(name, runnable);
    }

    private Job wrap(Callable callable) {
        return new ContextualJob(this.randomJobId(), callable);
    }

    private Job wrap(String name, Callable callable) {
        return new ContextualJob(name, callable);
    }

    private Job wrap(Lang.Function<ProgressGauge, ?> worker) {
        return new ContextualJob(this.randomJobId(), worker);
    }

    private Job wrap(String name, Lang.Function<ProgressGauge, ?> worker) {
        return new ContextualJob(name, worker);
    }

    private String randomJobId() {
        return this.app().cuid() + S.random((int)4);
    }

    private class ContextualJob
    extends Job {
        private JobContext origin_;

        ContextualJob(String id, Callable<?> callable) {
            super(id, JobManager.this, callable);
            this.origin_ = JobContext.copy();
        }

        ContextualJob(String id, final Runnable runnable) {
            super(id, JobManager.this, (Lang.Func0<?>)new Lang.F0(){

                public Object apply() throws NotAppliedException, Lang.Break {
                    runnable.run();
                    return null;
                }
            }, true);
            this.origin_ = JobContext.copy();
            this.foo();
        }

        ContextualJob(String id, Lang.Function<ProgressGauge, ?> worker) {
            super(id, JobManager.this, worker);
            this.origin_ = JobContext.copy();
            this.foo();
        }

        @Override
        protected void _before() {
            JobContext.init(this.origin_);
        }

        @Override
        protected void _finally() {
            JobContext.clear();
            JobManager.this.removeJob(this);
        }

        private void foo() {
            JobManager.this.app().eventBus().once(MailerContext.InitEvent.class, new OnceEventListenerBase<MailerContext.InitEvent>(){

                @Override
                public boolean tryHandle(MailerContext.InitEvent event) throws Exception {
                    MailerContext mailerContext = MailerContext.current();
                    if (null != mailerContext) {
                        ContextualJob.this._before();
                        return true;
                    }
                    return true;
                }
            });
        }
    }

    private static class _SysEventListener
    extends SysEventListenerBase {
        private Runnable worker;

        _SysEventListener(String id, Runnable worker) {
            super(id);
            this.worker = (Runnable)$.NPE((Object)worker);
        }

        @Override
        public void on(EventObject event) throws Exception {
            this.worker.run();
        }

        @Override
        protected void releaseResources() {
            if (null != this.worker && this.worker instanceof Destroyable) {
                ((Destroyable)((Object)this.worker)).destroy();
            }
        }
    }
}

