/*
 * Decompiled with CFR 0.152.
 */
package act.job.bytecode;

import act.app.App;
import act.inject.param.ParamValueLoaderManager;
import act.inject.param.ParamValueLoaderService;
import act.job.JobContext;
import act.job.meta.JobClassMetaInfo;
import act.job.meta.JobMethodMetaInfo;
import act.sys.Env;
import act.util.ReflectedInvokerHelper;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.inject.BeanSpec;
import org.osgl.util.E;

public class ReflectedJobInvoker<M extends JobMethodMetaInfo>
extends Lang.F0<Object> {
    private App app;
    private ClassLoader cl;
    private JobClassMetaInfo classInfo;
    private volatile Class<?> jobClass;
    private MethodAccess methodAccess;
    private M methodInfo;
    private int methodIndex;
    protected Method method;
    private boolean disabled;
    private ParamValueLoaderService paramValueLoaderService;
    private Object singleton;
    private boolean isStatic;

    public ReflectedJobInvoker(M handlerMetaInfo, App app) {
        this.cl = app.classLoader();
        this.methodInfo = handlerMetaInfo;
        this.classInfo = ((JobMethodMetaInfo)handlerMetaInfo).classInfo();
        this.app = app;
        this.isStatic = ((JobMethodMetaInfo)handlerMetaInfo).isStatic();
    }

    private synchronized void init() {
        ParamValueLoaderManager paramValueLoaderManager;
        if (null != this.jobClass) {
            return;
        }
        this.disabled = false;
        this.jobClass = $.classForName((String)this.classInfo.className(), (ClassLoader)this.cl);
        this.disabled = this.disabled || !Env.matches(this.jobClass);
        this.method = ((JobMethodMetaInfo)this.methodInfo).method();
        boolean bl = this.disabled = this.disabled || !Env.matches(this.method);
        if (this.disabled) {
            return;
        }
        this.isStatic = ((JobMethodMetaInfo)this.methodInfo).isStatic();
        if (!this.isStatic) {
            this.singleton = ReflectedInvokerHelper.tryGetSingleton(this.jobClass, this.app);
        }
        if (null != (paramValueLoaderManager = this.app.service(ParamValueLoaderManager.class))) {
            this.paramValueLoaderService = paramValueLoaderManager.get(JobContext.class);
        }
        if (!Modifier.isStatic(this.method.getModifiers())) {
            Class[] paramTypes = this.paramTypes();
            this.methodAccess = MethodAccess.get(this.jobClass);
            this.methodIndex = this.methodAccess.getIndex(((JobMethodMetaInfo)this.methodInfo).name(), paramTypes);
        } else {
            this.method.setAccessible(true);
        }
    }

    public Object apply() throws NotAppliedException, Lang.Break {
        if (null == this.jobClass) {
            this.init();
        }
        if (this.disabled) {
            return null;
        }
        JobContext ctx = JobContext.current();
        ctx.handlerMethod(this.method);
        Object job = this.jobClassInstance(this.app, ctx);
        return this.invoke(job, ctx);
    }

    private Class[] paramTypes() {
        List<BeanSpec> paramTypes = ((JobMethodMetaInfo)this.methodInfo).paramTypes();
        int sz = null == paramTypes ? 0 : paramTypes.size();
        Class[] ca = new Class[sz];
        for (int i = 0; i < sz; ++i) {
            BeanSpec spec = ((JobMethodMetaInfo)this.methodInfo).paramTypes().get(i);
            ca[i] = spec.rawType();
        }
        return ca;
    }

    private Object jobClassInstance(App app, JobContext ctx) {
        if (this.isStatic) {
            return null;
        }
        if (null != this.singleton) {
            return this.singleton;
        }
        return null != this.paramValueLoaderService ? this.paramValueLoaderService.loadHostBean(this.jobClass, ctx) : app.getInstance(this.jobClass);
    }

    private Object invoke(Object jobClassInstance, JobContext ctx) {
        Object[] params = this.params(jobClassInstance, ctx);
        return null == this.methodAccess ? $.invokeStatic((Method)this.method, (Object[])params) : this.methodAccess.invoke(jobClassInstance, this.methodIndex, params);
    }

    private Object[] params(Object job, JobContext ctx) {
        if (null != this.paramValueLoaderService) {
            return this.paramValueLoaderService.loadMethodParams(job, this.method, ctx);
        }
        E.illegalStateIf((this.paramTypes().length > 0 ? 1 : 0) != 0, (String)"Cannot invoke job with parameters before app fully started");
        return new Object[0];
    }
}

