/*
 * Decompiled with CFR 0.152.
 */
package act.metric;

import act.metric.MetricInfo;
import act.metric.MetricStore;
import act.metric.SimpleMetricPlugin;
import act.metric.Timer;
import act.util.LogSupport;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.osgl.$;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

public class SimpleMetricStore
implements MetricStore,
Serializable {
    private static final transient Logger defLogger = LogManager.get((String)"metric.default");
    private static final long serialVersionUID = 7357409264403928225L;
    private ConcurrentMap<String, AtomicLong> counters = new ConcurrentHashMap<String, AtomicLong>();
    private ConcurrentMap<String, AtomicLong> timers = new ConcurrentHashMap<String, AtomicLong>();
    private transient SimpleMetricPlugin plugin;
    private transient FileSynchronizer synchronizer;
    private transient boolean dataSync = true;

    public SimpleMetricStore(SimpleMetricPlugin plugin) {
        this.plugin = (SimpleMetricPlugin)$.requireNotNull((Object)plugin);
        this.synchronizer = new FileSynchronizer();
        SimpleMetricStore persisted = this.synchronizer.read();
        if (null != persisted) {
            this.counters = persisted.counters;
            this.timers = persisted.timers;
        }
    }

    @Override
    public void countOnce(String name) {
        E.illegalArgumentIf((boolean)S.blank((String)name), (String)"name expected");
        this.countOnce_(name);
    }

    private void countOnce_(String name) {
        AtomicLong newAl;
        AtomicLong al = (AtomicLong)this.counters.get(name);
        if (null == al && null == (al = this.counters.putIfAbsent(name, newAl = new AtomicLong()))) {
            al = newAl;
        }
        al.incrementAndGet();
        name = this.getParent(name);
        if (S.notBlank((String)name)) {
            this.countOnce_(name);
        }
    }

    public void enableDataSync(boolean enabled) {
        this.dataSync = enabled;
    }

    @Override
    public void onTimerStart(String name) {
        E.illegalArgumentIf((boolean)S.blank((String)name), (String)"name expected");
        this.countOnce_(name);
        this.logger(name).trace("Timer[%s] started", new Object[]{name});
    }

    @Override
    public void onTimerStop(Timer timer) {
        String name = timer.name();
        long ns = timer.ns();
        this.logger(name).trace("Timer[%s] stopped. Time elapsed: %sns", new Object[]{name, ns});
        this.onTimerStop_(name, ns);
    }

    private void onTimerStop_(String name, long ns) {
        AtomicLong newAl;
        AtomicLong al = (AtomicLong)this.timers.get(name);
        if (null == al && null == (al = this.timers.putIfAbsent(name, newAl = new AtomicLong()))) {
            al = newAl;
        }
        al.addAndGet(ns);
        name = this.getParent(name);
        if (S.notBlank((String)name)) {
            this.onTimerStop_(name, ns);
        }
    }

    @Override
    public Long count(String name) {
        AtomicLong al = (AtomicLong)this.counters.get(name);
        return null == al ? null : Long.valueOf(al.get());
    }

    @Override
    public Long ns(String name) {
        AtomicLong al = (AtomicLong)this.counters.get(name);
        return null == al ? null : Long.valueOf(al.get());
    }

    @Override
    public List<MetricInfo> counters() {
        TreeSet<MetricInfo> set = new TreeSet<MetricInfo>();
        for (Map.Entry entry : this.counters.entrySet()) {
            set.add(new MetricInfo((String)entry.getKey(), ((AtomicLong)entry.getValue()).get()));
        }
        return C.list(set);
    }

    @Override
    public List<MetricInfo> timers() {
        C.Set set = C.newSet();
        for (Map.Entry entry : this.timers.entrySet()) {
            set.add(new MetricInfo((String)entry.getKey(), ((AtomicLong)entry.getValue()).get(), ((AtomicLong)this.counters.get(entry.getKey())).get()));
        }
        return C.list((Collection)set);
    }

    @Override
    public void clear() {
        this.timers.clear();
        this.counters.clear();
    }

    public void takeSnapshot() {
        if (this.dataSync) {
            this.synchronizer.write(this);
        }
    }

    private Logger logger(String name) {
        Logger logger = this.plugin.logger(name);
        return null == logger ? defLogger : logger;
    }

    private String getParent(String name) {
        return S.beforeLast((String)name, (String)":");
    }

    private static class FileSynchronizer
    extends LogSupport {
        private static final String FILE_NAME = ".act.metric";
        private boolean ioError = false;

        private FileSynchronizer() {
        }

        void write(SimpleMetricStore store) {
            if (this.ioError) {
                return;
            }
            ObjectOutputStream oos = null;
            try {
                File file = new File(FILE_NAME);
                oos = new ObjectOutputStream(new FileOutputStream(file));
                oos.writeObject(store);
            }
            catch (IOException e) {
                try {
                    this.ioError = true;
                    throw E.ioException((IOException)e);
                }
                catch (Throwable throwable) {
                    IO.close(oos);
                    throw throwable;
                }
            }
            IO.close((Closeable)oos);
        }

        /*
         * Loose catch block
         */
        SimpleMetricStore read() {
            File file = new File(FILE_NAME);
            if (file.exists() && file.canRead()) {
                SimpleMetricStore simpleMetricStore;
                ObjectInputStream ois = null;
                try {
                    SimpleMetricStore store;
                    ois = new ObjectInputStream(new FileInputStream(file));
                    simpleMetricStore = store = (SimpleMetricStore)$.cast((Object)ois.readObject());
                }
                catch (IOException e) {
                    this.ioError = true;
                    this.error(e, "Error reading simple metric store persisted file:%s. Will reset this file", file.getAbsolutePath());
                    if (!file.delete()) {
                        file.deleteOnExit();
                    }
                    SimpleMetricStore simpleMetricStore2 = null;
                    IO.close((Closeable)ois);
                    return simpleMetricStore2;
                }
                catch (ClassNotFoundException e2) {
                    throw E.unexpected((Throwable)e2);
                    {
                        catch (Throwable throwable) {
                            IO.close(ois);
                            throw throwable;
                        }
                    }
                }
                IO.close((Closeable)ois);
                return simpleMetricStore;
            }
            return null;
        }
    }
}

