/*
 * Decompiled with CFR 0.152.
 */
package act.route;

import act.route.Router;

public enum RouteSource {
    BUILD_IN("Built in service"){

        @Override
        Router.ConflictResolver onConflict(RouteSource existingRoute) {
            return Router.ConflictResolver.EXIT;
        }
    }
    ,
    ROUTE_TABLE("Route table"){

        @Override
        Router.ConflictResolver onConflict(RouteSource existingRoute) {
            switch (existingRoute) {
                case APP_CONFIG: 
                case BUILD_IN: {
                    return Router.ConflictResolver.EXIT;
                }
                case ACTION_ANNOTATION: {
                    return Router.ConflictResolver.OVERWRITE;
                }
            }
            return Router.ConflictResolver.OVERWRITE_WARN;
        }
    }
    ,
    ACTION_ANNOTATION("Action annotation"){

        @Override
        Router.ConflictResolver onConflict(RouteSource existingRoute) {
            switch (existingRoute) {
                case BUILD_IN: 
                case ACTION_ANNOTATION: {
                    return Router.ConflictResolver.EXIT;
                }
                case APP_CONFIG: 
                case ROUTE_TABLE: {
                    return Router.ConflictResolver.SKIP;
                }
            }
            return Router.ConflictResolver.OVERWRITE_WARN;
        }
    }
    ,
    APP_CONFIG("App configured"){

        @Override
        Router.ConflictResolver onConflict(RouteSource existingRoute) {
            switch (existingRoute) {
                case APP_CONFIG: 
                case BUILD_IN: {
                    return Router.ConflictResolver.EXIT;
                }
            }
            return Router.ConflictResolver.OVERWRITE_WARN;
        }
    }
    ,
    ADMIN_OVERWRITE("Admin overwrite"){

        @Override
        Router.ConflictResolver onConflict(RouteSource existingRoute) {
            return Router.ConflictResolver.OVERWRITE_WARN;
        }
    }
    ,
    ADMIN_ADD("Admin added"){

        @Override
        Router.ConflictResolver onConflict(RouteSource existingRoute) {
            return Router.ConflictResolver.EXIT;
        }
    };

    private String desc;

    private RouteSource(String desc) {
        this.desc = desc;
    }

    public String getDescription() {
        return this.desc;
    }

    abstract Router.ConflictResolver onConflict(RouteSource var1);
}

