/*
 * Decompiled with CFR 0.152.
 */
package act.route;

import act.Act;
import act.Destroyable;
import act.app.ActionContext;
import act.app.App;
import act.app.AppHolderBase;
import act.app.RouterRegexMacroLookup;
import act.cli.tree.TreeNode;
import act.conf.AppConfig;
import act.controller.builtin.ThrottleFilter;
import act.handler.DelegateRequestHandler;
import act.handler.OptionsInfoBase;
import act.handler.RequestHandler;
import act.handler.RequestHandlerBase;
import act.handler.RequestHandlerResolver;
import act.handler.RequestHandlerResolverBase;
import act.handler.builtin.AlwaysBadRequest;
import act.handler.builtin.AlwaysNotFound;
import act.handler.builtin.AuthenticatedEcho;
import act.handler.builtin.AuthenticatedFileGetter;
import act.handler.builtin.AuthenticatedRedirect;
import act.handler.builtin.AuthenticatedRedirectDir;
import act.handler.builtin.AuthenticatedResourceGetter;
import act.handler.builtin.Echo;
import act.handler.builtin.FileGetter;
import act.handler.builtin.Redirect;
import act.handler.builtin.RedirectDir;
import act.handler.builtin.ResourceGetter;
import act.handler.builtin.UnknownHttpMethodHandler;
import act.handler.builtin.controller.RequestHandlerProxy;
import act.route.DuplicateRouteMappingException;
import act.route.RouteInfo;
import act.route.RouteSource;
import act.route.RoutingException;
import act.route.UrlPath;
import act.security.CORS;
import act.security.CSRF;
import act.util.ActContext;
import act.util.DestroyableBase;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.enterprise.context.ApplicationScoped;
import javax.validation.constraints.NotNull;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.http.H;
import org.osgl.http.util.Path;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.mvc.result.Result;
import org.osgl.util.C;
import org.osgl.util.Codec;
import org.osgl.util.E;
import org.osgl.util.FastStr;
import org.osgl.util.S;
import org.osgl.util.StrBase;
import org.osgl.util.Unsafe;

public class Router
extends AppHolderBase<Router> {
    public static final String IGNORE_NOTATION = "...";
    private static final H.Method[] targetMethods = new H.Method[]{H.Method.GET, H.Method.POST, H.Method.DELETE, H.Method.PUT, H.Method.PATCH};
    private static final Logger LOGGER = LogManager.get(Router.class);
    Node _GET;
    Node _PUT;
    Node _POST;
    Node _DEL;
    Node _PATCH;
    private Map<String, RequestHandlerResolver> resolvers = new HashMap<String, RequestHandlerResolver>();
    private RequestHandlerResolver handlerLookup;
    private Map<CharSequence, String> urlContexts = new HashMap<CharSequence, String>();
    private Set<String> actionNames = new HashSet<String>();
    private AppConfig appConfig;
    private String portId;
    private int port;
    private OptionsInfoBase optionHandlerFactory;
    private Set<RequestHandler> requireBodyParsing = new HashSet<RequestHandler>();
    public static final Lang.Func0<String> DEF_ACTION_PATH_PROVIDER = new Lang.Func0<String>(){

        public String apply() throws NotAppliedException, Lang.Break {
            ActContext.Base<?> context = ActContext.Base.currentContext();
            E.illegalStateIf((null == context ? 1 : 0) != 0, (String)"cannot use shortcut action path outside of a act context");
            return context.methodPath();
        }
    };
    private static final Method M_FULL_URL = $.getMethod(Router.class, (String)"fullUrl", (Class[])new Class[]{String.class, Object[].class});
    public final f f = new f();

    private void initControllerLookup(RequestHandlerResolver lookup) {
        if (null == lookup) {
            lookup = new RequestHandlerResolverBase(){

                @Override
                public RequestHandler resolve(CharSequence payload, App app) {
                    if (S.eq((String)"__ws_endpoint__", (String)payload.toString())) {
                        return Act.network().createWebSocketConnectionHandler();
                    }
                    return new RequestHandlerProxy(payload.toString(), app);
                }
            };
        }
        this.handlerLookup = lookup;
    }

    public Router(App app) {
        this(null, app, null);
    }

    public Router(App app, String portId) {
        this(null, app, portId);
    }

    public Router(RequestHandlerResolver handlerLookup, App app) {
        this(handlerLookup, app, null);
    }

    public Router(RequestHandlerResolver handlerLookup, App app, String portId) {
        super(app);
        this.initControllerLookup(handlerLookup);
        this.appConfig = app.config();
        this.portId = portId;
        this.port = S.notBlank((String)portId) ? this.appConfig.namedPort(portId).port() : (this.appConfig.httpSecure() ? this.appConfig.httpExternalSecurePort() : this.appConfig.httpExternalPort());
        this.optionHandlerFactory = new OptionsInfoBase(this);
        this._GET = Node.newRoot("GET", this.appConfig);
        this._PUT = Node.newRoot("PUT", this.appConfig);
        this._POST = Node.newRoot("POST", this.appConfig);
        this._DEL = Node.newRoot("DELETE", this.appConfig);
        this._PATCH = Node.newRoot("PATCH", this.appConfig);
    }

    @Override
    protected void releaseResources() {
        this._GET.destroy();
        this._DEL.destroy();
        this._POST.destroy();
        this._PUT.destroy();
        this._PATCH.destroy();
        this.handlerLookup.destroy();
        this.actionNames.clear();
        this.appConfig = null;
    }

    public String portId() {
        return this.portId;
    }

    public int port() {
        return this.port;
    }

    public void accept(Visitor visitor) {
        this.visit(this._GET, H.Method.GET, visitor);
        this.visit(this._POST, H.Method.POST, visitor);
        this.visit(this._PUT, H.Method.PUT, visitor);
        this.visit(this._DEL, H.Method.DELETE, visitor);
        this.visit(this._PATCH, H.Method.PATCH, visitor);
    }

    private void visit(Node node, H.Method method, Visitor visitor) {
        RequestHandler handler = node.handler;
        if (null != handler) {
            if (handler instanceof ContextualHandler) {
                handler = ((ContextualHandler)handler).realHandler();
            }
            visitor.visit(method, node.path(), handler);
        }
        for (Node child : node.dynamicChilds) {
            this.visit(child, method, visitor);
        }
        for (Node child : node.staticChildren.values()) {
            this.visit(child, method, visitor);
        }
    }

    public void markRequireBodyParsing(RequestHandler handler) {
        this.requireBodyParsing.add(handler);
    }

    public RequestHandler getInvoker(H.Method method, CharSequence path, ActionContext context) {
        context.router(this);
        if (method == H.Method.OPTIONS) {
            return this.optionHandlerFactory.optionHandler(path, context);
        }
        if (Arrays.binarySearch(targetMethods, method) < 0) {
            return UnknownHttpMethodHandler.INSTANCE;
        }
        Node node = this.search(method, Path.tokenizer((char[])Unsafe.bufOf((CharSequence)path)), context);
        RequestHandler handler = this.getInvokerFrom(node);
        RequestHandler blockIssueHandler = this.app().blockIssueHandler();
        if (null == blockIssueHandler) {
            return handler;
        }
        if (handler instanceof FileGetter || handler instanceof ResourceGetter) {
            return handler;
        }
        return blockIssueHandler;
    }

    public RequestHandler findStaticGetHandler(String url) {
        Iterator path = Path.tokenizer((char[])Unsafe.bufOf((String)url));
        Node node = this.root(H.Method.GET);
        while (null != node && path.hasNext()) {
            CharSequence nodeName = (CharSequence)path.next();
            if (null != (node = (Node)node.staticChildren.get(nodeName)) && !node.terminateRouteSearch()) continue;
            break;
        }
        return null == node ? null : node.handler;
    }

    private RequestHandler getInvokerFrom(Node node) {
        if (null == node) {
            return Router.notFound();
        }
        RequestHandler handler = node.handler;
        if (null == handler) {
            for (Node targetNode : node.dynamicChilds) {
                if (Node.MATCH_ALL != targetNode.patternTrait && !targetNode.pattern.matcher("").matches()) continue;
                return this.getInvokerFrom(targetNode);
            }
            return Router.notFound();
        }
        return handler;
    }

    public void addContext(String actionContext, String urlContext) {
        this.urlContexts.put(actionContext, urlContext);
    }

    private CharSequence withUrlContext(CharSequence path, CharSequence action) {
        String sAction = action.toString();
        String urlContext = null;
        for (CharSequence key : this.urlContexts.keySet()) {
            String sKey = key.toString();
            if (!sAction.startsWith(sKey)) continue;
            urlContext = this.urlContexts.get(key);
            break;
        }
        return null == urlContext ? path : S.pathConcat(urlContext, (char)'/', (String)path.toString());
    }

    public void addMapping(H.Method method, CharSequence path, CharSequence action) {
        this.addMapping(method, this.withUrlContext(path, action), this.resolveActionHandler(action), RouteSource.ROUTE_TABLE);
    }

    public void addMapping(H.Method method, CharSequence path, CharSequence action, RouteSource source) {
        this.addMapping(method, this.withUrlContext(path, action), this.resolveActionHandler(action), source);
    }

    public void addMapping(H.Method method, CharSequence path, RequestHandler handler) {
        this.addMapping(method, path, handler, RouteSource.ROUTE_TABLE);
    }

    public void addMapping(H.Method method, CharSequence path, RequestHandler handler, RouteSource source) {
        Set<Node> conflicts;
        String sPath;
        if (this.isTraceEnabled()) {
            this.trace("R+ %s %s | %s (%s)", new Object[]{method, path, handler, source});
        }
        if (!(this.app().config().builtInReqHandlerEnabled() || !(sPath = path.toString()).startsWith("/~/") || sPath.contains("asset") || sPath.contains("i18n") || sPath.contains("job") || sPath.contains("api") || sPath.contains("ticket"))) {
            return;
        }
        Node node = this._locate(method, path, handler.toString());
        if (null == node.handler && !(conflicts = node.conflicts()).isEmpty()) {
            for (Node conflict : conflicts) {
                if (null == conflict.handler) continue;
                node = conflict;
                break;
            }
        }
        if (null == node.handler) {
            handler = this.prepareReverseRoutes(handler, node);
            node.handler(handler, source);
        } else {
            RouteSource existing = node.routeSource();
            ConflictResolver resolving = source.onConflict(existing);
            switch (resolving) {
                case OVERWRITE_WARN: {
                    this.warn("\n\tOverwrite existing route \n\t\t%s\n\twith new route\n\t\t%s", Router.routeInfo(method, path, node.handler()), Router.routeInfo(method, path, handler));
                }
                case OVERWRITE: {
                    handler = this.prepareReverseRoutes(handler, node);
                    node.handler(handler, source);
                }
                case SKIP: {
                    break;
                }
                case EXIT: {
                    throw new DuplicateRouteMappingException(new RouteInfo(method, path.toString(), node.handler(), existing), new RouteInfo(method, path.toString(), handler, source));
                }
                default: {
                    throw E.unsupport();
                }
            }
        }
    }

    private RequestHandler prepareReverseRoutes(RequestHandler handler, Node node) {
        if (handler instanceof RequestHandlerInfo) {
            RequestHandlerInfo info = (RequestHandlerInfo)handler;
            CharSequence action = info.action;
            Node root = node.root;
            root.reverseRoutes.put(action.toString(), node);
            handler = info.theHandler();
        }
        return handler;
    }

    public String reverseRoute(String action, boolean fullUrl) {
        return this.reverseRoute(action, new HashMap<String, Object>(), fullUrl);
    }

    public String reverseRoute(String action) {
        return this.reverseRoute(action, new HashMap<String, Object>());
    }

    public String reverseRoute(String action, Map<String, Object> args) {
        String fullAction = Router.inferFullActionPath(action);
        for (H.Method m : Router.supportedHttpMethods()) {
            String url = this.reverseRoute(fullAction, m, args);
            if (null == url) continue;
            return this.ensureUrlContext(url);
        }
        return null;
    }

    public static String inferFullActionPath(String actionPath) {
        return Router.inferFullActionPath(actionPath, DEF_ACTION_PATH_PROVIDER);
    }

    public static String inferFullActionPath(String actionPath, Lang.Func0<String> currentActionPathProvider) {
        String handler;
        String controller = null;
        if (actionPath.contains("/")) {
            return actionPath;
        }
        int pos = actionPath.indexOf(".");
        if (pos < 0) {
            handler = actionPath;
        } else {
            controller = actionPath.substring(0, pos);
            handler = actionPath.substring(pos + 1, actionPath.length());
            if (handler.indexOf(".") > 0) {
                return actionPath;
            }
        }
        String currentPath = (String)currentActionPathProvider.apply();
        if (null == currentPath) {
            return actionPath;
        }
        pos = currentPath.lastIndexOf(".");
        String currentPathWithoutHandler = currentPath.substring(0, pos);
        if (null == controller) {
            return S.concat((String)currentPathWithoutHandler, (String)".", (String)handler);
        }
        pos = currentPathWithoutHandler.lastIndexOf(".");
        String currentPathWithoutController = currentPathWithoutHandler.substring(0, pos);
        return S.concat((String)currentPathWithoutController, (String)".", (String)controller, (String)".", (String)handler);
    }

    public String reverseRoute(String action, Map<String, Object> args, boolean fullUrl) {
        String path = this.reverseRoute(action, args);
        if (null == path) {
            return null;
        }
        return fullUrl ? this.fullUrl(path, new Object[0]) : path;
    }

    public String reverseRoute(String action, H.Method method, Map<String, Object> args) {
        Node root = this.root(method);
        Node node = (Node)root.reverseRoutes.get(action);
        if (null == node) {
            return null;
        }
        C.List elements = C.newList();
        args = new HashMap<String, Object>(args);
        while (root != node) {
            if (node.isDynamic()) {
                Node targetNode = node;
                for (Map.Entry entry : node.dynamicReverseAliases.entrySet()) {
                    if (!((String)entry.getKey()).equals(action)) continue;
                    targetNode = (Node)entry.getValue();
                    break;
                }
                S.Buffer buffer = S.buffer();
                for (Lang.Transformer builder : targetNode.nodeValueBuilders) {
                    String s = (String)builder.transform(args);
                    buffer.append(s);
                }
                String s = buffer.toString();
                if (S.blank((String)s)) {
                    s = S.string((Object)args.remove(S.string(targetNode.varNames.get(0))));
                }
                if (S.blank((String)s)) {
                    s = S.string((Object)"-");
                }
                elements.add((Object)s);
            } else {
                elements.add((Object)node.name.toString());
            }
            node = node.parent;
        }
        S.Buffer sb = S.newBuffer();
        Iterator itr = elements.reverseIterator();
        while (itr.hasNext()) {
            sb.append("/").append((String)itr.next());
        }
        if (method == H.Method.GET && !args.isEmpty()) {
            boolean first = true;
            for (Map.Entry<String, Object> entry : args.entrySet()) {
                Object v = entry.getValue();
                if (null == v) continue;
                String k = entry.getKey();
                if (first) {
                    sb.append("?");
                    first = false;
                } else {
                    sb.append("&");
                }
                sb.append(k).append("=").append(Codec.encodeUrl((String)v.toString()));
            }
        }
        return sb.toString();
    }

    public String urlBase() {
        ActionContext context = ActionContext.current();
        if (null != context) {
            return this.urlBase(context);
        }
        AppConfig config = Act.appConfig();
        boolean secure = null != this.portId && config.httpSecure();
        String scheme = secure ? "https" : "http";
        String domain = config.host();
        if (80 == this.port || 443 == this.port) {
            return S.concat((String)scheme, (String)"://", (String)domain);
        }
        return S.concat((String)scheme, (String)"://", (String)domain, (String)":", (String)S.string((int)this.port));
    }

    public String urlBase(ActionContext context) {
        H.Request req = context.req();
        String scheme = req.secure() ? "https" : "http";
        int port = req.port();
        String domain = req.domain();
        if (80 == port || 443 == port) {
            return S.fmt((String)"%s://%s", (Object[])new Object[]{scheme, domain});
        }
        return S.fmt((String)"%s://%s:%s", (Object[])new Object[]{scheme, domain, port});
    }

    private String ensureUrlContext(String path) {
        String urlContext = this.appConfig.urlContext();
        if (null == urlContext || path.startsWith(urlContext)) {
            if ("/".equals(path)) {
                path = "";
            }
            return path;
        }
        if (!path.startsWith("/") && (path = S.concat((String)"/", (String)path)).startsWith(urlContext)) {
            return path;
        }
        if ("/".equals(path)) {
            path = "";
        }
        return S.concat((String)urlContext, (String)path);
    }

    public String fullUrl(String path, Object ... args) {
        if ((path = S.fmt((String)path, (Object[])args)).startsWith("//") || path.startsWith("http")) {
            return path;
        }
        if (path.contains(".") || path.contains("(")) {
            path = this.reverseRoute(path);
        }
        S.Buffer sb = S.newBuffer((String)this.urlBase());
        path = this.ensureUrlContext(path);
        return sb.append(S.fmt((String)path, (Object[])args)).toString();
    }

    public String fullUrl(String action, Map<String, Object> renderArgs) {
        return this.fullUrl(this.reverseRoute(action, renderArgs), new Object[0]);
    }

    public String _fullUrl(String path, Object[] args) {
        return (String)$.invokeVirtual((Object)this, (Method)M_FULL_URL, (Object[])new Object[]{path, args});
    }

    boolean isMapped(H.Method method, CharSequence path) {
        return null != this._search(method, path);
    }

    private static String routeInfo(H.Method method, CharSequence path, Object handler) {
        return S.fmt((String)"[%s %s] - > [%s]", (Object[])new Object[]{method, path, handler});
    }

    private Node _search(H.Method method, CharSequence path) {
        Node node = this.root(method);
        assert (node != null);
        E.unsupportedIf((null == node ? 1 : 0) != 0, (String)"Method %s is not supported", (Object[])new Object[]{method});
        if (path.length() == 1 && path.charAt(0) == '/') {
            return node;
        }
        String sUrl = path.toString();
        List paths = Path.tokenize((char[])Unsafe.bufOf((String)sUrl));
        int len = paths.size();
        for (int i = 0; i < len - 1; ++i) {
            if (null != (node = node.findChild((StrBase)paths.get(i)))) continue;
            return null;
        }
        return node.findChild((StrBase)paths.get(len - 1));
    }

    private Node _locate(H.Method method, CharSequence path, String action) {
        Node node = this.root(method);
        E.unsupportedIf((null == node ? 1 : 0) != 0, (String)"Method %s is not supported", (Object[])new Object[]{method});
        assert (null != node);
        int pathLen = path.length();
        if (0 == pathLen || 1 == pathLen && path.charAt(0) == '/') {
            return node;
        }
        String sUrl = path.toString();
        List paths = Path.tokenize((char[])Unsafe.bufOf((String)sUrl));
        int len = paths.size();
        for (int i = 0; i < len - 1; ++i) {
            CharSequence part = (CharSequence)paths.get(i);
            if (this.checkIgnoreRestParts(node, part)) {
                return node;
            }
            node = node.addChild((StrBase)part, path, action);
        }
        CharSequence part = (CharSequence)paths.get(len - 1);
        if (this.checkIgnoreRestParts(node, part)) {
            return node;
        }
        return node.addChild((StrBase)part, path, action);
    }

    private boolean checkIgnoreRestParts(Node node, CharSequence nextPart) {
        boolean shouldIgnoreRests = S.eq((String)IGNORE_NOTATION, (String)S.string((Object)nextPart));
        E.invalidConfigurationIf((node.ignoreRestParts() && !shouldIgnoreRests ? 1 : 0) != 0, (String)"Bad route configuration: parts appended to route that ends with \"...\"", (Object[])new Object[0]);
        E.invalidConfigurationIf((shouldIgnoreRests && !node.children().isEmpty() ? 1 : 0) != 0, (String)"Bad route configuration: \"...\" appended to node that has children", (Object[])new Object[0]);
        node.ignoreRestParts(shouldIgnoreRests);
        return shouldIgnoreRests;
    }

    public void registerRequestHandlerResolver(String directive, RequestHandlerResolver resolver) {
        this.resolvers.put(directive, resolver);
    }

    public boolean isActionMethod(String className, String methodName) {
        return this.actionNames.contains(S.concat((String)className, (String)".", (String)methodName));
    }

    public boolean possibleController(String className) {
        return Router.setContains(this.actionNames, className);
    }

    private static boolean setContains(Set<String> set, String name) {
        for (String s : set) {
            if (!s.contains(name)) continue;
            return true;
        }
        return false;
    }

    public void debug(PrintStream ps) {
        for (H.Method method : Router.supportedHttpMethods()) {
            Node node = this.root(method);
            node.debug(method, ps);
        }
    }

    public List<RouteInfo> debug() {
        ArrayList<RouteInfo> info = new ArrayList<RouteInfo>();
        this.debug(info);
        return C.list(info).sorted();
    }

    public void debug(List<RouteInfo> routes) {
        for (H.Method method : Router.supportedHttpMethods()) {
            Node node = this.root(method);
            node.debug(method, routes);
        }
    }

    public static H.Method[] supportedHttpMethods() {
        return targetMethods;
    }

    private Node search(H.Method method, Iterator<CharSequence> path, ActionContext context) {
        Node node = this.root(method);
        if (node.terminateRouteSearch() && !context.urlPath().isBuiltIn()) {
            S.Buffer sb = S.newBuffer();
            while (path.hasNext()) {
                sb.append('/').append(path.next());
            }
            context.param("__path", sb.toString());
            return node;
        }
        while (null != node && path.hasNext()) {
            CharSequence nodeName = path.next();
            if (null == (node = node.child(nodeName, context))) continue;
            if (node.terminateRouteSearch()) {
                if (!path.hasNext()) {
                    context.param("__path", "");
                    break;
                }
                S.Buffer sb = S.newBuffer();
                while (path.hasNext()) {
                    sb.append('/').append(path.next());
                }
                context.param("__path", sb.toString());
                break;
            }
            if (!node.ignoreRestParts()) continue;
            S.Buffer sb = S.newBuffer();
            while (path.hasNext()) {
                sb.append('/').append(path.next());
            }
            context.param("__path", sb.toString());
            break;
        }
        return node;
    }

    private RequestHandlerInfo resolveActionHandler(CharSequence action) {
        Lang.T2<String, String> t2 = this.splitActionStr(action);
        String directive = (String)t2._1;
        String payload = (String)t2._2;
        if (S.empty((String)directive) && payload.contains("/")) {
            directive = "resource";
        }
        if (S.notEmpty((String)directive)) {
            RequestHandlerResolver resolver = this.resolvers.get(directive);
            RequestHandler handler = null == resolver ? BuiltInHandlerResolver.tryResolve(directive, payload, this.app()) : resolver.resolve(payload, this.app());
            E.unsupportedIf((null == handler ? 1 : 0) != 0, (String)"cannot find action handler by directive %s on payload %s", (Object[])new Object[]{directive, payload});
            return new RequestHandlerInfo(handler, action);
        }
        RequestHandler handler = this.handlerLookup.resolve(payload, this.app());
        E.unsupportedIf((null == handler ? 1 : 0) != 0, (String)"cannot find action handler: %s", (Object[])new Object[]{action});
        this.actionNames.add(payload);
        return new RequestHandlerInfo(handler, action);
    }

    private Lang.T2<String, String> splitActionStr(CharSequence action) {
        FastStr fs = FastStr.of((CharSequence)action);
        FastStr fs1 = fs.beforeFirst(':');
        FastStr fs2 = fs1.isEmpty() ? fs : (FastStr)fs.substr(fs1.length() + 1);
        return $.T2((Object)fs1.trim().toString(), (Object)fs2.trim().toString());
    }

    private Node root(H.Method method) {
        switch (method) {
            case GET: {
                return this._GET;
            }
            case POST: {
                return this._POST;
            }
            case PUT: {
                return this._PUT;
            }
            case DELETE: {
                return this._DEL;
            }
            case PATCH: {
                return this._PATCH;
            }
        }
        throw E.unexpected((String)"HTTP Method not supported: %s", (Object[])new Object[]{method});
    }

    private static AlwaysNotFound notFound() {
        return AlwaysNotFound.INSTANCE;
    }

    private static AlwaysBadRequest badRequest() {
        return AlwaysBadRequest.INSTANCE;
    }

    private static class ContextualHandler
    extends DelegateRequestHandler {
        protected ContextualHandler(RequestHandlerBase next) {
            super(next);
        }

        @Override
        public void handle(ActionContext context) {
            context.handler(this.realHandler());
            context.resolve();
            Router router = context.router();
            if (router.requireBodyParsing.contains(this.handler_)) {
                context.markRequireBodyParsing();
            }
            context.proceedWithHandler(this.handler_);
        }
    }

    private static enum BuiltInHandlerResolver {
        echo{

            @Override
            public RequestHandler resolve(CharSequence msg, App app, EnumSet<BuiltInHandlerDecorator> decorators) {
                return decorators.contains((Object)BuiltInHandlerDecorator.authenticated) ? new ContextualHandler(new AuthenticatedEcho(msg.toString())) : new Echo(msg.toString());
            }
        }
        ,
        redirect{

            @Override
            public RequestHandler resolve(CharSequence payload, App app, EnumSet<BuiltInHandlerDecorator> decorators) {
                return decorators.contains((Object)BuiltInHandlerDecorator.authenticated) ? new ContextualHandler(new AuthenticatedRedirect(payload.toString())) : new Redirect(payload.toString());
            }
        }
        ,
        moved{

            @Override
            public RequestHandler resolve(CharSequence payload, App app, EnumSet<BuiltInHandlerDecorator> decorators) {
                return decorators.contains((Object)BuiltInHandlerDecorator.authenticated) ? new ContextualHandler(new AuthenticatedRedirect(payload.toString())) : new Redirect(payload.toString());
            }
        }
        ,
        redirectdir{

            @Override
            public RequestHandler resolve(CharSequence payload, App app, EnumSet<BuiltInHandlerDecorator> decorators) {
                return decorators.contains((Object)BuiltInHandlerDecorator.authenticated) ? new ContextualHandler(new AuthenticatedRedirectDir(payload.toString())) : new RedirectDir(payload.toString());
            }
        }
        ,
        file{

            @Override
            public RequestHandler resolve(CharSequence base, App app, EnumSet<BuiltInHandlerDecorator> decorators) {
                File file;
                File file2 = file = decorators.contains((Object)BuiltInHandlerDecorator.external) ? new File(base.toString()) : app.file(base.toString());
                if (!file.canRead()) {
                    LOGGER.warn("file not found: %s", new Object[]{file.getPath()});
                }
                return decorators.contains((Object)BuiltInHandlerDecorator.authenticated) ? new ContextualHandler(new AuthenticatedFileGetter(file)) : new FileGetter(file);
            }
        }
        ,
        authenticatedfile{

            @Override
            public RequestHandler resolve(CharSequence base, App app, EnumSet<BuiltInHandlerDecorator> decorators) {
                return new ContextualHandler(new AuthenticatedFileGetter(app.file(base.toString())));
            }
        }
        ,
        externalfile{

            @Override
            public RequestHandler resolve(CharSequence base, App app, EnumSet<BuiltInHandlerDecorator> decorators) {
                File file = new File(base.toString());
                if (!file.canRead()) {
                    LOGGER.warn("External file not found: %s", new Object[]{file.getPath()});
                }
                return decorators.contains((Object)BuiltInHandlerDecorator.authenticated) ? new ContextualHandler(new AuthenticatedFileGetter(file)) : new FileGetter(file);
            }
        }
        ,
        resource{

            @Override
            public RequestHandler resolve(CharSequence payload, App app, EnumSet<BuiltInHandlerDecorator> decorators) {
                return decorators.contains((Object)BuiltInHandlerDecorator.authenticated) ? new ContextualHandler(new AuthenticatedResourceGetter(payload.toString())) : new ResourceGetter(payload.toString());
            }
        };


        protected abstract RequestHandler resolve(CharSequence var1, App var2, EnumSet<BuiltInHandlerDecorator> var3);

        private static RequestHandler tryResolve(CharSequence directive, CharSequence payload, App app) {
            String s;
            String resolver = s = directive.toString().toLowerCase();
            EnumSet<BuiltInHandlerDecorator> decorators = EnumSet.noneOf(BuiltInHandlerDecorator.class);
            int pos = s.indexOf(91);
            if (pos > -1) {
                String sDecorators;
                if (pos > 0) {
                    resolver = s.substring(0, pos);
                    E.illegalArgumentIf((']' != s.charAt(s.length() - 1) ? 1 : 0) != 0, (String)"Invalid directive: %s", (Object[])new Object[]{s});
                    sDecorators = s.substring(pos + 1, s.length() - 1);
                } else {
                    int pos2 = s.indexOf(93);
                    resolver = s.substring(pos2 + 1, s.length());
                    sDecorators = s.substring(1, pos2);
                }
                for (String dec : sDecorators.split("[,;:\\s]+")) {
                    BuiltInHandlerDecorator decorator = BuiltInHandlerDecorator.valueOf(dec);
                    decorators.add(decorator);
                }
            }
            BuiltInHandlerResolver r = BuiltInHandlerResolver.valueOf(resolver);
            try {
                final RequestHandler h = r.resolve(payload, app, decorators);
                if (decorators.contains((Object)BuiltInHandlerDecorator.throttled)) {
                    AppConfig<?> config = app.config();
                    final ThrottleFilter throttleFilter = new ThrottleFilter(config.requestThrottle(), config.requestThrottleExpireScale());
                    return new RequestHandlerBase(){

                        @Override
                        public void handle(ActionContext context) {
                            Result r = throttleFilter.handle(context);
                            if (null == r) {
                                h.handle(context);
                            } else {
                                r.apply(context.req(), context.resp());
                            }
                        }

                        @Override
                        public String toString() {
                            return h.toString();
                        }

                        @Override
                        public void prepareAuthentication(ActionContext context) {
                            h.prepareAuthentication(context);
                        }

                        @Override
                        public boolean express(ActionContext context) {
                            return h.express(context);
                        }

                        @Override
                        public boolean sessionFree() {
                            return h.sessionFree();
                        }

                        @Override
                        public CORS.Spec corsSpec() {
                            return h.corsSpec();
                        }

                        @Override
                        public CSRF.Spec csrfSpec() {
                            return h.csrfSpec();
                        }

                        @Override
                        public String contentSecurityPolicy() {
                            return h.contentSecurityPolicy();
                        }

                        @Override
                        public boolean disableContentSecurityPolicy() {
                            return h.disableContentSecurityPolicy();
                        }
                    };
                }
                return h;
            }
            catch (RuntimeException e) {
                LOGGER.warn((Throwable)e, "cannot resolve directive %s on payload: %s", new Object[]{directive, payload});
                return null;
            }
        }
    }

    private static enum BuiltInHandlerDecorator {
        authenticated,
        external,
        throttled;

    }

    private static class Node
    extends DestroyableBase
    implements Serializable,
    TreeNode,
    Comparable<Node> {
        private static final Node BADREQUEST = new Node(Integer.MIN_VALUE, Act.appConfig()){

            @Override
            boolean terminateRouteSearch() {
                return true;
            }
        };
        static String MATCH_ALL;
        private int id;
        private boolean isDynamic;
        private StrBase name;
        private boolean ignoreRestParts;
        private Pattern pattern;
        private String patternTrait;
        private List<CharSequence> varNames = new ArrayList<CharSequence>();
        private List<Lang.Transformer<Map<String, Object>, String>> nodeValueBuilders = new ArrayList<Lang.Transformer<Map<String, Object>, String>>();
        private Node root;
        private Node parent;
        private transient Node conflictNode;
        private List<Node> dynamicChilds = new ArrayList<Node>();
        private Map<CharSequence, Node> staticChildren = new HashMap<CharSequence, Node>();
        private Map<UrlPath, Node> dynamicAliases = new HashMap<UrlPath, Node>();
        private Map<String, Node> dynamicReverseAliases = new HashMap<String, Node>();
        private RequestHandler handler;
        private RouteSource routeSource;
        private RouterRegexMacroLookup macroLookup;
        private Map<String, Node> reverseRoutes = new HashMap<String, Node>();

        static Node newRoot(String name, AppConfig<?> config) {
            Node node = new Node(-1, config);
            node.name = S.str((Object)name);
            return node;
        }

        private Node(int id, AppConfig config) {
            this.id = id;
            this.macroLookup = config.routerRegexMacroLookup();
            this.name = FastStr.EMPTY_STR;
            this.root = this;
        }

        Node(StrBase name, Node parent) {
            E.NPE((Object)name);
            this.name = name;
            this.parent = parent;
            this.id = name.hashCode();
            this.root = parent.root;
            this.macroLookup = parent.macroLookup;
            this.parseDynaName(name);
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Node) {
                Node that = (Node)obj;
                return that.id == this.id && that.name.equals((Object)this.name);
            }
            return false;
        }

        @Override
        public int compareTo(Node o) {
            boolean hisIsFullVar;
            int hisVars;
            if (!o.isDynamic && !this.isDynamic) {
                return this.name.compareTo((CharSequence)o.name);
            }
            int myVars = this.varNames.size();
            if (myVars != (hisVars = o.varNames.size())) {
                return -(myVars - hisVars);
            }
            boolean fullVar = "(.*)".equals(this.patternTrait);
            if (fullVar == (hisIsFullVar = "(.*)".equals(o.patternTrait))) {
                return this.name.compareTo((CharSequence)o.name);
            }
            return fullVar ? 1 : -1;
        }

        public boolean ignoreRestParts() {
            return this.ignoreRestParts;
        }

        public void ignoreRestParts(boolean ignore) {
            this.ignoreRestParts = ignore;
        }

        public boolean isDynamic() {
            return this.isDynamic;
        }

        public Set<Node> conflicts() {
            HashSet<Node> nodes = new HashSet<Node>();
            this.findOutConflictNodes(nodes);
            return nodes;
        }

        private void findOutConflictNodes(Set<Node> nodes) {
            if (null != this.conflictNode) {
                nodes.add(this.conflictNode);
            }
            if (this.root == this || this.parent == null) {
                return;
            }
            HashSet<Node> parentConflictNodes = new HashSet<Node>();
            this.parent.findOutConflictNodes(parentConflictNodes);
            for (Node parentConflictNode : parentConflictNodes) {
                Node staticNode = parentConflictNode.staticChildren.get(this.name);
                if (null != staticNode) {
                    nodes.add(staticNode);
                    continue;
                }
                for (Node dynamicNode : parentConflictNode.dynamicChilds) {
                    if (!this.metaInfoConflict(dynamicNode.name)) continue;
                    nodes.add(dynamicNode);
                }
            }
        }

        boolean metaInfoMatchesExactly(StrBase string) {
            return this.isDynamic && $.eq((Object)string, (Object)this.name);
        }

        boolean metaInfoConflict(StrBase string) {
            Lang.Var patternTraitsVar = $.var();
            boolean isDynamic = this.parseDynaNameStyleA(string, null, null, (Lang.Var<String>)patternTraitsVar);
            isDynamic = isDynamic || this.parseDynaNameStyleB(string, null, null, (Lang.Var<String>)patternTraitsVar, null);
            return isDynamic && this.patternTrait.equals(patternTraitsVar.get());
        }

        public boolean matches(CharSequence chars) {
            if (!this.isDynamic()) {
                return this.name.contentEquals(chars);
            }
            return null == this.pattern || this.pattern.matcher(chars).matches();
        }

        @Override
        public List<TreeNode> children() {
            C.List list = C.list(this.staticChildren.values());
            return list.append(this.dynamicChilds);
        }

        public Node child(CharSequence name, ActionContext context) {
            Node node = this.staticChildren.get(name);
            if (null == node && !this.dynamicChilds.isEmpty()) {
                UrlPath path = context.urlPath();
                for (Node targetNode : this.dynamicChilds) {
                    for (Map.Entry<UrlPath, Node> entry : targetNode.dynamicAliases.entrySet()) {
                        if (!entry.getKey().equals(path)) continue;
                        targetNode = entry.getValue();
                        break;
                    }
                    if (MATCH_ALL == targetNode.patternTrait) {
                        context.urlPathParam(targetNode.varNames.get(0).toString(), name.toString());
                        return targetNode;
                    }
                    Pattern pattern = targetNode.pattern;
                    Matcher matcher = null == pattern ? null : pattern.matcher(name);
                    if (null == matcher || !matcher.matches()) continue;
                    if (!targetNode.nodeValueBuilders.isEmpty()) {
                        for (CharSequence varName : targetNode.varNames) {
                            String varNameStr = varName.toString();
                            try {
                                String varValue = matcher.group(varNameStr);
                                if (!S.notBlank((String)varValue)) continue;
                                context.urlPathParam(varNameStr, S.string((Object)varValue));
                            }
                            catch (IllegalArgumentException e) {
                                String escaped;
                                String varValue;
                                if (!e.getMessage().contains("No group with name") || !S.notBlank((String)(varValue = matcher.group(escaped = Node.escapeUnderscore(varNameStr).toString())))) continue;
                                context.urlPathParam(varNameStr, S.string((Object)varValue));
                            }
                        }
                    } else {
                        CharSequence varName = targetNode.varNames.get(0);
                        context.urlPathParam(varName.toString(), S.string((Object)name));
                    }
                    return targetNode;
                }
                return BADREQUEST;
            }
            return node;
        }

        @Override
        public String id() {
            return this.name.toString();
        }

        @Override
        public String label() {
            StringBuilder sb = S.newBuilder((Object)this.name);
            if (null != this.handler) {
                sb.append(" -> ").append(RouteInfo.compactHandler(this.handler.toString()));
            }
            return sb.toString();
        }

        @Override
        protected void releaseResources() {
            if (null != this.handler) {
                this.handler.destroy();
            }
            Destroyable.Util.destroyAll(this.dynamicChilds, ApplicationScoped.class);
            Destroyable.Util.destroyAll(this.staticChildren.values(), ApplicationScoped.class);
            this.staticChildren.clear();
        }

        Node childByMetaInfoExactMatching(StrBase s) {
            Node node = this.staticChildren.get(s);
            if (null == node && !this.dynamicChilds.isEmpty()) {
                for (Node targetNode : this.dynamicChilds) {
                    if (!targetNode.metaInfoMatchesExactly(s)) continue;
                    return targetNode;
                }
            }
            return node;
        }

        Node childByMetaInfoConflictMatching(StrBase s) {
            Node node = this.staticChildren.get(s);
            if (null == node && !this.dynamicChilds.isEmpty()) {
                for (Node targetNode : this.dynamicChilds) {
                    if (!targetNode.metaInfoConflict(s)) continue;
                    return targetNode;
                }
            }
            return node;
        }

        Node findChild(StrBase<?> name) {
            name = name.trim();
            return this.childByMetaInfoExactMatching(name);
        }

        Node addChild(StrBase<?> name, CharSequence path, String action) {
            Node node = this.childByMetaInfoExactMatching(name = name.trim());
            if (null != node) {
                return node;
            }
            Node conflictNode = this.childByMetaInfoConflictMatching(name);
            Node child = new Node(name, this);
            child.conflictNode = conflictNode;
            if (child.isDynamic()) {
                boolean isAlias = false;
                for (Node targetNode : this.dynamicChilds) {
                    if (!S.eq((String)targetNode.patternTrait, (String)child.patternTrait)) continue;
                    targetNode.dynamicAliases.put(UrlPath.of(path), child);
                    targetNode.dynamicReverseAliases.put(action, child);
                    isAlias = true;
                    break;
                }
                if (!isAlias) {
                    child.dynamicAliases.put(UrlPath.of(path), child);
                    child.dynamicReverseAliases.put(action, child);
                    this.dynamicChilds.add(child);
                }
                Collections.sort(this.dynamicChilds);
                return child;
            }
            this.staticChildren.put((CharSequence)name, child);
            return child;
        }

        Node handler(RequestHandler handler, RouteSource source) {
            this.routeSource = (RouteSource)((Object)$.requireNotNull((Object)((Object)source)));
            this.handler = handler.requireResolveContext() ? new ContextualHandler((RequestHandlerBase)handler) : handler;
            return this;
        }

        RequestHandler handler() {
            return this.handler;
        }

        RouteSource routeSource() {
            return this.routeSource;
        }

        boolean terminateRouteSearch() {
            return null != this.handler && this.handler.supportPartialPath();
        }

        String path() {
            if (null == this.parent) {
                return "/";
            }
            String pPath = this.parent.path();
            return S.pathConcat((String)pPath, (char)'/', (String)this.name.toString());
        }

        void debug(H.Method method, PrintStream ps) {
            if (null != this.handler) {
                ps.printf("%s %s %s\n", method, this.path(), this.handler);
            }
            for (Node node : this.staticChildren.values()) {
                node.debug(method, ps);
            }
            for (Node node : this.dynamicChilds) {
                node.debug(method, ps);
            }
        }

        void debug(H.Method method, List<RouteInfo> routes) {
            if (null != this.handler) {
                routes.add(new RouteInfo(method, this.path(), this.handler));
            }
            for (Node node : this.staticChildren.values()) {
                node.debug(method, routes);
            }
            for (Node node : this.dynamicChilds) {
                node.debug(method, routes);
            }
        }

        private void parseDynaName(StrBase name) {
            Lang.Var patternTraitsVar;
            Lang.Var patternVar = $.var();
            boolean isDynamic = this.parseDynaNameStyleA(name, this.varNames, (Lang.Var<Pattern>)patternVar, (Lang.Var<String>)(patternTraitsVar = $.var()));
            boolean bl = this.isDynamic = isDynamic || this.parseDynaNameStyleB(name, this.varNames, (Lang.Var<Pattern>)patternVar, (Lang.Var<String>)patternTraitsVar, this.nodeValueBuilders);
            if (!this.isDynamic) {
                return;
            }
            this.patternTrait = (String)patternTraitsVar.get();
            if (MATCH_ALL != this.patternTrait) {
                this.pattern = (Pattern)patternVar.get();
            }
        }

        boolean parseDynaNameStyleB(StrBase name, List<CharSequence> varNames, @NotNull Lang.Var<Pattern> pattern, @NotNull Lang.Var<String> patternTrait, List<Lang.Transformer<Map<String, Object>, String>> nodeValueBuilders) {
            StrBase literal;
            int pos = name.indexOf(123);
            if (pos < 0) {
                return false;
            }
            int len = name.length();
            int lastPos = 0;
            int leftPos = pos;
            S.Buffer patternTraitBuilder = S.buffer();
            S.Buffer patternStrBuilder = null == pattern ? null : S.buffer();
            while (leftPos >= 0 & leftPos < len) {
                int rightAngle;
                literal = name.substr(lastPos, leftPos);
                if (!literal.isEmpty()) {
                    patternTraitBuilder.append((CharSequence)literal);
                    if (null != pattern) {
                        patternStrBuilder.append((CharSequence)literal);
                    }
                    if (null != nodeValueBuilders) {
                        nodeValueBuilders.add(new Lang.Transformer<Map<String, Object>, String>(){

                            public String transform(Map<String, Object> stringObjectMap) {
                                return S.string((Object)literal);
                            }
                        });
                    }
                }
                if ((rightAngle = name.indexOf(62, leftPos)) < 0) {
                    if (name.indexOf(60, leftPos) < 0) {
                        rightAngle = leftPos;
                    } else {
                        throw new RoutingException("Invalid route: " + name, new Object[0]);
                    }
                }
                if ((pos = name.indexOf(125, rightAngle)) < 0) {
                    throw new RuntimeException("Invalid node: " + name);
                }
                Lang.T2<? extends CharSequence, Pattern> t2 = this.parseVarBlock(name, leftPos + 1, pos);
                final CharSequence varName = (CharSequence)t2._1;
                if (null != varNames) {
                    varNames.add(varName);
                }
                Pattern pattern1 = (Pattern)t2._2;
                String patternStr = ".*?";
                if (null != pattern1) {
                    patternStr = pattern1.pattern();
                }
                if (null != patternStrBuilder) {
                    patternStrBuilder.append("(?<").append(varName).append(">").append(patternStr).append(")");
                }
                patternTraitBuilder.append("(").append(patternStr).append(")");
                if (null != nodeValueBuilders) {
                    nodeValueBuilders.add(new Lang.Transformer<Map<String, Object>, String>(){

                        public String transform(Map<String, Object> stringObjectMap) {
                            String s = S.string((Object)varName);
                            s = S.notBlank((String)s) ? s : "-";
                            return S.string((Object)stringObjectMap.remove(s));
                        }
                    });
                }
                lastPos = pos + 1;
                leftPos = name.indexOf(123, lastPos);
            }
            literal = name.substr(lastPos, name.length());
            if (!literal.isEmpty()) {
                if (literal.charAt(literal.length() - 1) == '}') {
                    literal = literal.tail(-1);
                }
                if (!literal.isEmpty()) {
                    final StrBase finalLiteral = literal;
                    patternTraitBuilder.append((CharSequence)literal);
                    if (null != patternStrBuilder) {
                        patternStrBuilder.append((CharSequence)literal);
                    }
                    if (null != nodeValueBuilders) {
                        nodeValueBuilders.add(new Lang.Transformer<Map<String, Object>, String>(){

                            public String transform(Map<String, Object> stringObjectMap) {
                                return S.string((Object)finalLiteral);
                            }
                        });
                    }
                }
            }
            if (null != pattern) {
                String s = patternStrBuilder.toString();
                String expanded = this.macroLookup.expand(s);
                if (expanded != s) {
                    pattern.set((Object)Pattern.compile(s));
                } else {
                    try {
                        pattern.set((Object)Pattern.compile(s));
                    }
                    catch (PatternSyntaxException e) {
                        CharSequence escaped = Node.escapeUnderscore(s);
                        if (escaped == s) {
                            throw e;
                        }
                        pattern.set((Object)Pattern.compile(escaped.toString()));
                    }
                }
            }
            patternTrait.set((Object)patternTraitBuilder.toString().intern());
            return true;
        }

        private static CharSequence escapeUnderscore(CharSequence s) {
            boolean updated = false;
            S.Buffer buf = S.buffer((Object)s);
            int l = s.length();
            for (int i = 0; i < l; ++i) {
                if ('_' != s.charAt(i)) continue;
                buf.set(i, '7');
                updated = true;
            }
            return updated ? buf : s;
        }

        private Lang.T2<? extends CharSequence, Pattern> parseVarBlock(StrBase name, int blockStart, int blockEnd) {
            StrBase varName;
            Pattern pattern;
            int pos = name.indexOf(60, blockStart);
            if (pos < 0 || pos >= blockEnd) {
                return $.T2((Object)name.substr(blockStart, blockEnd), null);
            }
            if (pos == blockStart) {
                pos = name.indexOf(62, blockStart);
                if (pos >= blockEnd) {
                    throw new RoutingException("Invalid route: " + name, new Object[0]);
                }
                pattern = Pattern.compile(this.macroLookup.expand(name.substring(blockStart + 1, pos)));
                varName = name.substr(pos + 1, blockEnd);
            } else {
                if (name.charAt(blockEnd - 1) != '>') {
                    throw new RoutingException("Invalid route: " + name, new Object[0]);
                }
                pattern = Pattern.compile(this.macroLookup.expand(name.substring(pos + 1, blockEnd - 1)));
                varName = name.substr(blockStart, pos);
            }
            return $.T2((Object)varName, (Object)pattern);
        }

        boolean parseDynaNameStyleA(StrBase name, List<CharSequence> varNames, Lang.Var<Pattern> pattern, Lang.Var<String> patternTrait) {
            int pos = name.indexOf(58);
            if (pos < 0) {
                return false;
            }
            if (0 == pos) {
                if (null != varNames) {
                    varNames.add(name.substring(1));
                }
            } else {
                int len = name.length();
                if (pos == len - 1) {
                    if (null != varNames) {
                        varNames.add(name.substring(0, len - 2));
                    }
                } else {
                    if (null != varNames) {
                        varNames.add(name.substring(0, pos));
                    }
                    String patternStr = name.substring(pos + 1, name.length());
                    patternStr = this.macroLookup.expand(patternStr).intern();
                    if (null != pattern && MATCH_ALL != patternStr) {
                        pattern.set((Object)Pattern.compile(patternStr));
                    }
                    patternTrait.set((Object)patternStr);
                }
            }
            return true;
        }

        static {
            Node.BADREQUEST.handler = AlwaysBadRequest.INSTANCE;
            MATCH_ALL = "(.*?)";
        }
    }

    public final class f {
        public Lang.Predicate<String> IS_CONTROLLER = new Lang.Predicate<String>(){

            public boolean test(String s) {
                for (String action : Router.this.actionNames) {
                    if (!action.startsWith(s)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static class RequestHandlerInfo
    extends DelegateRequestHandler {
        private CharSequence action;

        protected RequestHandlerInfo(RequestHandler handler, CharSequence action) {
            super(handler);
            this.action = action;
        }

        RequestHandler theHandler() {
            return this.handler_;
        }

        @Override
        public String toString() {
            return this.action.toString();
        }
    }

    static enum ConflictResolver {
        OVERWRITE,
        OVERWRITE_WARN,
        SKIP,
        EXIT;

    }

    public static interface Visitor {
        public void visit(H.Method var1, String var2, RequestHandler var3);
    }
}

