/*
 * Decompiled with CFR 0.152.
 */
package act.session;

import act.conf.AppConfig;
import act.session.SessionMapper;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.osgl.http.H;
import org.osgl.util.S;

@Singleton
public class HeaderTokenSessionMapper
implements SessionMapper {
    public static final String DEF_HEADER_PREFIX = "X-Act-";
    public static final String DEF_PAYLOAD_PREFIX = "";
    private String sessionHeader;
    private String flashHeader;
    private String sessionPayloadPrefix;
    private boolean hasSessionPayloadPrefix;
    private SessionMapper.ExpirationMapper expirationMapper;

    @Inject
    public HeaderTokenSessionMapper(AppConfig config) {
        String prefix = config.sessionHeaderPrefix();
        String headerPrefix = S.blank((String)prefix) ? DEF_HEADER_PREFIX : prefix;
        this.sessionHeader = config.sessionHeader();
        if (null == this.sessionHeader) {
            this.sessionHeader = S.pathConcat((String)headerPrefix, (char)'-', (String)"Session");
        }
        this.flashHeader = S.pathConcat((String)headerPrefix, (char)'-', (String)"Flash");
        this.sessionPayloadPrefix = config.sessionHeaderPayloadPrefix();
        this.hasSessionPayloadPrefix = S.notBlank((String)this.sessionPayloadPrefix);
        this.expirationMapper = new SessionMapper.ExpirationMapper(config);
    }

    @Override
    public void writeExpiration(long expiration, H.Response response) {
        this.expirationMapper.writeExpiration(expiration, response);
    }

    @Override
    public void write(String session, String flash, H.Response response) {
        if (null != session && this.hasSessionPayloadPrefix) {
            session = S.concat((String)this.sessionPayloadPrefix, (String)session);
        }
        if (null != session) {
            response.header(this.sessionHeader, session);
        }
        if (null != flash) {
            response.header(this.flashHeader, flash);
        }
    }

    @Override
    public String readSession(H.Request request) {
        String payload = request.header(this.sessionHeader);
        return this.hasSessionPayloadPrefix ? S.afterFirst((String)payload, (String)this.sessionPayloadPrefix) : payload;
    }

    @Override
    public String readFlash(H.Request request) {
        return request.header(this.flashHeader);
    }
}

