/*
 * Decompiled with CFR 0.152.
 */
package act.session;

import act.app.App;
import act.conf.AppConfig;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.osgl.util.E;
import org.osgl.util.S;

@Singleton
public class RotationSecretProvider {
    private String rawSecret;
    private String lastSecret;
    private String curSecret;
    private String nextSecret;
    private int periodInMinutes;
    private boolean rotateEnabled;
    private static final int[] VALID_MINUTES = new int[]{1, 2, 3, 4, 5, 6, 10, 12, 15, 20, 30, 60};
    private static final int[] VALID_HOURS = new int[]{1, 2, 3, 4, 6, 8, 12, 24};

    @Inject
    public RotationSecretProvider(App app) {
        AppConfig<?> config = app.config();
        this.rawSecret = config.secret();
        this.rotateEnabled = config.rotateSecret();
        if (this.rotateEnabled) {
            int period = config.secretRotatePeriod();
            app.jobManager().every("secret-rotator", new Runnable(){

                @Override
                public void run() {
                    RotationSecretProvider.this.rotateSecret();
                }
            }, period, TimeUnit.MINUTES);
            this.periodInMinutes = period;
            this.rotateSecret();
        }
    }

    public boolean isRotateEnabled() {
        return this.rotateEnabled;
    }

    public String rawSecret() {
        return this.rawSecret;
    }

    public String curSecret() {
        this.ensureRotateEnabled();
        return this.curSecret;
    }

    public String lastSecret() {
        this.ensureRotateEnabled();
        return this.lastSecret;
    }

    public String nextSecret() {
        this.ensureRotateEnabled();
        return this.nextSecret;
    }

    public static int roundToPeriod(int minutes) {
        E.illegalArgumentIf((minutes <= 0 ? 1 : 0) != 0);
        if (minutes > 1440) {
            return 1440;
        }
        if (minutes > 60) {
            float f2 = (float)minutes / 60.0f;
            int hours = Math.round(f2);
            int pos = Arrays.binarySearch(VALID_HOURS, hours);
            return (pos >= 0 ? hours : VALID_HOURS[-(pos + 1)]) * 60;
        }
        if (minutes > 30) {
            int reminder = minutes % 30;
            return 0 == reminder ? minutes : minutes + (reminder < 15 ? -reminder : 30 - reminder);
        }
        int pos = Arrays.binarySearch(VALID_MINUTES, minutes);
        return pos >= 0 ? minutes : VALID_MINUTES[-(pos + 1)];
    }

    private void rotateSecret() {
        this.ensureRotateEnabled();
        this.lastSecret = this.curSecret;
        this.curSecret = null != this.nextSecret ? this.nextSecret : this.calculateCurrentSecret();
        this.nextSecret = this.calculateNextSecret();
        if (null == this.lastSecret) {
            this.lastSecret = this.curSecret;
        }
    }

    private String calculateCurrentSecret() {
        return this.rawSecret + this.extension(0);
    }

    private String calculateNextSecret() {
        return this.rawSecret + this.extension(1);
    }

    private String extension(int forwardStep) {
        long trait;
        if (this.periodInMinutes > 60) {
            int periodInHours = this.periodInMinutes / 60;
            int hoursOfDay = DateTime.now().hourOfDay().get();
            int period = hoursOfDay / periodInHours;
            trait = RotationSecretProvider.currentHourStart().getMillis() / 1000L / 60L;
            if (0 < period) {
                trait += (long)(period * 60);
            }
        } else {
            int minutesOfHour = DateTime.now().minuteOfHour().get();
            int period = minutesOfHour / this.periodInMinutes;
            trait = RotationSecretProvider.currentHourStart().getMillis() / 1000L / 60L;
            if (0 < period) {
                trait += (long)period;
            }
        }
        if (forwardStep > 0) {
            trait += (long)(forwardStep * this.periodInMinutes);
        }
        return S.string((long)trait);
    }

    private void ensureRotateEnabled() {
        E.illegalStateIfNot((boolean)this.rotateEnabled, (String)"secret rotate not enabled");
    }

    private static DateTime currentHourStart() {
        return DateTime.now().withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0);
    }
}

