/*
 * Decompiled with CFR 0.152.
 */
package act.session;

import act.app.ActionContext;
import act.conf.AppConfig;
import act.session.SessionCodec;
import act.session.SessionMapper;
import act.util.DestroyableBase;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.osgl.http.H;

@Singleton
public class SessionManager
extends DestroyableBase {
    private SessionCodec codec;
    private SessionMapper mapper;

    @Inject
    public SessionManager(AppConfig config) {
        this.codec = config.sessionCodec();
        this.mapper = config.sessionMapper();
    }

    public H.Session resolveSession(H.Request request, ActionContext context) {
        String encodedSession;
        context.encodedSessionToken = encodedSession = this.mapper.readSession(request);
        return null == encodedSession ? new H.Session() : this.codec.decodeSession(encodedSession, request);
    }

    public H.Flash resolveFlash(H.Request request) {
        String encodedFlash = this.mapper.readFlash(request);
        if (null != encodedFlash) {
            H.Flash flash = this.codec.decodeFlash(encodedFlash);
            flash.discard();
            return flash;
        }
        return new H.Flash();
    }

    public void dissolveState(H.Session session, H.Flash flash, H.Response response) {
        String encodedSession = this.codec.encodeSession(session);
        String encodedFlash = this.codec.encodeFlash(flash);
        long expiry = session.expiry();
        if (expiry > 0L) {
            this.mapper.writeExpiration(session.expiry(), response);
        }
        this.mapper.write(encodedSession, encodedFlash, response);
    }
}

