/*
 * Decompiled with CFR 0.152.
 */
package act.session;

import act.conf.AppConfig;
import java.util.Locale;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.osgl.http.H;

public interface SessionMapper {
    public void writeExpiration(long var1, H.Response var3);

    public void write(String var1, String var2, H.Response var3);

    public String readSession(H.Request var1);

    public String readFlash(H.Request var1);

    public static class ExpirationMapper {
        private static DateTimeFormatter format = DateTimeFormat.forPattern((String)"E, dd MMM Y HH:mm:ss").withLocale(Locale.ENGLISH);
        boolean enabled;
        String headerName;

        ExpirationMapper(AppConfig conf) {
            this.enabled = conf.sessionOutputExpiration();
            if (this.enabled) {
                this.headerName = conf.headerSessionExpiration();
            }
        }

        public void writeExpiration(long expiration, H.Response response) {
            if (!this.enabled) {
                return;
            }
            response.header(this.headerName, ExpirationMapper.expirationInIMF(expiration));
        }

        private static String expirationInIMF(long expirationInMillis) {
            LocalDateTime localDateTime = new LocalDateTime(expirationInMillis, DateTimeZone.UTC);
            return format.print((ReadablePartial)localDateTime) + " GMT";
        }
    }
}

