/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.app.App;
import act.data.JodaDateTimeCodec;
import act.data.JodaLocalDateCodec;
import act.data.JodaLocalDateTimeCodec;
import act.data.JodaLocalTimeCodec;
import act.util.DestroyableBase;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Period;

@Singleton
public class FastJsonJodaDateCodec
extends DestroyableBase
implements ObjectSerializer,
ObjectDeserializer {
    private JodaDateTimeCodec dateTimeCodec;
    private JodaLocalDateCodec localDateCodec;
    private JodaLocalTimeCodec localTimeCodec;
    private JodaLocalDateTimeCodec localDateTimeCodec;
    private App app;

    @Inject
    public FastJsonJodaDateCodec(App app) {
        this.app = app;
    }

    public FastJsonJodaDateCodec(JodaDateTimeCodec dateTimeCodec, JodaLocalDateCodec localDateCodec, JodaLocalTimeCodec localTimeCodec, JodaLocalDateTimeCodec localDateTimeCodec) {
        this.dateTimeCodec = dateTimeCodec;
        this.localDateCodec = localDateCodec;
        this.localTimeCodec = localTimeCodec;
        this.localDateTimeCodec = localDateTimeCodec;
    }

    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 4) {
            String text = lexer.stringVal();
            lexer.nextToken();
            if (type == DateTime.class) {
                DateTime dateTime = (DateTime)this.dateTimeCodec().parse(text);
                return (T)dateTime;
            }
            if (type == LocalDateTime.class) {
                LocalDateTime localDateTime = (LocalDateTime)this.localDateTimeCodec().parse(text);
                return (T)localDateTime;
            }
            if (type == LocalDate.class) {
                LocalDate localDate = (LocalDate)this.localDateCodec().parse(text);
                return (T)localDate;
            }
            if (type == LocalTime.class) {
                LocalTime localDate = LocalTime.parse((String)text);
                return (T)localDate;
            }
            if (type == Period.class) {
                Period period = Period.parse((String)text);
                return (T)period;
            }
            if (type == Duration.class) {
                Duration duration = Duration.parse((String)text);
                return (T)duration;
            }
            if (type == Instant.class) {
                Instant instant = Instant.parse((String)text);
                return (T)instant;
            }
        } else {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public int getFastMatchToken() {
        return 4;
    }

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            out.writeNull();
            return;
        }
        Class<?> cls = object.getClass();
        if (cls == DateTime.class) {
            out.writeString(this.dateTimeCodec().toString((DateTime)object));
            return;
        }
        if (cls == LocalDateTime.class) {
            out.writeString(this.localDateTimeCodec().toString((LocalDateTime)object));
            return;
        }
        if (cls == LocalDate.class) {
            out.writeString(this.localDateCodec().toString((LocalDate)object));
            return;
        }
        if (cls == LocalTime.class) {
            out.writeString(this.localTimeCodec().toString((LocalTime)object));
            return;
        }
        out.writeString(object.toString());
    }

    private JodaDateTimeCodec dateTimeCodec() {
        if (null == this.dateTimeCodec) {
            this.dateTimeCodec = this.app.getInstance(JodaDateTimeCodec.class);
        }
        return this.dateTimeCodec;
    }

    private JodaLocalDateTimeCodec localDateTimeCodec() {
        if (null == this.localDateTimeCodec) {
            this.localDateTimeCodec = this.app.getInstance(JodaLocalDateTimeCodec.class);
        }
        return this.localDateTimeCodec;
    }

    private JodaLocalDateCodec localDateCodec() {
        if (null == this.localDateCodec) {
            this.localDateCodec = this.app.getInstance(JodaLocalDateCodec.class);
        }
        return this.localDateCodec;
    }

    private JodaLocalTimeCodec localTimeCodec() {
        if (null == this.localTimeCodec) {
            this.localTimeCodec = this.app.getInstance(JodaLocalTimeCodec.class);
        }
        return this.localTimeCodec;
    }
}

