/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.util.LocalIpAddressUtil;
import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;
import org.osgl.$;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

public class IdGenerator {
    public static final LongEncoder SAFE_ENCODER = new SafeLongEncoder();
    public static final LongEncoder UNSAFE_ENCODER = new UnsafeLongEncoder();
    private final NodeIdProvider nodeIdProvider;
    private final StartIdProvider startIdProvider;
    private final SequenceProvider sequenceProvider;
    private LongEncoder longEncoder;

    public IdGenerator() {
        this(new NodeIdProvider.IpProvider(), new StartIdProvider.DefaultStartIdProvider(), new SequenceProvider.AtomicLongSeq(), SAFE_ENCODER);
    }

    public IdGenerator(boolean useUnsafeLongEncoder) {
        this(new NodeIdProvider.IpProvider(), new StartIdProvider.DefaultStartIdProvider(), new SequenceProvider.AtomicLongSeq(), useUnsafeLongEncoder ? UNSAFE_ENCODER : SAFE_ENCODER);
    }

    public IdGenerator(NodeIdProvider nodeIdProvider, StartIdProvider startIdProvider, SequenceProvider sequenceProvider, LongEncoder longEncoder) {
        this.nodeIdProvider = (NodeIdProvider)$.requireNotNull((Object)nodeIdProvider);
        this.startIdProvider = (StartIdProvider)$.requireNotNull((Object)startIdProvider);
        this.sequenceProvider = (SequenceProvider)$.requireNotNull((Object)sequenceProvider);
        this.longEncoder = (LongEncoder)$.requireNotNull((Object)longEncoder);
    }

    public IdGenerator(int effectiveIpBytes) {
        this.nodeIdProvider = new NodeIdProvider.IpProvider(effectiveIpBytes);
        this.startIdProvider = new StartIdProvider.DefaultStartIdProvider();
        this.sequenceProvider = new SequenceProvider.AtomicLongSeq();
        this.longEncoder = SAFE_ENCODER;
    }

    public IdGenerator(int effectiveIpBytes, String startIdFile) {
        this.nodeIdProvider = new NodeIdProvider.IpProvider(effectiveIpBytes);
        this.startIdProvider = new StartIdProvider.DefaultStartIdProvider(startIdFile);
        this.sequenceProvider = new SequenceProvider.AtomicLongSeq();
        this.longEncoder = SAFE_ENCODER;
    }

    public IdGenerator(String startIdFile) {
        this.nodeIdProvider = new NodeIdProvider.IpProvider();
        this.startIdProvider = new StartIdProvider.DefaultStartIdProvider(startIdFile);
        this.sequenceProvider = new SequenceProvider.AtomicLongSeq();
        this.longEncoder = SAFE_ENCODER;
    }

    public String genId() {
        S.Buffer sb = S.newBuffer();
        sb.a(this.longEncoder.longToStr(this.nodeIdProvider.nodeId())).a(this.longEncoder.longToStr(this.startIdProvider.startId())).a(this.longEncoder.longToStr(this.sequenceProvider.seqId()));
        return sb.toString();
    }

    public static class SafeLongEncoder
    extends LongEncoder.LongEncoderBase {
        private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '.', '-', '_', '~'};

        public SafeLongEncoder() {
            super(digits);
        }
    }

    public static class UnsafeLongEncoder
    extends LongEncoder.LongEncoderBase {
        private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '!', '$', '%', '&', '.', ',', ';', ':', '=', '?', '+', '-', '*', '/', '<', '>', '_', '~', '#', '^', '@', '|', '(', ')', '[', ']', '{', '}'};

        public UnsafeLongEncoder() {
            super(digits);
        }
    }

    public static interface LongEncoder {
        public String longToStr(long var1);

        public static abstract class LongEncoderBase
        implements LongEncoder {
            private final char[] digits;
            private final int MAX_RADIX;

            public LongEncoderBase(char[] digits) {
                this.digits = digits;
                this.MAX_RADIX = digits.length;
            }

            @Override
            public String longToStr(long l) {
                boolean negative;
                int radix = this.MAX_RADIX;
                char[] buf = new char[65];
                int charPos = 64;
                boolean bl = negative = l < 0L;
                if (!negative) {
                    l = -l;
                }
                while (l <= (long)(-radix)) {
                    buf[charPos--] = this.digits[(int)(-(l % (long)radix))];
                    l /= (long)radix;
                }
                buf[charPos] = this.digits[(int)(-l)];
                if (negative) {
                    buf[--charPos] = 45;
                }
                return new String(buf, charPos, 65 - charPos);
            }
        }
    }

    public static interface NodeIdProvider {
        public long nodeId();

        public static class IpProvider
        implements NodeIdProvider {
            private final EffectiveBytes effectiveBytes;
            private final long id;

            public IpProvider() {
                this(4);
            }

            public IpProvider(int effectBytes) {
                this.effectiveBytes = EffectiveBytes.valueOf(effectBytes);
                String ip = LocalIpAddressUtil.ip();
                String[] sa = ip.split("\\.");
                int n = this.effectiveBytes.value;
                long l = 0L;
                for (int i = 0; i < n; ++i) {
                    String b = sa[3 - i];
                    long factor = 1L;
                    for (int j = 0; j < i; ++j) {
                        factor *= 256L;
                    }
                    l += Long.valueOf(b) * factor;
                }
                this.id = l;
            }

            @Override
            public long nodeId() {
                return this.id;
            }

            private static enum EffectiveBytes {
                ONE(1),
                TWO(2),
                THREE(3),
                FOUR(4);

                private int value;

                private EffectiveBytes(int value) {
                    this.value = value;
                }

                public static EffectiveBytes valueOf(int n) {
                    switch (n) {
                        case 1: {
                            return ONE;
                        }
                        case 2: {
                            return TWO;
                        }
                        case 3: {
                            return THREE;
                        }
                        case 4: {
                            return FOUR;
                        }
                    }
                    throw E.unexpected((String)"Invalid EffectiveByte value: %s. Expected: 1 - 4", (Object[])new Object[]{n});
                }
            }
        }
    }

    public static interface SequenceProvider {
        public long seqId();

        public static class AtomicLongSeq
        implements SequenceProvider {
            private final AtomicLong seq = new AtomicLong(0L);

            @Override
            public long seqId() {
                return this.seq.incrementAndGet();
            }
        }
    }

    public static interface StartIdProvider {
        public long startId();

        public static class DefaultStartIdProvider
        implements StartIdProvider {
            private StartIdProvider delegate;

            public DefaultStartIdProvider() {
                this(".act.id-global");
            }

            public DefaultStartIdProvider(String path) {
                try {
                    this.delegate = new FileBasedStartCounter(path);
                    this.delegate.startId();
                }
                catch (Exception e) {
                    this.delegate = new Timestamp();
                }
            }

            @Override
            public long startId() {
                return this.delegate.startId();
            }
        }

        public static class FileBasedStartCounter
        implements StartIdProvider {
            private final long id;

            public FileBasedStartCounter() {
                this(".act.id-global");
            }

            public FileBasedStartCounter(String path) {
                File file = new File(path);
                if (file.exists()) {
                    String s = IO.readContentAsString((File)file);
                    long seq = Long.parseLong(s);
                    IO.writeContent((CharSequence)S.str((Object)(++seq)), (File)file);
                    this.id = seq;
                } else {
                    this.id = 0L;
                    IO.writeContent((CharSequence)Long.toString(this.id), (File)file);
                }
            }

            @Override
            public long startId() {
                return this.id;
            }
        }

        public static class Timestamp
        implements StartIdProvider {
            private final long id;

            public Timestamp() {
                long l;
                long origin = DateTime.parse((String)"2016-05-10").getMillis();
                this.id = l = ($.ms() - origin) / 1000L / 10L;
            }

            @Override
            public long startId() {
                return this.id;
            }
        }
    }
}

