/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.S;

public class LogSupport {
    public static final String DOUBLE_DASHED_LINE = S.times((char)'=', (int)80);
    public static final String DASHED_LINE = S.times((char)'-', (int)80);
    public static final String STAR_LINE = S.times((char)'*', (int)80);
    public static final String HASH_SYMBOL_LINE = S.times((char)'#', (int)80);
    public static final String TILD_LINE = S.times((char)'~', (int)80);
    protected final transient Logger logger;

    public LogSupport() {
        this(false);
    }

    protected LogSupport(boolean noLogger) {
        this.logger = noLogger ? null : LogManager.get(this.getClass());
    }

    protected void printDoubleDashedLine() {
        this.info(DOUBLE_DASHED_LINE, new Object[0]);
    }

    protected void printDashedLine() {
        this.info(DASHED_LINE, new Object[0]);
    }

    protected void printStarLine() {
        this.info(STAR_LINE, new Object[0]);
    }

    protected void printHashSimbolLine() {
        this.info(HASH_SYMBOL_LINE, new Object[0]);
    }

    protected void printTildLine() {
        this.info(TILD_LINE, new Object[0]);
    }

    protected void println() {
        this.info("", new Object[0]);
    }

    protected void printCenter(String format, Object ... args) {
        String text = S.fmt((String)format, (Object[])args);
        this.info(S.center((String)text, (int)80), new Object[0]);
    }

    protected void printCenterWithLead(String lead, String format, Object ... args) {
        String text = S.fmt((String)format, (Object[])args);
        int len = 80 - lead.length();
        this.info(S.concat((String)lead, (String)S.center((String)text, (int)len)), new Object[0]);
    }

    protected void trace(String format, Object ... args) {
        this.logger.trace(format, args);
    }

    protected boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    protected void trace(Throwable t, String format, Object ... args) {
        this.logger.trace(t, format, args);
    }

    protected boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    protected void debug(String format, Object ... args) {
        this.logger.debug(format, args);
    }

    protected void debug(Throwable t, String format, Object ... args) {
        this.logger.debug(t, format, args);
    }

    protected void info(String format, Object ... args) {
        this.logger.info(format, args);
    }

    protected void info(Throwable t, String format, Object ... args) {
        this.logger.info(t, format, args);
    }

    protected void warn(String format, Object ... args) {
        this.logger.warn(format, args);
    }

    protected void warn(Throwable t, String format, Object ... args) {
        this.logger.warn(t, format, args);
    }

    protected void error(String format, Object ... args) {
        this.logger.error(format, args);
    }

    protected void error(Throwable t, String format, Object ... args) {
        this.logger.error(t, format, args);
    }

    protected void fatal(String format, Object ... args) {
        this.logger.fatal(format, args);
    }

    public void fatal(Throwable t, String format, Object ... args) {
        this.logger.fatal(t, format, args);
    }
}

