/*
 * Decompiled with CFR 0.152.
 */
package act.validation;

import act.validation.Password;

public class PasswordSpec
implements Password.Validator {
    public static final int DEF_MIN_LEN = 3;
    public static final int DEF_MAX_LEN = Integer.MAX_VALUE;
    public static final String SPECIAL_CHARS = "`~!@#$%^&*()[]{}'?";
    public static final char SPEC_LOWERCASE = 'a';
    public static final char SPEC_UPPERCASE = 'A';
    public static final char SPEC_DIGIT = '0';
    public static final char SPEC_SPECIAL_CHAR = '#';
    public static final char SPEC_LENSPEC_START = '[';
    public static final char SPEC_LENSPEC_CLOSE = ']';
    public static final char SPEC_LENSPEC_SEP = ',';
    private static final int BIT_LOWERCASE = 4096;
    private static final int BIT_UPPERCASE = 8192;
    private static final int BIT_DIGIT = 12288;
    private static final int BIT_SPECIAL_CHAR = 16384;
    private int minLength = 3;
    private int maxLength = Integer.MAX_VALUE;
    private int trait;

    private PasswordSpec() {
    }

    private PasswordSpec(PasswordSpec copy) {
        this.trait = copy.trait;
        this.minLength = copy.minLength;
        this.maxLength = copy.maxLength;
    }

    public boolean lowercaseRequired() {
        return (this.trait & 0x1000) != 0;
    }

    public boolean upppercaseRequired() {
        return (this.trait & 0x2000) != 0;
    }

    public boolean digitRequired() {
        return (this.trait & 0x3000) != 0;
    }

    public boolean specialCharRequired() {
        return (this.trait & 0x4000) != 0;
    }

    public int minLength() {
        return this.minLength;
    }

    public int maxLength() {
        return this.maxLength;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.lowercaseRequired()) {
            sb.append('a');
        }
        if (this.upppercaseRequired()) {
            sb.append('A');
        }
        if (this.digitRequired()) {
            sb.append('0');
        }
        if (this.specialCharRequired()) {
            sb.append('#');
        }
        sb.append("[").append(this.minLength).append(",");
        if (this.maxLength != Integer.MAX_VALUE) {
            sb.append(this.maxLength);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean isValid(char[] password) {
        int len = password.length;
        if (len < this.minLength() || len > this.maxLength()) {
            return false;
        }
        int trait = this.trait;
        for (int i = len - 1; i >= 0; --i) {
            char c = password[i];
            if (PasswordSpec.isLowercase(c)) {
                trait &= 0xFFFFEFFF;
                continue;
            }
            if (PasswordSpec.isUppercase(c)) {
                trait &= 0xFFFFDFFF;
                continue;
            }
            if (PasswordSpec.isDigit(c)) {
                trait &= 0xFFFFCFFF;
                continue;
            }
            if (!PasswordSpec.isSpecialChar(c)) continue;
            trait &= 0xFFFFBFFF;
        }
        return 0 == trait;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PasswordSpec parse(String spec) {
        char[] ca = spec.toCharArray();
        int len = ca.length;
        PasswordSpec.illegalIf(0 == len, spec);
        Builder builder = new Builder();
        StringBuilder minBuf = new StringBuilder();
        StringBuilder maxBuf = new StringBuilder();
        boolean lenSpecStart = false;
        boolean minPart = false;
        block9: for (int i = 0; i < len; ++i) {
            char c = ca[i];
            switch (c) {
                case 'a': {
                    PasswordSpec.illegalIf(lenSpecStart, spec);
                    builder.requireLowercase();
                    continue block9;
                }
                case 'A': {
                    PasswordSpec.illegalIf(lenSpecStart, spec);
                    builder.requireUppercase();
                    continue block9;
                }
                case '#': {
                    PasswordSpec.illegalIf(lenSpecStart, spec);
                    builder.requireSpecialChar();
                    continue block9;
                }
                case '[': {
                    lenSpecStart = true;
                    minPart = true;
                    continue block9;
                }
                case ']': {
                    PasswordSpec.illegalIf(minPart, spec);
                    lenSpecStart = false;
                    continue block9;
                }
                case ',': {
                    minPart = false;
                    continue block9;
                }
                case '0': {
                    if (!lenSpecStart) {
                        builder.requireDigit();
                        continue block9;
                    }
                    if (minPart) {
                        minBuf.append(c);
                        continue block9;
                    }
                    maxBuf.append(c);
                    continue block9;
                }
                default: {
                    PasswordSpec.illegalIf(!lenSpecStart || !PasswordSpec.isDigit(c), spec);
                    if (minPart) {
                        minBuf.append(c);
                        continue block9;
                    }
                    maxBuf.append(c);
                }
            }
        }
        PasswordSpec.illegalIf(lenSpecStart, spec);
        if (minBuf.length() != 0) {
            builder.minLength(Integer.parseInt(minBuf.toString()));
        }
        if (maxBuf.length() != 0) {
            builder.maxLength(Integer.parseInt(maxBuf.toString()));
        }
        return builder;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isLowercase(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean isUppercase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static boolean isSpecialChar(char c) {
        return -1 < SPECIAL_CHARS.indexOf(c);
    }

    private static void illegalIf(boolean test, String spec) {
        if (test) {
            throw new IllegalArgumentException("Invalid password requirement spec:" + spec);
        }
    }

    public static class Builder
    extends PasswordSpec {
        public Builder requireLowercase() {
            ((PasswordSpec)this).trait |= 4096;
            return this;
        }

        public Builder requireUppercase() {
            ((PasswordSpec)this).trait |= 8192;
            return this;
        }

        public Builder requireDigit() {
            ((PasswordSpec)this).trait |= 12288;
            return this;
        }

        public Builder requireSpecialChar() {
            ((PasswordSpec)this).trait |= 16384;
            return this;
        }

        public Builder minLength(int len) {
            ((PasswordSpec)this).minLength = len;
            return this;
        }

        public Builder maxLength(int len) {
            ((PasswordSpec)this).maxLength = len;
            return this;
        }

        public PasswordSpec toPasswordSpec() {
            return new PasswordSpec(this);
        }
    }
}

