/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.Act;
import act.app.SourceInfo;
import act.util.ActError;
import java.util.List;
import org.osgl.mvc.result.Unauthorized;

public class ActUnauthorized
extends Unauthorized
implements ActError {
    private SourceInfo sourceInfo;

    public ActUnauthorized() {
        if (Act.isDev()) {
            this.doFillInStackTrace();
            this.sourceInfo = ActError.Util.loadSourceInfo(ActUnauthorized.class);
        }
    }

    public ActUnauthorized(String realm) {
        super(realm);
        if (Act.isDev()) {
            this.sourceInfo = ActError.Util.loadSourceInfo(ActUnauthorized.class);
        }
    }

    public ActUnauthorized(String realm, boolean digest) {
        super(realm, digest);
        if (Act.isDev()) {
            this.sourceInfo = ActError.Util.loadSourceInfo(ActUnauthorized.class);
        }
    }

    @Override
    public Throwable getCauseOrThis() {
        return this;
    }

    @Override
    public SourceInfo sourceInfo() {
        return this.sourceInfo;
    }

    public StackTraceElement[] getStackTrace() {
        StackTraceElement[] raw = super.getStackTrace();
        if (raw.length < 3) {
            return raw;
        }
        int len = raw.length - 3;
        StackTraceElement[] effective = new StackTraceElement[len];
        System.arraycopy(raw, 3, effective, 0, len);
        return effective;
    }

    @Override
    public List<String> stackTrace() {
        return ActError.Util.stackTraceOf(this);
    }

    @Override
    public boolean isErrorSpot(String traceLine, String nextTraceLine) {
        return false;
    }

    public static Unauthorized create() {
        return Act.isDev() ? new ActUnauthorized() : Unauthorized.get();
    }

    public static Unauthorized create(String realm) {
        return Act.isDev() ? new ActUnauthorized(realm) : Unauthorized.of((String)realm);
    }

    public static Unauthorized create(String realm, boolean digest) {
        return Act.isDev() ? new ActUnauthorized(realm, digest) : new Unauthorized(realm, digest);
    }
}

