/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.Act;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.HashMap;
import org.osgl.$;
import org.osgl.http.H;
import org.osgl.mvc.result.Result;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

public class ZXingResult
extends Result {
    private BarcodeFormat barcodeFormat;
    private ErrorCorrectionLevel errorCorrectionLevel;
    private int width;
    private int height;

    public ZXingResult(String content) {
        this(content, BarcodeFormat.QR_CODE);
    }

    public ZXingResult(String content, BarcodeFormat barcodeFormat) {
        this(content, barcodeFormat, null);
    }

    public ZXingResult(String content, BarcodeFormat barcodeFormat, ErrorCorrectionLevel errorCorrectionLevel) {
        super(H.Status.OK, content);
        this.barcodeFormat = (BarcodeFormat)$.requireNotNull((Object)barcodeFormat);
        this.errorCorrectionLevel = errorCorrectionLevel;
        this.setDefaultDimension();
    }

    public ZXingResult width(int width) {
        this.width = width;
        return this;
    }

    public ZXingResult height(int height) {
        this.height = height;
        return this;
    }

    public ZXingResult errorCorrectionLevel(ErrorCorrectionLevel level) {
        this.errorCorrectionLevel = level;
        return this;
    }

    public ZXingResult barCodeFormat(BarcodeFormat format) {
        this.barcodeFormat = format;
        return this;
    }

    protected void applyMessage(H.Request request, H.Response response) {
        String msg = this.getMessage();
        this.applyBeforeCommitHandler(request, response);
        if (S.notBlank((String)msg)) {
            this.renderCode(response);
        } else {
            IO.close((Closeable)response.outputStream());
        }
        this.applyAfterCommitHandler(request, response);
    }

    protected ErrorCorrectionLevel errorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    protected BarcodeFormat barcodeFormat() {
        return this.barcodeFormat;
    }

    private void setDefaultDimension() {
        if (this.barcodeFormat() == BarcodeFormat.QR_CODE) {
            this.width = 128;
            this.height = 128;
        } else {
            this.width = 128;
            this.height = 96;
        }
    }

    private void renderCode(H.Response response) {
        response.contentType("image/png");
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, Act.appConfig().encoding());
        hints.put(EncodeHintType.MARGIN, 0);
        ErrorCorrectionLevel level = this.errorCorrectionLevel();
        if (null != level) {
            hints.put(EncodeHintType.ERROR_CORRECTION, level);
        }
        MultiFormatWriter writer = new MultiFormatWriter();
        try {
            BitMatrix bitMatrix = writer.encode(this.getMessage(), this.barcodeFormat(), this.width, this.height, hints);
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)response.outputStream());
        }
        catch (Exception e) {
            throw E.unexpected((Throwable)e);
        }
    }

    public static ZXingResult barcode(String content) {
        return new ZXingResult(content, BarcodeFormat.CODE_128);
    }

    public static ZXingResult qrcode(String content) {
        return new ZXingResult(content, BarcodeFormat.QR_CODE);
    }
}

