/*
 * Decompiled with CFR 0.152.
 */
package act.view.rythm;

import act.Act;
import act.Destroyable;
import act.act_messages;
import act.app.ActionContext;
import act.i18n.I18n;
import act.internal.util.ResourceChecksumManager;
import act.job.OnAppStart;
import act.route.Router;
import act.util.ActContext;
import act.util.DestroyableBase;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.ConstraintViolation;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.E;
import org.osgl.util.S;
import org.rythmengine.RythmEngine;
import org.rythmengine.template.ITag;
import org.rythmengine.template.JavaTagBase;

@Singleton
public class Tags
extends DestroyableBase {
    @Inject
    private List<JavaTagBase> fastTags;

    @Override
    @OnAppStart
    protected void releaseResources() {
        Destroyable.Util.tryDestroyAll(this.fastTags, ApplicationScoped.class);
    }

    public void register(RythmEngine engine) {
        if (null == this.fastTags) {
            engine.registerFastTag((JavaTagBase)new ActMessage());
            return;
        }
        for (JavaTagBase tag : this.fastTags) {
            engine.registerFastTag(tag);
        }
    }

    public static class FullUrl
    extends ReverseRouting {
        @Override
        public String __getName() {
            return "fullUrl";
        }

        public FullUrl() {
            super(true);
        }
    }

    public static class ReverseRouting
    extends JavaTagBase {
        private boolean fullUrl = false;
        private static Lang.Func0<String> INFER_REFERENCE_PROVIDER = new Lang.Func0<String>(){

            public String apply() throws NotAppliedException, Lang.Break {
                ActContext.Base<?> context = ActContext.Base.currentContext();
                E.illegalStateIf((null == context ? 1 : 0) != 0, (String)"Cannot get full action path reference outside of act context");
                if (context.templatePathIsImplicit()) {
                    return context.methodPath();
                }
                String path = context.templatePath();
                if (!ReverseRouting.isTemplateBounded(path = S.beforeLast((String)path, (String)"."), context.methodPath())) {
                    return context.methodPath();
                }
                return path.replace('/', '.');
            }
        };

        public ReverseRouting() {
        }

        protected ReverseRouting(boolean fullUrl) {
            this.fullUrl = fullUrl;
        }

        public String __getName() {
            return "url";
        }

        private static boolean isTemplateBounded(String templatePath, String methodPath) {
            int pos = templatePath.indexOf(47);
            if (pos < 0) {
                return false;
            }
            int pos2 = methodPath.indexOf(46);
            if (pos2 != pos) {
                return false;
            }
            String templatePathStartPkg = templatePath.substring(0, pos);
            String methodPathStartPkg = methodPath.substring(0, pos2);
            return S.eq((String)templatePathStartPkg, (String)methodPathStartPkg);
        }

        private String inferFullPath(String actionPath) {
            E.illegalArgumentIf((boolean)S.empty((String)actionPath), (String)"action path expected");
            if (actionPath.contains("/") || !actionPath.contains(".") && !actionPath.contains("(")) {
                return actionPath;
            }
            if (actionPath.contains("(")) {
                actionPath = S.beforeFirst((String)actionPath, (String)"(");
            }
            return Router.inferFullActionPath(actionPath, INFER_REFERENCE_PROVIDER);
        }

        protected void call(ITag.__ParameterList parameterList, ITag.__Body body) {
            ActionContext context;
            Router router;
            Object o = parameterList.getByName("value");
            if (null == o) {
                o = parameterList.getDefault();
            }
            String value = this.inferFullPath(o.toString());
            boolean fullUrl = this.fullUrl;
            o = parameterList.getByName("fullUrl");
            if (null != o) {
                fullUrl = (Boolean)o;
            }
            Router router2 = router = null == (context = ActionContext.current()) ? Act.app().router() : context.router();
            if (value.contains("/") || !value.contains(".")) {
                int n = parameterList.size();
                Object[] args = new Object[n - 1];
                for (int i = 0; i < n - 1; ++i) {
                    args[i] = parameterList.getByPosition(i + 1);
                }
                if (fullUrl) {
                    this.p(router._fullUrl(value, args));
                } else {
                    this.p(String.format(value, args));
                }
            } else {
                HashMap<String, Object> args = new HashMap<String, Object>();
                for (ITag.__Parameter param : parameterList) {
                    String name = param.name;
                    if (S.empty((String)name) || "value".equals(name) || "fullUrl".equals(name)) continue;
                    args.put(param.name, param.value);
                }
                this.p(router.reverseRoute(value, args, fullUrl));
            }
        }
    }

    public static class Asset
    extends Resource {
        @Override
        public String __getName() {
            return "asset";
        }

        @Override
        protected void call(ITag.__ParameterList params, ITag.__Body body) {
            E.illegalArgumentIf((params.size() < 1 ? 1 : 0) != 0);
            String path = params.get((int)0).value.toString();
            if (!path.startsWith("/asset/") && !path.startsWith("asset/")) {
                path = S.pathConcat((String)"asset", (char)'/', (String)path);
            }
            this.call(path);
        }
    }

    public static class Resource
    extends JavaTagBase {
        @Inject
        private ResourceChecksumManager checksumManager;

        public String __getName() {
            return "resource";
        }

        protected void call(ITag.__ParameterList params, ITag.__Body body) {
            E.illegalArgumentIf((params.size() < 1 ? 1 : 0) != 0);
            String path = params.get((int)0).value.toString();
            this.call(path);
        }

        protected void call(String path) {
            if (path.startsWith("http:") || path.startsWith("//")) {
                this.p(path);
                return;
            }
            if (Act.isDev()) {
                if (!path.startsWith("/")) {
                    path = '/' + path;
                }
                path = path + (path.contains("?") ? (char)'&' : '?');
                path = path + "ts=" + $.ms();
            } else {
                String checksum = this.checksumManager.checksumOf(path);
                if (!path.startsWith("/")) {
                    path = '/' + path;
                }
                if (S.notBlank((String)checksum)) {
                    String sep = path.contains("?") ? "&" : "?";
                    path = S.concat((String)path, (String)sep, (String)"checksum=", (String)checksum);
                }
            }
            this.p(path);
        }
    }

    public static class ActMessage
    extends JavaTagBase {
        public String __getName() {
            return "actMsg";
        }

        protected void call(ITag.__ParameterList params, ITag.__Body body) {
            Object[] args;
            int paramSize = params.size();
            E.illegalArgumentIf((paramSize < 1 ? 1 : 0) != 0);
            String msg = params.get((int)0).value.toString();
            if (paramSize > 1) {
                args = new Object[paramSize - 1];
                for (int i = 1; i < paramSize; ++i) {
                    args[i - 1] = params.get((int)i).value;
                }
            } else {
                args = new Object[]{};
            }
            this.p(I18n.i18n(act_messages.class, msg, args));
        }
    }

    public static class ValidationError
    extends JavaTagBase {
        public String __getName() {
            return "_error";
        }

        protected void call(ITag.__ParameterList params, ITag.__Body body) {
            int paramSize = params.size();
            E.illegalArgumentIf((paramSize < 1 ? 1 : 0) != 0);
            String field = params.get((int)0).value.toString();
            ConstraintViolation violation = ActContext.Base.currentContext().violation(field);
            if (null != violation) {
                this.p(violation.getMessage());
            }
        }
    }
}

