/*
 * Decompiled with CFR 0.152.
 */
package act.xio.undertow;

import act.ActResponse;
import act.app.ActionContext;
import act.conf.AppConfig;
import act.xio.undertow.ActBlockingExchange;
import act.xio.undertow.CookieConverter;
import act.xio.undertow.HttpStringCache;
import act.xio.undertow.UndertowResponseOutput;
import io.undertow.io.DefaultIoCallback;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.BlockingHttpExchange;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.osgl.$;
import org.osgl.exception.UnexpectedIOException;
import org.osgl.http.H;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.storage.ISObject;
import org.osgl.util.BufferedOutput;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.Output;
import org.osgl.util.OutputStreamOutput;

public class UndertowResponse
extends ActResponse<UndertowResponse> {
    protected static Logger LOGGER = LogManager.get(UndertowResponse.class);
    private static final HttpString _SERVER = new HttpString("Server");
    private static final HttpStringCache HEADER_NAMES = HttpStringCache.HEADER;
    private HttpServerExchange hse;
    private boolean endAsync;
    private Sender sender;
    private ReentrantLock lock;
    private boolean isPartialMode;
    private AtomicBoolean partialSent = new AtomicBoolean();
    private AtomicBoolean closeExchange = new AtomicBoolean(false);
    private IoCallback ioCallback = new DefaultIoCallback(){

        public void onComplete(HttpServerExchange exchange, Sender sender) {
            if (null != UndertowResponse.this.lock) {
                UndertowResponse.this.lock.lock();
                UndertowResponse.this.buffer.partSent();
                UndertowResponse.this.lock.unlock();
            } else if (UndertowResponse.this.closeExchange.get()) {
                exchange.endExchange();
            } else {
                UndertowResponse.this.partialSent.set(true);
            }
        }

        public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
            if (null != UndertowResponse.this.buffer) {
                UndertowResponse.this.buffer.clear();
                UndertowResponse.this.buffer = null;
            }
            super.onException(exchange, sender, exception);
        }
    };
    private Buffer buffer;

    public UndertowResponse(HttpServerExchange exchange, AppConfig config) {
        super(config);
        this.hse = (HttpServerExchange)$.requireNotNull((Object)exchange);
        this.hse.getResponseHeaders().put(_SERVER, config.serverHeader());
    }

    protected Output createOutput() {
        return BufferedOutput.wrap((Output)(this.blocking() ? new OutputStreamOutput(this.createOutputStream()) : new UndertowResponseOutput(this)));
    }

    public void addCookie(H.Cookie cookie) {
        this.hse.setResponseCookie(CookieConverter.osgl2undertow(cookie));
    }

    public boolean containsHeader(String name) {
        return this.hse.getResponseHeaders().contains(HEADER_NAMES.get(name));
    }

    public UndertowResponse contentLength(long len) {
        this.hse.setResponseContentLength(len);
        return this;
    }

    Sender sender() {
        if (null == this.sender) {
            this.sender = this.hse.getResponseSender();
            this.endAsync = !this.blocking();
        }
        return this.sender;
    }

    public UndertowResponse writeContent(String s) {
        this.beforeWritingContent();
        try {
            this.sender().send(s);
            this.endAsync = !this.blocking();
            this.afterWritingContent();
        }
        catch (RuntimeException e) {
            this.endAsync = false;
            this.afterWritingContent();
            throw e;
        }
        return this;
    }

    public void writeContentPart(String s) {
        ByteBuffer buffer = ByteBuffer.wrap(s.getBytes(StandardCharsets.UTF_8));
        this.writeContentPart(buffer);
    }

    public void writeContentPart(ByteBuffer buffer) {
        this.isPartialMode = true;
        try {
            if (null != buffer) {
                this.partialSent.set(false);
                this.sender().send(buffer, this.ioCallback);
            } else {
                this.buffer.sendOrBuf(buffer, this.sender());
            }
        }
        catch (IllegalStateException e) {
            this.lock = new ReentrantLock();
            this.buffer = new Buffer(this.ioCallback, this.lock);
            this.buffer.sendOrBuf(buffer, this.sender());
        }
        catch (RuntimeException e) {
            this.endAsync = false;
            throw e;
        }
    }

    public UndertowResponse writeContent(ByteBuffer byteBuffer) {
        this.beforeWritingContent();
        try {
            this.sender().send(byteBuffer);
            this.endAsync = !this.blocking();
            this.afterWritingContent();
        }
        catch (RuntimeException e) {
            this.endAsync = false;
            this.afterWritingContent();
            throw e;
        }
        return this;
    }

    public UndertowResponse writeBinary(ISObject binary) {
        this.beforeWritingContent();
        File file = this.tryGetFileFrom(binary);
        if (null == file) {
            byte[] ba = binary.asByteArray();
            ByteBuffer buffer = ByteBuffer.wrap(ba);
            this.sender().send(buffer);
            this.endAsync = !this.blocking();
            this.afterWritingContent();
        } else {
            try {
                this.sender().transferFrom(FileChannel.open(file.toPath(), new OpenOption[0]), IoCallback.END_EXCHANGE);
                this.endAsync = !this.blocking();
                this.afterWritingContent();
            }
            catch (IOException e) {
                this.endAsync = false;
                this.afterWritingContent();
                throw E.ioException((IOException)e);
            }
        }
        return this;
    }

    public OutputStream outputStream() throws IllegalStateException, UnexpectedIOException {
        return super.outputStream();
    }

    public Locale locale() {
        return this.locale;
    }

    public void commit() {
        if (null != this.output) {
            this.output.flush();
        } else if (null != this.outputStream) {
            IO.close((Closeable)this.outputStream);
        } else if (null != this.writer) {
            IO.close((Closeable)this.writer);
        }
        if (!this.endAsync) {
            this.hse.endExchange();
        } else if (null != this.buffer) {
            this.buffer.sendThroughFinalPart(this.sender());
        } else if (this.isPartialMode) {
            if (this.partialSent.get()) {
                this.hse.endExchange();
            } else {
                this.closeExchange.set(true);
            }
        }
        this.markClosed();
    }

    public UndertowResponse header(String name, String value) {
        this.hse.getResponseHeaders().put(HEADER_NAMES.get(name), value);
        return this;
    }

    @Override
    public void _setStatusCode(int sc) {
        this.hse.setStatusCode(sc);
    }

    public UndertowResponse addHeader(String name, String value) {
        HeaderMap map = this.hse.getResponseHeaders();
        map.add(HEADER_NAMES.get(name), value);
        return this;
    }

    public void freeResources() {
        if (this.writer != null) {
            IO.close((Closeable)this.writer);
        } else if (this.outputStream != null) {
            IO.close((Closeable)this.outputStream);
        }
    }

    private void ensureBlocking() {
        if (!this.blocking()) {
            this.hse.startBlocking((BlockingHttpExchange)new ActBlockingExchange(this.hse, ActionContext.current()));
        }
    }

    private File tryGetFileFrom(ISObject sobj) {
        String className = sobj.getClass().getSimpleName();
        if (className.contains("FileSObject")) {
            return sobj.asFile();
        }
        return null;
    }

    protected OutputStream createOutputStream() {
        this.ensureBlocking();
        return this.hse.getOutputStream();
    }

    protected void _setLocale(Locale loc) {
        if (this.responseStarted()) {
            return;
        }
        this.locale = loc;
        this.hse.getResponseHeaders().put(Headers.CONTENT_LANGUAGE, loc.getLanguage() + "-" + loc.getCountry());
    }

    protected Class<UndertowResponse> _impl() {
        return UndertowResponse.class;
    }

    private boolean responseStarted() {
        return this.hse.isResponseStarted();
    }

    private boolean blocking() {
        return this.hse.isBlocking();
    }

    private static class Buffer {
        boolean isSending;
        ByteBuffer buffer;
        IoCallback callback;
        ReentrantLock lock;
        Condition finalPartToGo;

        Buffer(IoCallback callback, ReentrantLock lock) {
            this.callback = (IoCallback)$.requireNotNull((Object)callback);
            this.isSending = true;
            this.lock = lock;
        }

        void sendOrBuf(String content, Sender sender) {
            this.sendOrBuf(ByteBuffer.wrap(content.getBytes(StandardCharsets.UTF_8)), sender);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendOrBuf(ByteBuffer content, Sender sender) {
            this.lock.lock();
            try {
                if (null == this.buffer) {
                    this.buffer = content;
                } else {
                    ByteBuffer merged = ByteBuffer.allocate(this.buffer.limit() + content.limit());
                    merged.put(this.buffer).put(content).flip();
                    this.buffer = merged;
                }
                if (!this.isSending) {
                    this.isSending = true;
                    ByteBuffer buffer = this.buffer;
                    this.buffer = null;
                    sender.send(buffer, this.callback);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendThroughFinalPart(Sender sender) {
            if (null == this.buffer) {
                return;
            }
            this.lock.lock();
            try {
                if (!this.isSending) {
                    this.isSending = true;
                    sender.send(this.buffer);
                } else {
                    this.finalPartToGo = this.lock.newCondition();
                    while (this.isSending) {
                        try {
                            this.finalPartToGo.await();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw E.unexpected((Throwable)e);
                        }
                    }
                    ByteBuffer buffer = this.buffer;
                    this.buffer = null;
                    sender.send(buffer, this.callback);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        void partSent() {
            this.isSending = false;
            if (null != this.finalPartToGo) {
                this.finalPartToGo.signal();
            }
        }

        private void clear() {
            this.isSending = false;
            this.buffer = null;
        }
    }
}

