/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.io.PrintStream;
import jline.Terminal;
import jline.TerminalFactory;
import me.tongfei.progressbar.ProgressBarStyle;
import me.tongfei.progressbar.ProgressState;
import me.tongfei.progressbar.Util;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;

class ProgressThread
implements Runnable {
    volatile boolean killed;
    ProgressBarStyle style;
    ProgressState progress;
    long updateInterval;
    PrintStream consoleStream;
    Terminal terminal;
    int consoleWidth = 80;
    static int consoleRightMargin = 2;
    int length;

    ProgressThread(ProgressState progress, ProgressBarStyle style, long updateInterval, PrintStream consoleStream) {
        this.progress = progress;
        this.style = style;
        this.updateInterval = updateInterval;
        this.consoleStream = consoleStream;
        this.killed = false;
        this.terminal = TerminalFactory.get();
        if (this.terminal.getWidth() >= 10) {
            this.consoleWidth = this.terminal.getWidth();
        }
    }

    double progress() {
        if (this.progress.max <= 0L) {
            return 0.0;
        }
        return (double)this.progress.current / (double)this.progress.max;
    }

    int progressIntegralPart() {
        return (int)(this.progress() * (double)this.length);
    }

    int progressFractionalPart() {
        double p = this.progress() * (double)this.length;
        double fraction = (p - Math.floor(p)) * (double)this.style.fractionSymbols.length();
        return (int)Math.floor(fraction);
    }

    String eta(Duration elapsed) {
        if (this.progress.max <= 0L || this.progress.indefinite) {
            return "?";
        }
        if (this.progress.current == 0L) {
            return "?";
        }
        return Util.formatDuration(elapsed.dividedBy(this.progress.current).multipliedBy(this.progress.max - this.progress.current));
    }

    String percentage() {
        String res = this.progress.max <= 0L || this.progress.indefinite ? "? %" : String.valueOf((int)Math.floor(100.0 * (double)this.progress.current / (double)this.progress.max)) + "%";
        return Util.repeat(' ', 4 - res.length()) + res;
    }

    String ratio() {
        String m = this.progress.indefinite ? "?" : String.valueOf(this.progress.max);
        String c = String.valueOf(this.progress.current);
        return Util.repeat(' ', m.length() - c.length()) + c + "/" + m;
    }

    void refresh() {
        this.consoleStream.print('\r');
        LocalDateTime currTime = LocalDateTime.now();
        Duration elapsed = new Duration((ReadableInstant)this.progress.startTime.toDateTime(DateTimeZone.UTC), (ReadableInstant)currTime.toDateTime(DateTimeZone.UTC));
        String prefix = this.progress.task + " " + this.percentage() + " " + this.style.leftBracket;
        int maxSuffixLength = Math.max(0, this.consoleWidth - consoleRightMargin - prefix.length() - 10);
        String suffix = this.style.rightBracket + " " + this.ratio() + " (" + Util.formatDuration(elapsed) + " / " + this.eta(elapsed) + ") " + this.progress.extraMessage;
        if (suffix.length() > maxSuffixLength) {
            suffix = suffix.substring(0, maxSuffixLength);
        }
        this.length = this.consoleWidth - consoleRightMargin - prefix.length() - suffix.length();
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if (this.progress.indefinite) {
            int pos = (int)(this.progress.current % (long)this.length);
            sb.append(Util.repeat(this.style.space, pos));
            sb.append(this.style.block);
            sb.append(Util.repeat(this.style.space, this.length - pos - 1));
        } else {
            sb.append(Util.repeat(this.style.block, this.progressIntegralPart()));
            if (this.progress.current < this.progress.max) {
                sb.append(this.style.fractionSymbols.charAt(this.progressFractionalPart()));
                sb.append(Util.repeat(this.style.space, this.length - this.progressIntegralPart() - 1));
            }
        }
        sb.append(suffix);
        String line = sb.toString();
        this.consoleStream.print(line);
    }

    void kill() {
        this.killed = true;
    }

    @Override
    public void run() {
        try {
            while (!this.killed) {
                this.refresh();
                Thread.sleep(this.updateInterval);
            }
            this.refresh();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

