/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.app.App;
import act.app.AppByteCodeScanner;
import act.app.AppCodeScanner;
import act.app.AppServiceBase;
import act.app.AppSourceCodeScanner;
import java.util.ArrayList;
import java.util.List;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;

public class AppCodeScannerManager
extends AppServiceBase<AppCodeScannerManager> {
    private static final Logger logger = L.get(AppCodeScannerManager.class);
    private List<AppSourceCodeScanner> sourceCodeScanners = new ArrayList<AppSourceCodeScanner>();
    private List<AppByteCodeScanner> byteCodeScanners = new ArrayList<AppByteCodeScanner>();

    public AppCodeScannerManager(App app) {
        super(app);
    }

    public C.List<AppSourceCodeScanner> sourceCodeScanners() {
        return C.list(this.sourceCodeScanners);
    }

    public C.List<AppByteCodeScanner> byteCodeScanners() {
        return C.list(this.byteCodeScanners);
    }

    public AppByteCodeScanner byteCodeScannerByClass(Class<? extends AppByteCodeScanner> c) {
        for (AppByteCodeScanner scanner : this.byteCodeScanners) {
            if (scanner.getClass() != c) continue;
            return scanner;
        }
        return null;
    }

    public AppCodeScannerManager register(AppSourceCodeScanner sourceCodeScanner) {
        this._register(sourceCodeScanner, this.sourceCodeScanners);
        return this;
    }

    public AppCodeScannerManager register(AppByteCodeScanner byteCodeScanner) {
        this._register(byteCodeScanner, this.byteCodeScanners);
        return this;
    }

    @Override
    protected void releaseResources() {
        this.sourceCodeScanners.clear();
        this.byteCodeScanners.clear();
    }

    private <T extends AppCodeScanner> void _register(T scanner, List<T> scanners) {
        scanner.setApp(this.app());
        if (scanners.contains(scanner)) {
            logger.warn("%s has already been registered", new Object[]{scanner});
            return;
        }
        scanners.add(scanner);
    }
}

