/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Act;
import act.app.App;
import act.app.BuildFileProbe;
import act.app.ProjectLayout;
import act.app.ProjectLayoutProbe;
import act.app.SingleAppScanner;
import act.internal.util.AppDescriptor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.osgl.Lang;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.Iterators;

public class AppScanner {
    private static Logger logger = L.get(AppScanner.class);
    public static AppScanner DEF_SCANNER = new AppScanner();
    public static AppScanner SINGLE_APP_SCANNER = new SingleAppScanner();
    private final Map<String, ProjectLayoutProbe> buildFileProbeMap = new HashMap<String, ProjectLayoutProbe>();
    private final List<ProjectLayoutProbe> projectLayoutProbes = new ArrayList<ProjectLayoutProbe>();

    protected AppScanner() {
    }

    public AppScanner register(ProjectLayoutProbe probe) {
        if (probe instanceof BuildFileProbe) {
            this.buildFileProbeMap.put(((BuildFileProbe)probe).buildFileName(), probe);
        } else {
            this.projectLayoutProbes.add(probe);
        }
        return this;
    }

    public int test_probeCnt() {
        return this.buildFileProbeMap.size() + this.projectLayoutProbes.size();
    }

    void scan(AppDescriptor descriptor, Lang.Func1<App, ?> callback) {
        for (File appBase : this.appBases()) {
            this.scan(descriptor, appBase, callback);
        }
    }

    protected File[] appBases() {
        File appBase = Act.conf().appBase();
        return appBase.listFiles();
    }

    private void scan(AppDescriptor descriptor, File appBase, Lang.Func1<App, ?> callback) {
        ProjectLayout layout = this.probe(appBase);
        if (null == layout && !Act.isDev()) {
            layout = ProjectLayout.PredefinedLayout.PKG;
        }
        if (null != layout) {
            App app = App.create(appBase, descriptor.getVersion(), layout);
            if (null != descriptor.getAppName()) {
                app.name(descriptor.getAppName());
            }
            callback.apply((Object)app);
        } else {
            logger.warn("%s is not a valid app base", new Object[]{appBase.getPath()});
        }
    }

    private ProjectLayout probe(File appBase) {
        ProjectLayout layout = this.probeLayoutPropertiesFile(appBase);
        if (null != layout) {
            return layout;
        }
        layout = this.probeLayoutPlugin(appBase);
        if (null != layout) {
            return layout;
        }
        return this.probeDefaultLayouts(appBase);
    }

    private ProjectLayout probeLayoutPlugin(File appBase) {
        Iterator<ProjectLayoutProbe> probes = this.pluginProbes();
        while (probes.hasNext()) {
            ProjectLayoutProbe probe = probes.next();
            ProjectLayout layout = probe.probe(appBase);
            if (null == layout) continue;
            return layout;
        }
        return null;
    }

    private ProjectLayout probeDefaultLayouts(File appBase) {
        ProjectLayout.PredefinedLayout[] predefined = ProjectLayout.PredefinedLayout.values();
        for (int i = predefined.length - 1; i >= 0; --i) {
            ProjectLayout.PredefinedLayout layout = predefined[i];
            if (!ProjectLayout.util.probeAppBase(appBase, layout)) continue;
            return layout;
        }
        return null;
    }

    private ProjectLayout probeLayoutPropertiesFile(File appBase) {
        File f2 = new File(appBase, "proj.layout");
        if (f2.exists() && f2.canRead()) {
            Properties p = new Properties();
            InputStream is = IO.is((File)f2);
            try {
                p.load(is);
            }
            catch (IOException e) {
                throw E.ioException((IOException)e);
            }
            finally {
                IO.close((Closeable)is);
            }
            return ProjectLayout.util.build(p);
        }
        return null;
    }

    private Iterator<ProjectLayoutProbe> pluginProbes() {
        return Iterators.composite(this.buildFileProbeMap.values().iterator(), this.projectLayoutProbes.iterator());
    }
}

