/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Act;
import act.app.util.NamedPort;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.E;
import org.osgl.util.S;

public interface ProjectLayout {
    public static final String PROJ_LAYOUT_FILE = "proj.layout";

    public File source(File var1);

    public File testSource(File var1);

    public File resource(File var1);

    public File testResource(File var1);

    public File lib(File var1);

    public File testLib(File var1);

    public String classes();

    public File target(File var1);

    public Map<String, List<File>> routeTables(File var1);

    public File conf(File var1);

    public static enum F {

        public static Lang.F2<File, ProjectLayout, File> SRC = new Lang.F2<File, ProjectLayout, File>(){

            public File apply(File base, ProjectLayout layout) throws NotAppliedException, Lang.Break {
                return layout.source(base);
            }
        };
        public static Lang.F2<File, ProjectLayout, File> RSRC = new Lang.F2<File, ProjectLayout, File>(){

            public File apply(File base, ProjectLayout layout) throws NotAppliedException, Lang.Break {
                return layout.resource(base);
            }
        };
        public static Lang.F2<File, ProjectLayout, File> LIB = new Lang.F2<File, ProjectLayout, File>(){

            public File apply(File base, ProjectLayout layout) throws NotAppliedException, Lang.Break {
                return layout.lib(base);
            }
        };
        public static Lang.F2<File, ProjectLayout, File> TST_SRC = new Lang.F2<File, ProjectLayout, File>(){

            public File apply(File base, ProjectLayout layout) throws NotAppliedException, Lang.Break {
                return layout.testSource(base);
            }
        };
        public static Lang.F2<File, ProjectLayout, File> TST_RSRC = new Lang.F2<File, ProjectLayout, File>(){

            public File apply(File base, ProjectLayout layout) throws NotAppliedException, Lang.Break {
                return layout.testResource(base);
            }
        };
        public static Lang.F2<File, ProjectLayout, File> TST_LIB = new Lang.F2<File, ProjectLayout, File>(){

            public File apply(File base, ProjectLayout layout) throws NotAppliedException, Lang.Break {
                return layout.testLib(base);
            }
        };
    }

    public static enum Utils {


        public static File file(File parent, String path) {
            try {
                return new File(parent, path).getCanonicalFile();
            }
            catch (IOException e) {
                throw E.ioException((IOException)e);
            }
        }
    }

    public static class CustomizedProjectLayout
    implements ProjectLayout {
        private String source;
        private String testSource;
        private String lib;
        private String testLib;
        private String routeTable;
        private String conf;
        private String target;
        private String resource;
        private String testResource;

        public CustomizedProjectLayout(String src, String testSource, String resource, String testResource, String lib, String testLib, String tgt, String routeTable, String conf) {
            this.source = src;
            this.testSource = testSource;
            this.resource = resource;
            this.testResource = testResource;
            this.lib = lib;
            this.testLib = testLib;
            this.target = tgt;
            this.routeTable = routeTable;
            this.conf = conf;
        }

        @Override
        public File source(File appBase) {
            return Utils.file(appBase, this.source);
        }

        @Override
        public File testSource(File appBase) {
            return Utils.file(appBase, this.testSource);
        }

        @Override
        public File lib(File appBase) {
            return Utils.file(appBase, this.lib);
        }

        @Override
        public File testLib(File appBase) {
            return Utils.file(appBase, this.testLib);
        }

        @Override
        public Map<String, List<File>> routeTables(File appBase) {
            HashMap<String, List<File>> map = new HashMap<String, List<File>>();
            map.put("default", this.routeTables(appBase, this.routeTable));
            return map;
        }

        private List<File> routeTables(File appBase, String routeTable) {
            ArrayList<File> files = new ArrayList<File>();
            files.add(Utils.file(appBase, routeTable));
            File confRoot = Utils.file(appBase, this.conf);
            files.add(Utils.file(confRoot, routeTable));
            File profileRoot = Utils.file(confRoot, Act.profile());
            files.add(Utils.file(profileRoot, routeTable));
            return files;
        }

        @Override
        public File resource(File appBase) {
            return Utils.file(appBase, this.resource);
        }

        @Override
        public File testResource(File appBase) {
            return Utils.file(appBase, this.testResource);
        }

        @Override
        public String classes() {
            return "/classes";
        }

        @Override
        public File conf(File appBase) {
            return Utils.file(appBase, this.conf);
        }

        @Override
        public File target(File appBase) {
            return Utils.file(appBase, this.target);
        }
    }

    public static enum util {


        public static boolean probeAppBase(File dir, ProjectLayout layout) {
            File conf = layout.conf(dir);
            if (null != conf && conf.canRead() && conf.isFile()) {
                return true;
            }
            File src = layout.source(dir);
            if (null != src && src.canRead() && src.isDirectory()) {
                File tgt = layout.target(dir);
                return null != tgt && tgt.canRead() && tgt.isDirectory();
            }
            return false;
        }

        public static ProjectLayout build(Properties p) {
            String source = util._get("source", p);
            String testSource = util._get("testSource", p);
            String lib = util._get("lib", p);
            String testLib = util._get("testLib", p);
            String resource = util._get("resource", p);
            String testResource = util._get("testResource", p);
            String routes = util._get("routes", p);
            String conf = util._get("conf", p);
            String target = util._get("target", p);
            return new CustomizedProjectLayout(source, testSource, resource, testResource, lib, testLib, target, routes, conf);
        }

        private static String _get(String key, Properties p) {
            String s = p.getProperty(key);
            E.invalidConfigurationIf((null == s ? 1 : 0) != 0, (String)"cannot findBy '%s' setting in project layout properties", (Object[])new Object[]{key});
            return s;
        }
    }

    public static enum PredefinedLayout implements ProjectLayout
    {
        MAVEN{

            @Override
            public File source(File appBase) {
                return Utils.file(appBase, "src/main/java");
            }

            @Override
            public File testSource(File appBase) {
                return Utils.file(appBase, "src/test/java");
            }

            @Override
            public File resource(File appBase) {
                String resources = Act.isDev() ? "src/main/resources" : "classes";
                return Utils.file(appBase, resources);
            }

            @Override
            public File testResource(File appBase) {
                String resources = Act.isDev() ? "src/test/resources" : "test-classes";
                return Utils.file(appBase, resources);
            }

            @Override
            public File lib(File appBase) {
                String lib = Act.isDev() ? "src/main/lib" : "lib";
                return Utils.file(appBase, lib);
            }

            @Override
            public File testLib(File appBase) {
                String lib = Act.isDev() ? "src/test/lib" : "test-lib";
                return Utils.file(appBase, lib);
            }

            @Override
            public String classes() {
                return "/classes";
            }

            @Override
            public File target(File appBase) {
                return Utils.file(appBase, "target");
            }
        }
        ,
        GRADLE_GROOVY{

            @Override
            public File source(File appBase) {
                return Utils.file(appBase, "src/main/groovy");
            }

            @Override
            public File testSource(File appBase) {
                return Utils.file(appBase, "src/test/groovy");
            }

            @Override
            public File resource(File appBase) {
                if (Act.isDev()) {
                    return Utils.file(appBase, "src/main/resources");
                }
                return Utils.file(this.target(appBase), "resources/main");
            }

            @Override
            public File testResource(File appBase) {
                if (Act.isDev()) {
                    return Utils.file(appBase, "src/test/resources");
                }
                return Utils.file(this.target(appBase), "resources/test");
            }

            @Override
            public File lib(File appBase) {
                String lib = Act.isDev() ? "src/main/lib" : "libs";
                return Utils.file(appBase, lib);
            }

            @Override
            public File testLib(File appBase) {
                String lib = Act.isDev() ? "src/test/lib" : "test-libs";
                return Utils.file(appBase, lib);
            }

            @Override
            public String classes() {
                return "classes/groovy/main";
            }

            @Override
            public File target(File appBase) {
                return Utils.file(appBase, "build");
            }
        }
        ,
        GRADLE_GROOVY_IDEA{

            @Override
            public File source(File appBase) {
                return Utils.file(appBase, "src/main/groovy");
            }

            @Override
            public File testSource(File appBase) {
                return Utils.file(appBase, "src/test/groovy");
            }

            @Override
            public File resource(File appBase) {
                if (Act.isDev()) {
                    return Utils.file(appBase, "src/main/resources");
                }
                return Utils.file(appBase, "out/production/resources");
            }

            @Override
            public File testResource(File appBase) {
                if (Act.isDev()) {
                    return Utils.file(appBase, "src/test/resources");
                }
                return Utils.file(appBase, "out/test/resources");
            }

            @Override
            public File lib(File appBase) {
                String lib = Act.isDev() ? "src/main/lib" : "libs";
                return Utils.file(appBase, lib);
            }

            @Override
            public File testLib(File appBase) {
                String lib = Act.isDev() ? "src/test/lib" : "test-libs";
                return Utils.file(appBase, lib);
            }

            @Override
            public String classes() {
                return "classes";
            }

            @Override
            public File target(File appBase) {
                return Utils.file(appBase, "out/production");
            }
        }
        ,
        PKG{

            @Override
            public File source(File appBase) {
                return null;
            }

            @Override
            public File testSource(File appBase) {
                return null;
            }

            @Override
            public File testResource(File appBase) {
                return null;
            }

            @Override
            public File testLib(File appBase) {
                return null;
            }

            @Override
            public File resource(File appBase) {
                return Utils.file(appBase, "classes");
            }

            @Override
            public File lib(File appBase) {
                return Utils.file(appBase, "lib");
            }

            @Override
            public String classes() {
                return "/classes";
            }

            @Override
            public File target(File appBase) {
                return appBase;
            }
        }
        ,
        PLAY{

            @Override
            public File source(File appBase) {
                return Utils.file(appBase, "app");
            }

            @Override
            public File testSource(File appBase) {
                return Utils.file(appBase, "test");
            }

            @Override
            public File resource(File appBase) {
                return Utils.file(appBase, "conf");
            }

            @Override
            public File testResource(File appBase) {
                return this.resource(appBase);
            }

            @Override
            public File lib(File appBase) {
                return Utils.file(appBase, "lib");
            }

            @Override
            public File testLib(File appBase) {
                return this.lib(appBase);
            }

            @Override
            public String classes() {
                return "/classes";
            }

            @Override
            public File target(File appBase) {
                return Utils.file(appBase, "tmp");
            }
        };


        @Override
        public File conf(File appBase) {
            File confBase = Act.isDev() ? this.resource(appBase) : new File(appBase, "/classes");
            File file = new File(confBase, "/conf");
            return file.exists() ? file : confBase;
        }

        @Override
        public Map<String, List<File>> routeTables(File appBase) {
            HashMap<String, List<File>> map = new HashMap<String, List<File>>();
            map.put("default", this.routeTables(appBase, "routes.conf"));
            for (NamedPort np : Act.app().config().namedPorts()) {
                String npName = np.name();
                String routesFile = S.concat((String)"routes.", (String)npName, (String)".conf");
                map.put(npName, this.routeTables(appBase, routesFile));
            }
            return map;
        }

        private List<File> routeTables(File appBase, String routesFiile) {
            ArrayList<File> files = new ArrayList<File>();
            File resourceBase = this.resource(appBase);
            files.add(Utils.file(resourceBase, routesFiile));
            File confBase = this.conf(appBase);
            if ($.eq((Object)confBase, (Object)resourceBase)) {
                return files;
            }
            files.add(Utils.file(confBase, routesFiile));
            File commonBase = Utils.file(confBase, "common");
            files.add(Utils.file(commonBase, routesFiile));
            File profileBase = Utils.file(confBase, Act.profile());
            files.add(Utils.file(profileBase, routesFiile));
            return files;
        }

        public static ProjectLayout valueOfIgnoreCase(String s) {
            s = s.trim().toUpperCase();
            if (MAVEN.name().equals(s)) {
                return MAVEN;
            }
            if (PLAY.name().equals(s)) {
                return PLAY;
            }
            return null;
        }
    }
}

