/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.conf.AppConfig;
import act.conf.Config;
import act.inject.util.ConfigResourceLoader;
import act.util.LogSupport;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.osgl.util.IO;
import org.osgl.util.S;

public class RouterRegexMacroLookup
extends LogSupport {
    private static final String MACRO_DEF_FILE = "act.router.macro";
    private Map<String, String> macros = new HashMap<String, String>();

    public RouterRegexMacroLookup(AppConfig<?> config) {
        InputStream is;
        String namespace = "router.macro";
        String prefix = "router.macro.";
        Map<String, Object> appConfigMacros = config.subSet("router.macro");
        for (Map.Entry<String, Object> entry : appConfigMacros.entrySet()) {
            String key = S.afterFirst((String)entry.getKey(), (String)"router.macro.");
            this.macros.put(key, entry.getValue().toString());
        }
        String macroDefinitionFile = (String)config.get("router.macro_file");
        if (null == macroDefinitionFile) {
            macroDefinitionFile = MACRO_DEF_FILE;
        }
        if (null != (is = ConfigResourceLoader.load(macroDefinitionFile, InputStream.class, true))) {
            Properties properties = IO.loadProperties((InputStream)is);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.macros.put(Config.canonical(S.string((Object)entry.getKey())), S.string((Object)entry.getValue()));
            }
        }
    }

    public String expand(String macro) {
        if (!this.isMacro(macro)) {
            return macro;
        }
        String definition = this.macros.get(Config.canonical(macro));
        if (null == definition) {
            this.warn("possible missing definition of macro[%s]", macro);
        }
        return null == definition ? macro : definition;
    }

    private boolean isMacro(String s) {
        return s.startsWith("__");
    }
}

