/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.util.ClassNames;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.FastStr;
import org.osgl.util.IO;
import org.osgl.util.S;

public class Source {
    private File file;
    private String simpleName;
    private String packageName;
    private String className;
    private String code;
    private byte[] bytes;
    private Map<String, byte[]> innerBytes = new HashMap<String, byte[]>();
    private State state = State.CREATED;
    private ICompilationUnit compilationUnit;
    private boolean isController;
    private long ts;

    private Source(File file, String className) {
        E.NPE((Object)file, (Object)className);
        this.file = file;
        this.simpleName = S.afterLast((String)className, (String)".");
        this.packageName = S.beforeLast((String)className, (String)".");
        this.className = className;
        this.compilationUnit = this._compilationUnit();
    }

    public String simpleName() {
        return this.simpleName;
    }

    public String packageName() {
        return this.packageName;
    }

    public String className() {
        return this.className;
    }

    public String code() {
        if (null == this.code) {
            this.load();
        }
        return this.code;
    }

    public List<String> lines() {
        return C.listOf((Object[])this.code.split("\n"));
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public byte[] bytes(String innerClass) {
        return this.innerBytes.get(innerClass);
    }

    public Set<String> innerClassNames() {
        return this.innerBytes.keySet();
    }

    public File file() {
        return this.file;
    }

    public void load() {
        this.code = IO.readContentAsString((File)this.file);
        this.updateState(State.LOADED);
    }

    public void markAsController() {
        this.isController = true;
    }

    public boolean isController() {
        return this.isController;
    }

    void compiled(byte[] bytecode) {
        this.bytes = (byte[])$.requireNotNull((Object)bytecode);
        this.updateState(State.COMPILED);
    }

    void compiled(String innerClassName, byte[] bytecode) {
        this.innerBytes.put(innerClassName, bytecode);
    }

    void enhanced(byte[] bytecode) {
        this.bytes = (byte[])$.requireNotNull((Object)bytecode);
        this.updateState(State.ENHANCED);
    }

    public void refresh() {
        this.bytes = null;
        this.ts = 0L;
        this.tryLoadSourceFile();
    }

    private void updateState(State state) {
        this.state = state;
        this.ts = $.ms();
    }

    private void tryLoadSourceFile() {
        if (this.file.exists()) {
            this.code = IO.readContentAsString((File)this.file);
            this.updateState(State.LOADED);
        } else {
            this.updateState(State.DELETED);
        }
    }

    public static Source ofFile(File sourceRoot, File file) {
        String className = Util.className(sourceRoot, file);
        return null == className ? null : new Source(file, className);
    }

    public static Source ofClass(List<File> sourceRoots, String className) {
        File file = Util.sourceFile(sourceRoots, className);
        if (null != file) {
            return new Source(file, className);
        }
        return null;
    }

    public static Source ofInnerClass(File sourceFile, String innerClassName) {
        return new Source(sourceFile, innerClassName);
    }

    private ICompilationUnit _compilationUnit() {
        return new ICompilationUnit(){
            char[] mainTypeName = this._mainTypeName();
            char[][] packageName = this._packageName();
            char[] fileName = this._fileName();

            public char[] getContents() {
                return Source.this.code().toCharArray();
            }

            public char[] getMainTypeName() {
                return this.mainTypeName;
            }

            private char[] _mainTypeName() {
                String s = Source.this.simpleName();
                int pos = s.indexOf(36);
                if (pos > -1) {
                    s = s.substring(0, pos);
                }
                return s.toCharArray();
            }

            public char[][] getPackageName() {
                return this.packageName;
            }

            char[][] _packageName() {
                StringTokenizer tokens = new StringTokenizer(Source.this.packageName(), ".");
                char[][] ca = new char[tokens.countTokens()][];
                for (int i = 0; i < ca.length; ++i) {
                    ca[i] = tokens.nextToken().toCharArray();
                }
                return ca;
            }

            public boolean ignoreOptionalProblems() {
                return false;
            }

            public char[] getFileName() {
                return this.fileName;
            }

            char[] _fileName() {
                String s = Source.this.simpleName();
                int pos = s.indexOf(36);
                if (pos > -1) {
                    s = s.substring(0, pos);
                }
                s = s.replace('.', '/');
                s = s + ".java";
                return s.toCharArray();
            }
        };
    }

    ICompilationUnit compilationUnit() {
        return this.compilationUnit;
    }

    public static enum Util {


        public static String className(File sourceRoot, File file) {
            return ClassNames.sourceFileNameToClassName(sourceRoot, file.getAbsolutePath());
        }

        public static File sourceFile(List<File> sourceRoots, String className) {
            FastStr s = FastStr.of((String)className).beforeFirst('$');
            s = s.replace('.', File.separatorChar).append(".java");
            for (File sourceRoot : sourceRoots) {
                File file = new File(sourceRoot, s.toString());
                if (!file.canRead()) continue;
                return file;
            }
            return null;
        }

        public static void main(String[] args) throws Exception {
        }
    }

    public static enum State {
        CREATED,
        LOADED,
        COMPILED,
        ERROR_COMPILE,
        DELETED,
        ENHANCED;

    }
}

