/*
 * Decompiled with CFR 0.152.
 */
package act.app.data;

import act.app.App;
import act.app.AppServiceBase;
import act.conf.AppConfig;
import act.data.SObjectResolver;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.osgl.$;
import org.osgl.storage.ISObject;
import org.osgl.util.AnnotationAware;
import org.osgl.util.E;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

public class StringValueResolverManager
extends AppServiceBase<StringValueResolverManager> {
    private Map<Class, StringValueResolver> resolvers = new HashMap<Class, StringValueResolver>();

    public StringValueResolverManager(App app) {
        super(app);
        this.registerPredefinedResolvers();
        this.registerBuiltInResolvers(app.config());
    }

    @Override
    protected void releaseResources() {
        this.resolvers.clear();
    }

    public <T> StringValueResolverManager register(Class<T> targetType, StringValueResolver<T> resolver) {
        this.resolvers.put(targetType, resolver);
        return this;
    }

    public <T> T resolve(String strVal, Class<T> targetType) {
        StringValueResolver<T> r = this.resolver(targetType);
        return (T)(null != r ? r.resolve(strVal) : null);
    }

    public <T extends Collection> StringValueResolver<T> collectionResolver(final Class<T> targetType, Class<?> elementType, final char separator) {
        final StringValueResolver<?> elementResolver = this.resolver(elementType);
        return new StringValueResolver<T>(targetType){

            public T resolve(String value) {
                Collection col = (Collection)StringValueResolverManager.this.app().getInstance(targetType);
                S.List parts = S.fastSplit((String)value, (String)String.valueOf(separator));
                for (String part : parts) {
                    col.add(elementResolver.resolve(part));
                }
                return col;
            }
        };
    }

    public <T extends Collection> StringValueResolver<T> collectionResolver(final Class<T> targetType, Class<?> elementType, final String separator) {
        final StringValueResolver<?> elementResolver = this.resolver(elementType);
        return new StringValueResolver<T>(targetType){

            public T resolve(String value) {
                String[] parts;
                Collection col = (Collection)StringValueResolverManager.this.app().getInstance(targetType);
                for (String part : parts = value.split(separator)) {
                    col.add(elementResolver.resolve(part));
                }
                return col;
            }
        };
    }

    public <T> StringValueResolver<T> resolver(final Class<T> targetType) {
        StringValueResolver r = this.resolvers.get(targetType);
        if (null == r && Enum.class.isAssignableFrom(targetType)) {
            final Class clazz = (Class)$.cast(targetType);
            r = this.app().config().enumResolvingExactMatch() ? new StringValueResolver<T>(targetType){

                public T resolve(String value) {
                    if (null == value) {
                        return null;
                    }
                    return Enum.valueOf(clazz, value);
                }
            } : new StringValueResolver<T>(targetType){

                public T resolve(String value) {
                    if (null == value) {
                        return null;
                    }
                    Enum result = $.asEnum((Class)clazz, (String)value);
                    E.illegalArgumentIf((null == result ? 1 : 0) != 0, (String)("No matching enum value of " + targetType.getCanonicalName() + " by string: " + value));
                    return result;
                }
            };
            this.resolvers.put(targetType, r);
        }
        return r;
    }

    public <T> StringValueResolver<T> resolver(Class<T> targetType, AnnotationAware annotationAware) {
        StringValueResolver resolver = this.resolver(targetType);
        if (null != resolver) {
            resolver = resolver.amended(annotationAware);
        }
        return resolver;
    }

    private void registerPredefinedResolvers() {
        this.resolvers.putAll(StringValueResolver.predefined());
    }

    private void registerBuiltInResolvers(AppConfig config) {
        this.put(ISObject.class, SObjectResolver.INSTANCE);
    }

    private void put(Class type, StringValueResolver resolver) {
        this.app().registerSingleton(resolver);
        this.resolvers.put(type, resolver);
    }
}

