/*
 * Decompiled with CFR 0.152.
 */
package act.cli;

import act.app.ActionContext;
import act.app.App;
import act.cli.CliException;
import act.cli.CliSession;
import act.cli.ReportProgress;
import act.cli.ascii_table.ASCIITableHeader;
import act.cli.ascii_table.impl.SimpleASCIITableImpl;
import act.cli.ascii_table.spec.IASCIITable;
import act.cli.ascii_table.spec.IASCIITableAware;
import act.cli.builtin.Exit;
import act.cli.builtin.Help;
import act.cli.util.CommandLineParser;
import act.handler.CliHandler;
import act.util.ActContext;
import act.util.ProgressGauge;
import act.util.PropertySpec;
import act.util.SimpleProgressGauge;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import jline.console.ConsoleReader;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarStyle;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.cache.CacheService;
import org.osgl.concurrent.ContextLocal;
import org.osgl.http.H;
import org.osgl.inject.util.AnnotationUtil;
import org.osgl.util.E;
import org.osgl.util.S;
import org.xnio.streams.WriterOutputStream;

public class CliContext
extends ActContext.Base<CliContext>
implements IASCIITable {
    public static final String ATTR_PWD = "__act_pwd__";
    private static final ContextLocal<CliContext> _local = $.contextLocal();
    private CliSession session;
    private String commandPath;
    private Map<String, Object> commanderInstances = new HashMap<String, Object>();
    private ConsoleReader console;
    private PrintWriter pw;
    private CommandLineParser parser;
    private IASCIITable asciiTable;
    private CacheService evaluatorCache;
    private ParsingContext parsingContext;
    private CliHandler handler;
    private boolean rawPrint;
    private Map<String, String> preparsedOptionValues;

    public CliContext(String line, App app, ConsoleReader console, CliSession session) {
        this(line, app, console, session, null == System.getenv("cli-no-raw-print"));
    }

    protected CliContext(String line, App app, ConsoleReader console, CliSession session, boolean rawPrint) {
        super(app);
        this.session = session;
        this.parser = new CommandLineParser(line);
        this.evaluatorCache = app.cache();
        this.console = (ConsoleReader)$.NPE((Object)console);
        this.pw = new PrintWriter(console.getOutput());
        this.rawPrint = rawPrint;
        this.handler = app.cliDispatcher().handler(this.command());
        this.preparsedOptionValues = new HashMap<String, String>();
        this.saveLocal();
    }

    public void prompt(String prompt) {
        this.console.setPrompt(prompt);
    }

    public void prepare(ParsingContext ctx) {
        this.parsingContext = ctx.copy();
    }

    public ParsingContext parsingContext() {
        return this.parsingContext;
    }

    public void resetPrompt() {
        this.prompt("act[" + this.session.id() + "]>");
    }

    public CacheService evaluatorCache() {
        return this.evaluatorCache;
    }

    public CommandLineParser commandLine() {
        return this.parser;
    }

    public String command() {
        return this.parser.command();
    }

    public List<String> arguments() {
        return this.parser.arguments();
    }

    public CliSession session() {
        return this.session;
    }

    public CliContext session(String key, Object val) {
        this.session().attribute(key, val);
        return this;
    }

    public <T> T session(String key) {
        return this.session().attribute(key);
    }

    @Override
    public String sessionId() {
        return this.session().id();
    }

    public Set<String> paramKeys() {
        return this.preparsedOptionValues.keySet();
    }

    public void param(String key, String val) {
        this.preparsedOptionValues.put(key, val);
    }

    public String paramVal(String key) {
        String s = this.preparsedOptionValues.get(key);
        if (null == s) {
            s = this.parser.getOptions().get(S.concat((String)"--", (String)key));
        }
        return s;
    }

    public String[] paramVals(String key) {
        return new String[]{this.paramVal(key)};
    }

    public File curDir() {
        File file = (File)this.session().attribute(ATTR_PWD);
        if (null == file) {
            file = new File(System.getProperty("user.dir"));
            this.session().attribute(ATTR_PWD, file);
        }
        return file;
    }

    public CliContext chDir(File dir) {
        E.illegalArgumentIf((!dir.isDirectory() ? 1 : 0) != 0);
        this.session().attribute(ATTR_PWD, dir);
        return this;
    }

    @Override
    public CliContext accept(H.Format fmt) {
        throw E.unsupport();
    }

    @Override
    public H.Format accept() {
        throw E.unsupport();
    }

    public void flush() {
        this.pw.flush();
    }

    public boolean disconnected() {
        return this.pw.checkError();
    }

    public void print(ProgressGauge progressGauge) {
        ReportProgress.Type type;
        ReportProgress reportProgress = (ReportProgress)this.attribute("__act_report_progress__");
        if (null == reportProgress) {
            reportProgress = (ReportProgress)AnnotationUtil.createAnnotation(ReportProgress.class);
        }
        if (ReportProgress.Type.BAR == (type = reportProgress.type())) {
            this.printBar(progressGauge);
        } else {
            this.printText(progressGauge);
        }
    }

    public void printBar(ProgressGauge progressGauge) {
        PrintStream os = new PrintStream((OutputStream)new WriterOutputStream(this.rawPrint ? this.pw : this.console.getOutput()));
        String label = this.app().config().i18nEnabled() ? this.i18n("act.progress.capFirst", new Object[0]) : "Progress";
        ProgressBar pb = new ProgressBar(label, progressGauge.maxHint(), 200, os, ProgressBarStyle.UNICODE_BLOCK);
        pb.start();
        while (!progressGauge.isDone()) {
            pb.maxHint(progressGauge.maxHint());
            pb.stepTo(progressGauge.currentSteps());
            this.flush();
        }
        pb.stepTo(pb.getMax());
        pb.stop();
    }

    public void printText(ProgressGauge progressGauge) {
        SimpleProgressGauge simpleProgressGauge = SimpleProgressGauge.wrap(progressGauge);
        boolean i18n = this.app().config().i18nEnabled();
        while (!progressGauge.isDone()) {
            if (i18n) {
                this.print("\r" + this.i18n("act.progress.report", simpleProgressGauge.currentProgressPercent()), new Object[0]);
            } else {
                this.print("\rCurrent progress: " + simpleProgressGauge.currentProgressPercent() + "%", new Object[0]);
            }
            this.flush();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.print("Interrupted", new Object[0]);
                break;
            }
        }
        this.println();
    }

    public void print(String template, Object ... args) {
        if (this.rawPrint) {
            this.print1(template, args);
        } else {
            this.print0(template, args);
        }
    }

    void handle() throws IOException {
        CommandLineParser parser;
        boolean help;
        if (null == this.handler) {
            this.println("Command not recognized: %s", this.command());
            return;
        }
        if (this.handler == Exit.INSTANCE) {
            this.handler.handle(this);
        }
        if (help = (parser = this.commandLine()).getBoolean("-h", "--help")) {
            Help.INSTANCE.showHelp(parser.command(), this);
        } else {
            try {
                this.session.handler(this.handler);
                this.handler.handle(this);
            }
            catch (Lang.Break b) {
                throw b;
            }
            catch (Exception e) {
                this.console.println((CharSequence)("Error: " + e.getMessage()));
            }
        }
    }

    private void print0(String template, Object ... args) {
        try {
            this.console.print((CharSequence)S.fmt((String)template, (Object[])args));
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    private void print1(String template, Object ... args) {
        if (args.length == 0) {
            this.pw.print(template);
        } else {
            this.pw.printf(CliContext.osNative(template), args);
        }
    }

    private void println0(String template, Object ... args) {
        try {
            if (args.length > 0) {
                template = S.fmt((String)template);
            }
            this.console.println((CharSequence)template);
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    @Override
    public void println() {
        if (this.rawPrint) {
            this.println1("", new Object[0]);
        } else {
            this.println0("", new Object[0]);
        }
    }

    public void println(String template, Object ... args) {
        if (this.rawPrint) {
            this.println1(template, args);
        } else {
            this.println0(template, args);
        }
    }

    private void println1(String template, Object ... args) {
        if (args.length == 0) {
            this.pw.print(template);
        } else {
            this.pw.printf(CliContext.osNative(template), args);
        }
        this.pw.println();
    }

    @Override
    protected void releaseResources() {
        super.releaseResources();
        _local.remove();
        PropertySpec.current.remove();
    }

    public String commandPath() {
        return this.commandPath;
    }

    public CliContext commandPath(String path) {
        this.commandPath = path;
        return this;
    }

    @Override
    public String methodPath() {
        return this.commandPath;
    }

    public CliContext __commanderInstance(String className, Object instance) {
        if (null == this.commanderInstances) {
            this.commanderInstances = new HashMap<String, Object>();
        }
        this.commanderInstances.put(className, instance);
        return this;
    }

    public Object __commanderInstance(String className) {
        return null == this.commanderInstances ? null : this.commanderInstances.get(className);
    }

    @Override
    public <T> T renderArg(String name) {
        return super.renderArg(name);
    }

    @Override
    public CliContext renderArg(String name, Object val) {
        return (CliContext)super.renderArg(name, val);
    }

    @Override
    public Map<String, Object> renderArgs() {
        return super.renderArgs();
    }

    private synchronized IASCIITable tbl() {
        if (this.asciiTable == null) {
            this.asciiTable = new SimpleASCIITableImpl(new PrintWriter(this.console.getOutput()));
        }
        return this.asciiTable;
    }

    @Override
    public void printTable(String[] header, String[][] data) {
        this.tbl().printTable(header, data);
    }

    @Override
    public void printTable(String[] header, String[][] data, int dataAlign) {
        this.tbl().printTable(header, data, dataAlign);
    }

    @Override
    public void printTable(String[] header, int headerAlign, String[][] data, int dataAlign) {
        this.tbl().printTable(header, headerAlign, data, dataAlign);
    }

    @Override
    public void printTable(ASCIITableHeader[] headerObjs, String[][] data) {
        this.tbl().printTable(headerObjs, data);
    }

    @Override
    public void printTable(IASCIITableAware asciiTableAware) {
        this.tbl().printTable(asciiTableAware);
    }

    @Override
    public String getTable(String[] header, String[][] data) {
        return this.tbl().getTable(header, data);
    }

    @Override
    public String getTable(String[] header, String[][] data, int dataAlign) {
        return this.tbl().getTable(header, data, dataAlign);
    }

    @Override
    public String getTable(String[] header, int headerAlign, String[][] data, int dataAlign) {
        return this.tbl().getTable(header, headerAlign, data, dataAlign);
    }

    @Override
    public String getTable(ASCIITableHeader[] headerObjs, String[][] data) {
        return this.tbl().getTable(headerObjs, data);
    }

    @Override
    public String getTable(IASCIITableAware asciiTableAware) {
        return this.tbl().getTable(asciiTableAware);
    }

    public File getFile(String path) {
        File file;
        if (path.startsWith("~/")) {
            path = System.getProperty("user.home") + path.substring(1);
        }
        if ((file = new File(path)).isAbsolute()) {
            return file;
        }
        file = new File(this.curDir(), path);
        return new File(file.getAbsolutePath());
    }

    private void saveLocal() {
        _local.set((Object)this);
    }

    private void initOverHttp(ActionContext actionContext) {
    }

    public static CliContext current() {
        return (CliContext)_local.get();
    }

    private static String osNative(String s) {
        s = s.replace("\n\r", "\n");
        s = s.replace("\r", "\n");
        if ("\n".equals($.OS.lineSeparator())) {
            return s;
        }
        s = s.replace("\n", $.OS.lineSeparator());
        return s;
    }

    public static class ParsingContextBuilder {
        private static final ThreadLocal<ParsingContext> ctx = new ThreadLocal();

        public static void start() {
            ParsingContext ctx0 = new ParsingContext();
            ctx0.required = new HashMap<String, AtomicInteger>();
            ctx.set(ctx0);
        }

        public static void foundOptional() {
            ctx.get().optionArgumentsCnt++;
        }

        public static void foundArgument() {
            ctx.get().optionArgumentsCnt++;
        }

        public static void foundRequired(String group) {
            ParsingContext ctx0 = ctx.get();
            ctx0.optionArgumentsCnt++;
            ctx0.required.put(group, new AtomicInteger(0));
        }

        public static ParsingContext finish() {
            ParsingContext ctx0 = ctx.get();
            ctx.remove();
            return ctx0;
        }
    }

    public static class ParsingContext {
        private int optionArgumentsCnt;
        private AtomicInteger curArgId;
        Map<String, AtomicInteger> required;

        private ParsingContext() {
        }

        public AtomicInteger curArgId() {
            return this.curArgId;
        }

        public boolean hasArguments(CommandLineParser command) {
            return this.curArgId.get() < command.argumentCount();
        }

        public void foundRequired(String group) {
            this.required.get(group).incrementAndGet();
        }

        public boolean hasMultipleOptionArguments() {
            return this.optionArgumentsCnt > 1;
        }

        public Set<String> missingOptions() {
            HashSet<String> set = new HashSet<String>();
            for (Map.Entry<String, AtomicInteger> entry : this.required.entrySet()) {
                if (entry.getValue().get() >= 1) continue;
                set.add(entry.getKey());
            }
            return set;
        }

        public void raiseExceptionIfThereAreMissingOptions(CliContext context) {
            Set<String> missings = this.missingOptions();
            int missing = missings.size();
            switch (missing) {
                case 0: {
                    return;
                }
                case 1: {
                    if (context.arguments().isEmpty()) break;
                    return;
                }
            }
            throw new CliException("Missing required options: %s", missings);
        }

        public ParsingContext copy() {
            ParsingContext ctx = new ParsingContext();
            ctx.optionArgumentsCnt = this.optionArgumentsCnt;
            ctx.required = new HashMap<String, AtomicInteger>(this.required);
            for (Map.Entry<String, AtomicInteger> entry : ctx.required.entrySet()) {
                entry.setValue(new AtomicInteger(0));
            }
            ctx.curArgId = new AtomicInteger(0);
            return ctx;
        }
    }
}

