/*
 * Decompiled with CFR 0.152.
 */
package act.cli.util;

import act.cli.CliContext;
import act.cli.util.CliCursor;
import act.cli.view.CliView;
import act.util.PropertySpec;
import java.util.List;
import org.osgl.util.C;

public class TableCursor
implements CliCursor {
    private List data;
    private int pageSize;
    private int pageNo;
    private PropertySpec.MetaInfo propertySpec;

    public TableCursor(List data, int pageSize, PropertySpec.MetaInfo propertySpec) {
        this.data = data;
        this.pageSize = pageSize;
        this.propertySpec = propertySpec;
    }

    private List get() {
        int history;
        if ((history = this.pageSize * this.pageNo++) >= this.data.size()) {
            return C.list();
        }
        return C.list((List)this.data).drop(history).take(this.pageSize);
    }

    @Override
    public boolean hasNext() {
        return this.pageSize * this.pageNo < this.data.size();
    }

    @Override
    public void output(CliContext context) {
        List list = this.get();
        if (list.isEmpty()) {
            context.session().removeCursor();
            context.println("no cursor", new Object[0]);
            return;
        }
        CliView.TABLE.print(list, this.propertySpec, context);
    }

    @Override
    public int records() {
        return this.data.size();
    }
}

