/*
 * Decompiled with CFR 0.152.
 */
package act.conf;

import act.conf.ActConfigKey;
import act.conf.Config;
import act.conf.ConfigKey;
import java.io.File;
import java.net.URI;
import java.util.Map;
import org.osgl.util.E;

public class ActConfig
extends Config<ActConfigKey> {
    public static final String CONF_FILE_NAME = "act.conf";
    private File home = null;
    private File appBase = null;
    private Integer xioMaxWorkerThreads;
    private Boolean xioStatistics;

    public ActConfig(Map<String, ?> configuration) {
        super(configuration);
    }

    public ActConfig() {
        this(System.getProperties());
    }

    @Override
    protected ConfigKey keyOf(String s) {
        return ActConfigKey.valueOfIgnoreCase(s);
    }

    public File home() {
        if (null == this.home) {
            URI uri = this.get(ActConfigKey.HOME, null);
            if (null == uri) {
                E.invalidConfiguration((String)"valid act.home.dir expected", (Object[])new Object[0]);
            }
            this.home = new File(uri.getPath());
            ActConfig.validateDir(this.home, ActConfigKey.HOME.key());
        }
        return this.home;
    }

    public File appBase() {
        if (null == this.appBase) {
            String s = this.get(ActConfigKey.APP_BASE, null);
            this.appBase = new File(this.home(), s);
            ActConfig.validateDir(this.appBase, ActConfigKey.APP_BASE.key());
        }
        return this.appBase;
    }

    public int xioMaxWorkerThreads() {
        if (null == this.xioMaxWorkerThreads) {
            this.xioMaxWorkerThreads = this.get(ActConfigKey.XIO_MAX_WORKER_THREADS, 0);
        }
        return this.xioMaxWorkerThreads;
    }

    public boolean xioStatistics() {
        if (null == this.xioStatistics) {
            this.xioStatistics = this.get(ActConfigKey.XIO_STATISTICS, false);
        }
        return this.xioStatistics;
    }

    private static void validateDir(File dir, String conf) {
        if (!(dir.exists() && dir.isDirectory() && dir.canRead())) {
            E.invalidConfiguration((String)"%s is not a valid directory: %s", (Object[])new Object[]{conf, dir.getAbsolutePath()});
        }
    }
}

