/*
 * Decompiled with CFR 0.152.
 */
package act.conf;

import act.Act;
import act.app.App;
import act.conf.Config;
import act.conf.ConfigKey;
import act.conf.ConfigKeyHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.E;
import org.osgl.util.S;

public enum AppConfigKey implements ConfigKey
{
    API_DOC_EABLED("api_doc.enabled"),
    API_DOC_HIDE_BUILT_IN_ENDPOINTS("api_doc.built_in.hide.enabled"),
    BASIC_AUTHENTICATION("basic_authentication.enabled"),
    BUILT_IN_REQ_HANDLER_ENABLED("built_in_req_handler.enabled"),
    CACHE_IMPL("cache.impl"),
    CACHE_NAME("cache.name"),
    CACHE_NAME_SESSION("cache.name.session"),
    CACHE_FOR_ON_DEV("cacheFor.dev"),
    CLI_ENABLED("cli.enabled"),
    CLI_PORT("cli.port"),
    CLI_PAGE_SIZE_JSON("cli.page.size.json"),
    CLI_PAGE_SIZE_TABLE("cli.page.size.table"),
    CLI_SESSION_TTL("cli.session.ttl.int"),
    CLI_SESSION_MAX("cli.session.max.int"),
    CLI_OVER_HTTP("cli_over_http.enabled"),
    CLI_OVER_HTTP_AUTHORITY("cli_over_http.authority.impl"),
    CLI_OVER_HTTP_PORT("cli_over_http.port"),
    CLI_OVER_HTTP_TITLE("cli_over_http.title"),
    CLI_OVER_HTTP_SYS_CMD("cli_over_http.syscmd.enabled"),
    COOKIE_DOMAIN_PROVIDER("cookie.domain_provider.impl"),
    COOKIE_PREFIX("cookie.prefix"),
    CORS("cors.enabled"),
    CORS_CHECK_OPTION_METHOD("cors.option.check.enabled"),
    CORS_ORIGIN("cors.origin"),
    CORS_HEADERS("cors.headers"),
    CORS_HEADERS_EXPOSE("cors.headers.expose"),
    CORS_HEADERS_ALLOWED("cors.headers.allowed"),
    CORS_MAX_AGE("cors.max_age"),
    CORS_ALLOW_CREDENTIALS("cors.allow_credentials.enabled"),
    CONTENT_SUFFIX_AWARE("content_suffix.aware.enabled"),
    CONTENT_SECURITY_POLICY("csp"),
    CSRF("csrf.enabled"),
    CSRF_PARAM_NAME("csrf.param_name"),
    CSRF_HEADER_NAME("csrf.header_name"),
    CSRF_COOKIE_NAME("csrf.cookie_name"),
    CSRF_PROTECTOR("csrf.protector.impl"),
    DB_SEQ_GENERATOR("db.seq_gen.impl"),
    DOUBLE_SUBMISSION_PROTECT_TOKEN("dsp.token"),
    ENCODING("encoding"),
    ENUM_RESOLVING_CASE_SENSITIVE("enum.resolving.case_sensitive"),
    ENUM_RESOLVING_EXACT_MATCH("enum.resolving.exact_match"),
    FORMAT_DATE("fmt.date"),
    FORMAT_DATE_TIME("fmt.date_time"),
    FORMAT_TIME("fmt.time"),
    HANDLER_CSRF_CHECK_FAILURE("handler.csrf_check_failure.impl"),
    HANDLER_AJAX_CSRF_CHECK_FAILURE("handler.csrf_check_failure.ajax.impl"),
    HANDLER_MISSING_AUTHENTICATION("handler.missing_authentication.impl"),
    HANDLER_MISSING_AUTHENTICATION_AJAX("handler.missing_authentication.ajax.impl"),
    HANDLER_UNKNOWN_HTTP_METHOD("handler.unknown_http_method.impl"),
    HEADER_SESSION_EXPIRATION("header.session.expiration"),
    HOST("host"),
    HTTP_EXTERNAL_SERVER("http.external_server.enabled"),
    HTTP_MAX_PARAMS("http.params.max"),
    HTTP_PORT("http.port"),
    HTTP_EXTERNAL_PORT("http.port.external"),
    HTTP_EXTERNAL_SECURE_PORT("http.port.external.secure"),
    HTTP_SECURE("http.secure.enabled"),
    HTTPS_PORT("https.port"),
    I18N("i18n.enabled"),
    I18N_LOCALE_PARAM_NAME("i18n.locale.param_name"),
    I18N_LOCALE_COOKIE_NAME("i18n.locale.cookie_name"),
    ID_GEN_NODE_ID_PROVIDER("idgen.node_id.provider.impl"),
    ID_GEN_NODE_ID_EFFECTIVE_IP_BYTES("idgen.node_id.effective_ip_bytes.size"),
    ID_GEN_START_ID_PROVIDER("idgen.start_id.provider.impl"),
    ID_GEN_START_ID_FILE("idgen.start_id.file"),
    ID_GEN_SEQ_ID_PROVIDER("idgen.seq_id.provider.impl"),
    ID_GEN_LONG_ENCODER("idgen.encoder.impl"),
    JOB_POOL_SIZE("job.pool.size"),
    JWT("jwt.enabled"),
    JWT_ALGO("jwt.algo"),
    JWT_ISSUER("jwt.issuer"),
    LOCALE("locale"){

        @Override
        public <T> T val(Map<String, ?> configuration) {
            Object o = super.val(configuration);
            if (null == o) {
                return null;
            }
            if (o instanceof String) {
                return (T)Locale.forLanguageTag((String)o);
            }
            if (o instanceof Locale) {
                return o;
            }
            String s = o.toString();
            return (T)Locale.forLanguageTag(s);
        }
    }
    ,
    METRIC_ENABLED("metric.enabled"),
    MODULES("modules"),
    NAMED_PORTS("namedPorts"),
    OSGL_THREADLOCAL_BUF_LIMIT("threadlocal_buf.limit"),
    PASSWORD_DEF_SPEC("password.spec"),
    PING_PATH("ping.path"),
    PROFILE("profile"),
    REQUEST_THROTTLE("req.throttle.int"),
    REQUEST_THROTTLE_EXPIRE_SCALE("req.throttle.expire.scale.enabled"),
    RENDER_JSON_OUTPUT_CHARSET("render.json.output_charset.enabled"),
    RENDER_JSON_CONTENT_TYPE_IE("render.json.content_type.ie"),
    RESOLVER_ERROR_TEMPLATE_PATH("resolver.error_template_path.impl"),
    RESOLVER_TEMPLATE_PATH("resolver.template_path.impl"),
    RESOURCE_PRELOAD_SIZE_LIMIT("resource.preload.size.limit.int"),
    SCAN_PACKAGE("scan_package"),
    SCAN_PACKAGE_SYS("scan_package.sys"),
    SECRET("secret"),
    SECRET_ROTATE("secret.rotate.enabled"),
    SECRET_ROTATE_PERIOD("secret.rotate.period"),
    SECURE_TICKET_CODEC("secure_ticket_codec"),
    SERVER_HEADER("server.header"),
    SESSION_OUTPUT_EXPIRATION("session.outputExpiration.enabled"),
    SESSION_TTL("session.ttl"),
    SESSION_PERSISTENT_ENABLED("session.persistent.enabled"),
    SESSION_ENCRYPT_ENABLED("session.encrypt.enabled"),
    SESSION_KEY_USERNAME("session.key.username"),
    SESSION_MAPPER("session.mapper.impl"),
    SESSION_CODEC("session.codec.impl"),
    SESSION_MAPPER_HEADER_PREFIX("session.mapper.header.prefix"),
    SESSION_HEADER("session.header"),
    SESSION_HEADER_PREFIX("session.header.prefix"),
    SESSION_HEADER_PAYLOAD_PREFIX("session.header.payload.prefix"),
    SESSION_SECURE("session.secure.enabled"),
    SOURCE_VERSION("source.version"),
    SSL("ssl.enabled"),
    TARGET_VERSION("target.version"),
    TEMPLATE_HOME("template.home"),
    TRACE_HANDLER_ENABLED("trace.handler.enabled"),
    TRACE_REQUEST_ENABLED("trace.request.enabled"),
    UPLOAD_IN_MEMORY_CACHE_THRESHOLD("upload.in_memory.threshold.int"),
    URL_CONTEXT("url.context"),
    URL_LOGIN("url.login"),
    URL_LOGIN_AJAX("url.login.ajax"),
    VIEW_DEFAULT("view.default"),
    WS_KEY_TICKET("ws.key.ticket"),
    X_FORWARD_PROTOCOL("x_forward_protocol");

    private String key;
    private Object defVal;
    static ConfigKeyHelper helper;
    private static Map<String, AppConfigKey> lookup;

    private AppConfigKey(String key) {
        this(key, (Object)null);
    }

    private AppConfigKey(String key, Object defVal) {
        this.key = Config.canonical(key);
        this.defVal = defVal;
    }

    public static void onApp(final App app) {
        helper.classLoaderProvider(new Lang.F0<ClassLoader>(){

            public ClassLoader apply() throws NotAppliedException, Lang.Break {
                return app.classLoader();
            }
        });
    }

    @Override
    public String key() {
        return this.key;
    }

    protected Object getDefVal(Map<String, ?> configuration) {
        return this.defVal;
    }

    public String toString() {
        return this.key;
    }

    @Override
    public Object defVal() {
        return this.defVal;
    }

    @Override
    public <T> List<T> implList(String key, Map<String, ?> configuration, Class<T> c) {
        return helper.getImplList(key, configuration, c);
    }

    @Override
    public <T> T val(Map<String, ?> configuration) {
        return helper.getConfiguration(this, configuration);
    }

    public static AppConfigKey valueOfIgnoreCase(String s) {
        E.illegalArgumentIf((boolean)S.blank((String)s), (String)"config key cannot be empty");
        return lookup.get(Config.canonical(s));
    }

    static {
        helper = new ConfigKeyHelper(Act.F.MODE_ACCESSOR);
        lookup = new HashMap<String, AppConfigKey>(50);
        Set<String> suffixes = ConfigKeyHelper.suffixes();
        Set<String> nonAliasSuffixes = ConfigKeyHelper.nonAliasSuffixes();
        for (AppConfigKey k : AppConfigKey.values()) {
            lookup.put(k.name().toUpperCase(), k);
            String key = k.key().toUpperCase();
            lookup.put(key, k);
            String suffix = S.afterLast((String)key, (String)".");
            if (!S.notBlank((String)suffix) || !suffixes.contains(suffix) || nonAliasSuffixes.contains(suffix)) continue;
            Set<String> aliases = ConfigKeyHelper.aliases(key, suffix);
            for (String alias : aliases) {
                lookup.put(Config.canonical(alias), k);
            }
        }
    }
}

