/*
 * Decompiled with CFR 0.152.
 */
package act.conf;

import act.Act;
import act.conf.Config;
import act.conf.ConfigKey;
import java.io.File;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.ConfigurationException;
import org.osgl.exception.NotAppliedException;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.S;

class ConfigKeyHelper {
    private static Logger logger = L.get(ConfigKeyHelper.class);
    private Lang.F0<Act.Mode> mode;
    private Lang.F0<ClassLoader> classLoaderProvider;
    private static final Set<String> SUFFIXES = C.set((Collection)S.fastSplit((String)"enabled,disabled,impl,dir,home,path,bool,boolean,long,ttl,port,int,len,count,times,size,float,double", (String)","));
    private static final Set<String> NON_ALIAS_SUFFIXES = C.set((Collection)S.fastSplit((String)"dir,home,path,ttl,port,len,count,times,size", (String)","));

    public ConfigKeyHelper(Lang.F0<Act.Mode> mode, final ClassLoader cl) {
        this.mode = mode;
        this.classLoaderProvider = new Lang.F0<ClassLoader>(){

            public ClassLoader apply() throws NotAppliedException, Lang.Break {
                return cl;
            }
        };
    }

    public ConfigKeyHelper(Lang.F0<Act.Mode> mode) {
        this.mode = mode;
    }

    ConfigKeyHelper classLoaderProvider(Lang.F0<ClassLoader> provider) {
        this.classLoaderProvider = provider;
        return this;
    }

    <T> T getConfiguration(final ConfigKey confKey, Map<String, ?> configuration) {
        String key = confKey.key();
        Lang.F0<Object> defVal = new Lang.F0<Object>(){

            public Object apply() throws NotAppliedException, Lang.Break {
                return confKey.defVal();
            }
        };
        return this.getConfiguration(key, defVal, configuration);
    }

    <T> T getConfiguration(String key, Lang.F0<?> defVal, Map<String, ?> configuration) {
        if ((key = Config.canonical(key)).endsWith(".enabled") || key.endsWith(".disabled")) {
            String key0 = S.beforeLast((String)key, (String)".");
            Boolean B = this.getEnabled(key0, configuration, defVal);
            if (null == B) {
                return null;
            }
            if (key.endsWith(".disabled")) {
                B = B == false;
            }
            return (T)B;
        }
        if (key.endsWith(".impl")) {
            return this.getImpl(configuration, key, this.suffixOf(key), defVal);
        }
        if (key.endsWith(".dir") || key.endsWith(".home") || key.endsWith(".path")) {
            return (T)this.getUri(configuration, key, this.suffixOf(key), defVal);
        }
        if (key.endsWith(".bool") || key.endsWith(".boolean")) {
            return (T)this.getX(configuration, key, this.suffixOf(key), defVal, F.TO_BOOLEAN);
        }
        if (key.endsWith(".long")) {
            return (T)this.getX(configuration, key, this.suffixOf(key), defVal, F.TO_LONG);
        }
        if (key.endsWith(".int") || key.endsWith(".ttl") || key.endsWith(".len") || key.endsWith(".count") || key.endsWith(".times") || key.endsWith(".size") || key.endsWith(".port")) {
            return (T)this.getX(configuration, key, this.suffixOf(key), defVal, F.TO_INT);
        }
        if (key.endsWith(".float")) {
            return (T)this.getX(configuration, key, this.suffixOf(key), defVal, F.TO_FLOAT);
        }
        if (key.endsWith(".double")) {
            return (T)this.getX(configuration, key, this.suffixOf(key), defVal, F.TO_DOUBLE);
        }
        return (T)this.getValFromAliases(configuration, key, null, defVal);
    }

    static Set<String> suffixes() {
        return SUFFIXES;
    }

    static Set<String> nonAliasSuffixes() {
        return NON_ALIAS_SUFFIXES;
    }

    <T> List<T> getImplList(String key, Map<String, ?> configuration, Class<T> c) {
        Object v = this.getValFromAliases(configuration, key, "impls", null);
        if (null == v) {
            return Collections.EMPTY_LIST;
        }
        boolean needClass = Class.class.isAssignableFrom(c);
        ArrayList<Object> l = new ArrayList<Object>();
        Class<?> vc = v.getClass();
        if (c.isAssignableFrom(vc)) {
            l.add(v);
            return l;
        }
        if (v instanceof Class) {
            if (needClass) {
                l.add(v);
            } else {
                T inst = ConfigKeyHelper.newInstance(key, (Class)v, c);
                if (null != inst) {
                    l.add(inst);
                }
            }
            return l;
        }
        if (vc.isArray()) {
            int len = Array.getLength(v);
            for (int i = 0; i < len; ++i) {
                T inst;
                Object el = Array.get(v, i);
                if (null == el) continue;
                Class<?> elc = el.getClass();
                if (c.isAssignableFrom(elc)) {
                    l.add(el);
                    continue;
                }
                if (el instanceof Class) {
                    if (needClass) {
                        l.add(el);
                        continue;
                    }
                    inst = ConfigKeyHelper.newInstance(key, (Class)el, c);
                    if (null == inst) continue;
                    l.add(inst);
                    continue;
                }
                try {
                    elc = Class.forName(el.toString());
                    if (needClass) {
                        l.add(elc);
                        continue;
                    }
                    inst = ConfigKeyHelper.newInstance(key, elc, c);
                    if (null == inst) continue;
                    l.add(inst);
                    continue;
                }
                catch (Exception e) {
                    logger.warn((Throwable)e, "Error getting impl class out from %s for configuration %s", new Object[]{el, key});
                }
            }
            return l;
        }
        if (Collection.class.isAssignableFrom(vc)) {
            Collection col = (Collection)v;
            for (Object el : col) {
                T inst;
                if (null == el) continue;
                Class<?> elc = el.getClass();
                if (c.isAssignableFrom(elc)) {
                    l.add(el);
                    continue;
                }
                if (el instanceof Class) {
                    if (needClass) {
                        l.add(el);
                        continue;
                    }
                    inst = ConfigKeyHelper.newInstance(key, (Class)el, c);
                    if (null == inst) continue;
                    l.add(inst);
                    continue;
                }
                try {
                    elc = Class.forName(el.toString());
                    if (needClass) {
                        l.add(elc);
                        continue;
                    }
                    inst = ConfigKeyHelper.newInstance(key, elc, c);
                    if (null == inst) continue;
                    l.add(inst);
                }
                catch (Exception e) {
                    logger.warn((Throwable)e, "Error getting impl class out from %s for configuration %s", new Object[]{el, key});
                }
            }
            return l;
        }
        for (String s : v.toString().split("[ \t,;]+")) {
            try {
                Class<?> ec = Class.forName(s);
                if (needClass) {
                    l.add(ec);
                    continue;
                }
                T inst = ConfigKeyHelper.newInstance(key, ec, c);
                if (null == inst) continue;
                l.add(inst);
            }
            catch (Exception e) {
                logger.warn((Throwable)e, "Error getting impl class out from %s for configuration %s", new Object[]{s, key});
            }
        }
        return l;
    }

    <T> T getX(Map<String, ?> configuration, String key, String suffix, Lang.F0<?> defVal, Lang.Func1<Object, T> converter) {
        Object v = this.getValFromAliases(configuration, key, suffix, defVal);
        return (T)converter.apply(v);
    }

    private Boolean getEnabled(String key, Map<String, ?> configuration, Lang.F0<?> defVal) {
        Object v = this.getValFromAliases(configuration, key, "enabled", defVal);
        if (null == v) {
            v = this.getValFromAliases(configuration, key, "disabled", defVal);
            return null == v ? null : Boolean.valueOf(ConfigKeyHelper.toBoolean(v) == false);
        }
        return ConfigKeyHelper.toBoolean(v);
    }

    private ClassLoader myClassLoader() {
        return (ClassLoader)this.classLoaderProvider.apply();
    }

    <T> T getImpl(Map<String, ?> configuration, String key, String suffix, Lang.F0<?> defVal) {
        Object v = this.getValFromAliases(configuration, key, "impl", defVal);
        if (null == v) {
            return null;
        }
        if (v instanceof Class) {
            try {
                return (T)$.newInstance((Class)((Class)v), (Object)this.myClassLoader());
            }
            catch (Exception e) {
                throw new ConfigurationException((Throwable)e, "Error getting implementation configuration: %s", new Object[]{key});
            }
        }
        if (!(v instanceof String)) {
            return (T)v;
        }
        String clsName = (String)v;
        try {
            return (T)$.newInstance((String)clsName, (ClassLoader)this.myClassLoader());
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e, "Error getting implementation configuration: %s", new Object[]{key});
        }
    }

    private URI getUri(Map<String, ?> configuration, String key, String suffix, Lang.F0<?> defVal) {
        Object v = this.getValFromAliases(configuration, key, suffix, defVal);
        if (null == v) {
            return null;
        }
        if (v instanceof File) {
            return ((File)v).toURI();
        }
        String s = v.toString();
        return ConfigKeyHelper.asUri(s, key);
    }

    private static URI asUri(String s, String key) {
        boolean isAbsolute = false;
        if (s.startsWith("/") || s.startsWith(File.separator)) {
            isAbsolute = true;
        } else if (s.matches("^[a-zA-Z]:.*")) {
            isAbsolute = true;
        }
        if (isAbsolute) {
            File f2 = new File(s);
            if (f2.exists() && f2.isDirectory() && f2.canRead()) {
                return f2.toURI();
            }
            return null;
        }
        try {
            if (s.startsWith("..")) {
                URL url = Thread.currentThread().getContextClassLoader().getResource(".");
                if (null == url) {
                    return null;
                }
                String path = url.getPath();
                path = path.endsWith("/") ? path + s : path + "/" + s;
                return new URI(path);
            }
            URL url = Thread.currentThread().getContextClassLoader().getResource(s);
            return null == url ? null : url.toURI();
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e, "Error reading file configuration %s", new Object[]{key});
        }
    }

    private static Boolean toBoolean(Object v) {
        if (null == v) {
            return null;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return Boolean.parseBoolean(v.toString());
    }

    private static Long toLong(Object v) {
        if (null == v) {
            return null;
        }
        if (v instanceof Number) {
            return ((Number)v).longValue();
        }
        return Long.parseLong(v.toString());
    }

    private static Integer toInt(Object v) {
        if (null == v) {
            return null;
        }
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        String s = v.toString();
        if (s.contains("*")) {
            S.List sl = S.fastSplit((String)s, (String)"*");
            int n = 1;
            for (String sn : sl) {
                n *= Integer.parseInt(sn.trim());
            }
            return n;
        }
        return Integer.parseInt(s);
    }

    private static Float toFloat(Object v) {
        if (null == v) {
            return null;
        }
        if (v instanceof Number) {
            return Float.valueOf(((Number)v).floatValue());
        }
        return Float.valueOf(Float.parseFloat(v.toString()));
    }

    private static Double toDouble(Object v) {
        if (null == v) {
            return null;
        }
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        return Double.parseDouble(v.toString());
    }

    private Object getValFromAliases(Map<String, ?> configuration, String key, String suffix) {
        Object v = configuration.get(key);
        if (null == v) {
            String k0;
            Iterator<String> iterator = ConfigKeyHelper.aliases(key, suffix).iterator();
            while (iterator.hasNext() && null == (v = configuration.get(k0 = iterator.next()))) {
            }
        }
        if (null != v && v instanceof String) {
            v = this.evaluate((String)v, configuration);
        }
        return v;
    }

    public String evaluate(String s, Map<String, ?> map) {
        int n = 0;
        int n0 = 0;
        int len = s.length();
        S.Buffer sb = S.newBuffer();
        while (n > -1 && n < len) {
            if ((n = s.indexOf("${", n)) < 0) {
                if (n0 == 0) {
                    return s;
                }
                sb.append(s.substring(n0, len));
                break;
            }
            sb.append(s.substring(n0, n));
            n0 = n += 2;
            n = s.indexOf("}", n0 + 1);
            if (n < 0) {
                logger.warn("Invalid expression found in the configuration value: %s", new Object[]{s});
                return s;
            }
            String expression = s.substring(n0, n);
            if (S.notBlank((String)expression)) {
                Object o = map.get(expression);
                if (null == o) {
                    o = this.getConfiguration(expression, null, map);
                }
                if (null != o) {
                    sb.append(o);
                } else {
                    logger.warn("Cannot find expression value for: %s", new Object[]{expression});
                }
            }
            n0 = ++n;
        }
        return sb.toString();
    }

    private Object getValFromAliasesWithModelPrefix(Map<String, ?> configuration, String key, String suffix) {
        return this.getValFromAliases(configuration, this.mode().configKey(key), suffix);
    }

    Object getValFromAliases(Map<String, ?> configuration, String key, String suffix, Lang.F0<?> defVal) {
        Object v = this.getValFromAliasesWithModelPrefix(configuration, key, suffix);
        if (null != v) {
            return v;
        }
        v = this.getValFromAliases(configuration, key, suffix);
        if (null != v) {
            return v;
        }
        if (null != defVal) {
            v = defVal.apply();
        }
        return v;
    }

    static Set<String> aliases(String key, String suffix) {
        HashSet<String> set = new HashSet<String>();
        set.add("act." + key);
        set.add(key);
        if (S.notBlank((String)suffix) && !ConfigKeyHelper.nonAliasSuffixes().contains(suffix)) {
            if (key.contains(suffix)) {
                String k0 = key.replace("." + suffix, "");
                set.add("act." + k0);
                set.add(k0);
            } else {
                if (!suffix.startsWith(".")) {
                    suffix = "." + suffix;
                }
                String k0 = key + suffix;
                set.add("act." + k0);
                set.add(k0);
            }
        }
        return set;
    }

    private Act.Mode mode() {
        return (Act.Mode)((Object)this.mode.apply());
    }

    private String suffixOf(String key) {
        return S.afterLast((String)key, (String)".");
    }

    private static <T> T newInstance(String key, Class c, Class<T> expectedClass) {
        if (!expectedClass.isAssignableFrom(c)) {
            logger.warn("Mismatched type found for configuration %s", new Object[]{key});
            return null;
        }
        try {
            return c.newInstance();
        }
        catch (Exception e) {
            logger.warn((Throwable)e, "Cannot create new instance for configuration %s", new Object[]{key});
            return null;
        }
    }

    public static enum F {

        public static Lang.Func1<Object, Integer> TO_INT = new Lang.Transformer<Object, Integer>(){

            public Integer transform(Object object) {
                return ConfigKeyHelper.toInt(object);
            }
        };
        public static Lang.Func1<Object, Long> TO_LONG = new Lang.Transformer<Object, Long>(){

            public Long transform(Object object) {
                return ConfigKeyHelper.toLong(object);
            }
        };
        public static Lang.Func1<Object, Float> TO_FLOAT = new Lang.Transformer<Object, Float>(){

            public Float transform(Object object) {
                return ConfigKeyHelper.toFloat(object);
            }
        };
        public static Lang.Func1<Object, Double> TO_DOUBLE = new Lang.Transformer<Object, Double>(){

            public Double transform(Object object) {
                return ConfigKeyHelper.toDouble(object);
            }
        };
        public static Lang.Func1<Object, Boolean> TO_BOOLEAN = new Lang.Transformer<Object, Boolean>(){

            public Boolean transform(Object object) {
                return ConfigKeyHelper.toBoolean(object);
            }
        };
    }
}

