/*
 * Decompiled with CFR 0.152.
 */
package act.controller;

import act.Act;
import act.app.ActionContext;
import act.controller.meta.HandlerMethodMetaInfo;
import act.data.Versioned;
import act.route.Router;
import act.util.$$;
import act.util.ActContext;
import act.util.FastJsonIterable;
import act.util.JsonUtilConfig;
import act.util.PropertySpec;
import act.view.ActBadRequest;
import act.view.ActConflict;
import act.view.ActForbidden;
import act.view.ActNotFound;
import act.view.ActUnauthorized;
import act.view.FilteredRenderXML;
import act.view.RenderAny;
import act.view.RenderCSV;
import act.view.RenderJsonMap;
import act.view.RenderJwt;
import act.view.RenderTemplate;
import act.view.ZXingResult;
import java.io.File;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;
import java.util.Map;
import javax.inject.Inject;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.http.H;
import org.osgl.mvc.result.Accepted;
import org.osgl.mvc.result.BadRequest;
import org.osgl.mvc.result.Conflict;
import org.osgl.mvc.result.Created;
import org.osgl.mvc.result.Forbidden;
import org.osgl.mvc.result.Found;
import org.osgl.mvc.result.MovedPermanently;
import org.osgl.mvc.result.NoContent;
import org.osgl.mvc.result.NotAcceptable;
import org.osgl.mvc.result.NotModified;
import org.osgl.mvc.result.Ok;
import org.osgl.mvc.result.PermanentRedirect;
import org.osgl.mvc.result.Redirect;
import org.osgl.mvc.result.RenderBinary;
import org.osgl.mvc.result.RenderHtml;
import org.osgl.mvc.result.RenderJSON;
import org.osgl.mvc.result.RenderText;
import org.osgl.mvc.result.RenderXML;
import org.osgl.mvc.result.Result;
import org.osgl.mvc.result.SeeOther;
import org.osgl.mvc.result.TemporaryRedirect;
import org.osgl.mvc.result.Unauthorized;
import org.osgl.storage.ISObject;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.Output;
import org.osgl.util.S;

@Retention(value=RetentionPolicy.CLASS)
@Target(value={ElementType.TYPE})
public @interface Controller {
    public String value() default "/";

    public String[] port() default {};

    public static class Base
    extends Util {
        @Inject
        protected ActionContext context;
    }

    public static class Util {
        public static final Ok OK = Ok.get();
        public static final Created CREATED = Created.INSTANCE;
        public static final Result CREATED_JSON = new Result(H.Status.CREATED, "{\"message\": \"Created\"}"){};
        public static final Result CREATED_XML = new Result(H.Status.CREATED, "<?xml version=\"1.0\" ?><message>Created</message>"){};
        public static final Result OK_JSON = new Result(H.Status.OK, "{\"message\": \"Okay\"}"){};
        public static final Result OK_XML = new Result(H.Status.OK, "<?xml version=\"1.0\" ?><message>Okay</message>"){};
        public static final NoContent NO_CONTENT = NoContent.get();

        public static Result ok() {
            H.Format accept = ActionContext.current().accept();
            if (H.Format.JSON == accept) {
                return OK_JSON;
            }
            if (H.Format.XML == accept) {
                return OK_XML;
            }
            return OK;
        }

        public static Created created(String resourceGetUrl) {
            return Created.withLocation((String)resourceGetUrl);
        }

        public static Created created() {
            return Created.INSTANCE;
        }

        public static NotModified notModified() {
            return NotModified.get();
        }

        public static NotModified notModified(String etag, Object ... args) {
            return NotModified.of((String)etag, (Object[])args);
        }

        public static Result accepted(String statusMonitorUrl) {
            return new Accepted(statusMonitorUrl);
        }

        public static Result notAcceptable() {
            return NotAcceptable.get();
        }

        public static Result notAcceptable(String msg, Object ... args) {
            return NotAcceptable.of((String)msg, (Object[])args);
        }

        public static Result notFound() {
            return ActNotFound.create();
        }

        public static Result notFound(String msg, Object ... args) {
            return ActNotFound.create(msg, args);
        }

        public static <T> T notFoundIfNull(T o) {
            if (null == o) {
                throw ActNotFound.create();
            }
            return o;
        }

        public static <T> T notFoundIfNull(T o, String msg, Object ... args) {
            if (null == o) {
                throw ActNotFound.create(msg, args);
            }
            return o;
        }

        public static void notFoundIf(boolean test) {
            if (test) {
                throw ActNotFound.create();
            }
        }

        public static void notFoundIf(boolean test, String msg, Object ... args) {
            if (test) {
                throw ActNotFound.create(msg, args);
            }
        }

        public static void notFoundIfNot(boolean test) {
            Util.notFoundIf(!test);
        }

        public static void notFoundIfNot(boolean test, String msg, Object ... args) {
            Util.notFoundIf(!test, msg, args);
        }

        public static BadRequest badRequest() {
            return ActBadRequest.create();
        }

        public static BadRequest badRequest(String msg, Object ... args) {
            return ActBadRequest.create(msg, args);
        }

        public static void badRequestIf(boolean test) {
            if (test) {
                throw ActBadRequest.create();
            }
        }

        public static void badRequestIf(boolean test, String msg, Object ... args) {
            if (test) {
                throw ActBadRequest.create(msg, args);
            }
        }

        public static void badRequestIfBlank(String test) {
            if (S.blank((String)test)) {
                throw ActBadRequest.create();
            }
        }

        public static void badRequestIfBlank(String test, String msg, Object ... args) {
            if (S.blank((String)test)) {
                throw ActBadRequest.create(msg, args);
            }
        }

        public static void badRequestIfNull(Object test) {
            if (null == test) {
                throw ActBadRequest.create();
            }
        }

        public static void badRequestIfNull(Object test, String msg, Object ... args) {
            if (null == test) {
                throw ActBadRequest.create(msg, args);
            }
        }

        public static void badRequestIfNot(boolean test) {
            if (!test) {
                throw ActBadRequest.create();
            }
        }

        public static void badRequestIfNot(boolean test, String msg, Object ... args) {
            Util.badRequestIf(!test, msg, args);
        }

        public static BadRequest badRequest(int code) {
            return ActBadRequest.create(code);
        }

        public static BadRequest badRequest(int code, String msg, Object ... args) {
            return ActBadRequest.create(code, msg, args);
        }

        public static void badRequestIf(boolean test, int code) {
            if (test) {
                throw ActBadRequest.create(code);
            }
        }

        public static void badRequestIf(boolean test, int code, String msg, Object ... args) {
            if (test) {
                throw ActBadRequest.create(code, msg, args);
            }
        }

        public static void badRequestIfBlank(String test, int code) {
            if (S.blank((String)test)) {
                throw ActBadRequest.create(code);
            }
        }

        public static void badRequestIfBlank(String test, int code, String msg, Object ... args) {
            if (S.blank((String)test)) {
                throw ActBadRequest.create(code, msg, args);
            }
        }

        public static void badRequestIfNull(Object test, int code) {
            if (null == test) {
                throw ActBadRequest.create(code);
            }
        }

        public static void badRequestIfNull(Object test, int code, String msg, Object ... args) {
            if (null == test) {
                throw ActBadRequest.create(code, msg, args);
            }
        }

        public static void badRequestIfNot(boolean test, int code) {
            if (!test) {
                throw ActBadRequest.create(code);
            }
        }

        public static void badRequestIfNot(boolean test, int code, String msg, Object ... args) {
            Util.badRequestIf(!test, code, msg, args);
        }

        public static Conflict conflict() {
            return ActConflict.create();
        }

        public static Conflict conflict(String message, Object ... args) {
            return ActConflict.create(message, args);
        }

        public static void conflictIf(boolean test) {
            if (test) {
                throw ActConflict.create();
            }
        }

        public static void conflictIf(boolean test, String message, Object ... args) {
            if (test) {
                throw ActConflict.create(message, args);
            }
        }

        public static void conflictIfNot(boolean test) {
            Util.conflictIf(!test);
        }

        public static void conflictIfNot(boolean test, String message, Object ... args) {
            Util.conflictIf(!test, message, args);
        }

        public static Conflict conflict(int code) {
            return ActConflict.create(code);
        }

        public static Conflict conflict(int code, String message, Object ... args) {
            return ActConflict.create(code, message, args);
        }

        public static void conflictIf(boolean test, int code) {
            if (test) {
                throw ActConflict.create(code);
            }
        }

        public static void conflictIf(boolean test, int code, String message, Object ... args) {
            if (test) {
                throw ActConflict.create(code, message, args);
            }
        }

        public static void conflictIfNot(boolean test, int code) {
            Util.conflictIf(!test, code);
        }

        public static void conflictIfNot(boolean test, int code, String message, Object ... args) {
            Util.conflictIf(!test, code, message, args);
        }

        public static Unauthorized unauthorized() {
            return ActUnauthorized.create();
        }

        public static Unauthorized unauthorized(String realm) {
            return ActUnauthorized.create(realm);
        }

        public static Unauthorized unauthorized(String realm, boolean digest) {
            return ActUnauthorized.create(realm, digest);
        }

        public static void unauthorizedIf(boolean test) {
            if (test) {
                throw ActUnauthorized.create();
            }
        }

        public static void unauthorizedIf(boolean test, String realm) {
            if (test) {
                throw ActUnauthorized.create(realm);
            }
        }

        public static void unauthorizedIf(boolean test, String realm, boolean digest) {
            if (test) {
                throw ActUnauthorized.create(realm, digest);
            }
        }

        public static void unauthorizedIfNot(boolean test) {
            Util.unauthorizedIf(!test);
        }

        public static void unauthorizedIfNot(boolean test, String realm) {
            Util.unauthorizedIf(!test, realm);
        }

        public static void unauthorizedIfNot(boolean test, String realm, boolean digest) {
            Util.unauthorizedIf(!test, realm, digest);
        }

        public static Forbidden forbidden() {
            return ActForbidden.create();
        }

        public static Forbidden forbidden(String msg, Object ... args) {
            return ActForbidden.create(msg, args);
        }

        public static void forbiddenIf(boolean test) {
            if (test) {
                throw ActForbidden.create();
            }
        }

        public static void forbiddenIfNot(boolean test) {
            Util.forbiddenIf(!test);
        }

        public static void forbiddenIf(boolean test, String msg, Object ... args) {
            if (test) {
                throw ActForbidden.create(msg, args);
            }
        }

        public static void forbiddenIfNot(boolean test, String msg, Object ... args) {
            Util.forbiddenIf(!test, msg, args);
        }

        public static Forbidden forbidden(int code) {
            return ActForbidden.create(code);
        }

        public static Forbidden forbidden(String msg, int code, Object ... args) {
            return ActForbidden.create(msg, args);
        }

        public static void forbiddenIf(boolean test, int code) {
            if (test) {
                throw ActForbidden.create(code);
            }
        }

        public static void forbiddenIfNot(boolean test, int code) {
            Util.forbiddenIf(!test, code);
        }

        public static void forbiddenIf(boolean test, int code, String msg, Object ... args) {
            if (test) {
                throw ActForbidden.create(code, msg, args);
            }
        }

        public static void forbiddenIfNot(boolean test, int code, String msg, Object ... args) {
            Util.forbiddenIf(!test, code, msg, args);
        }

        public static void forward(String url) {
            ActionContext ctx = ActionContext.current();
            ctx.forward(url);
        }

        public static Redirect redirect(String url, Object ... args) {
            return Redirect.of((String)Util.redirectUrl(url, args));
        }

        public static Redirect redirect(String url, Map reverseRoutingArguments) {
            return Redirect.of((String)Util.redirectUrl(url, reverseRoutingArguments));
        }

        public static void redirectIf(boolean test, String url, Object ... args) {
            if (test) {
                throw Util.redirect(url, args);
            }
        }

        public static void redirectIfNot(boolean test, String url, Object ... args) {
            Util.redirectIf(!test, url, args);
        }

        public static void redirectIf(boolean test, String url, Map reverseRoutingArguments) {
            if (test) {
                throw Util.redirect(url, reverseRoutingArguments);
            }
        }

        public static void redirectIfNot(boolean test, String url, Map reverseRoutingArguments) {
            Util.redirectIf(!test, url, reverseRoutingArguments);
        }

        public static MovedPermanently moved(String url, Object ... args) {
            return MovedPermanently.of((String)Util.redirectUrl(url, args));
        }

        public static MovedPermanently moved(String url, Map reverseRoutingArguments) {
            return MovedPermanently.of((String)Util.redirectUrl(url, reverseRoutingArguments));
        }

        public static Found found(String url, Object ... args) {
            return Found.of((String)Util.redirectUrl(url, args));
        }

        public static Found found(String url, Map reverseRoutingArguments) {
            return Found.of((String)Util.redirectUrl(url, reverseRoutingArguments));
        }

        public static void foundIf(boolean test, String url, Object ... args) {
            if (test) {
                throw Util.found(url, args);
            }
        }

        public static void foundIfNot(boolean test, String url, Object ... args) {
            Util.foundIf(!test, url, args);
        }

        public static SeeOther seeOther(String url, Object ... args) {
            return SeeOther.of((String)Util.redirectUrl(url, args));
        }

        public static SeeOther seeOther(String url, Map reverseRoutingArguments) {
            return SeeOther.of((String)Util.redirectUrl(url, reverseRoutingArguments));
        }

        public static void seeOtherIf(boolean test, String url, Object ... args) {
            if (test) {
                throw Util.seeOther(url, args);
            }
        }

        public static void seeOtherIfNot(boolean test, String url, Object ... args) {
            Util.seeOtherIf(!test, url, args);
        }

        public static TemporaryRedirect temporaryRedirect(String url, Object ... args) {
            return TemporaryRedirect.of((String)Util.redirectUrl(url, args));
        }

        public static TemporaryRedirect temporaryRedirect(String url, Map reverseRoutingArguments) {
            return TemporaryRedirect.of((String)Util.redirectUrl(url, reverseRoutingArguments));
        }

        public static PermanentRedirect permanentRedirect(String url, Object ... args) {
            return PermanentRedirect.of((String)Util.redirectUrl(url, args));
        }

        public static PermanentRedirect permanentRedirect(String url, Map reverseRoutingArguments) {
            return PermanentRedirect.of((String)Util.redirectUrl(url, reverseRoutingArguments));
        }

        private static String redirectUrl(String url, Object ... args) {
            ActionContext context;
            String urlContext;
            if ((url = S.fmt((String)url, (Object[])args)).contains(".") || url.contains("(")) {
                String inferFullActionPath = Router.inferFullActionPath(url);
                if (inferFullActionPath != url) {
                    url = ActionContext.current().router().reverseRoute(url);
                }
            } else if (!url.startsWith("/") && S.notBlank((String)(urlContext = (context = ActionContext.current()).urlContext()))) {
                url = S.pathConcat((String)urlContext, (char)'/', (String)url);
            }
            return url;
        }

        private static String redirectUrl(String url, Map reverseRoutingArguments) {
            url = Router.inferFullActionPath(url);
            url = ActionContext.current().router().reverseRoute(url, reverseRoutingArguments);
            return url;
        }

        public static RenderText text(String msg, Object ... args) {
            return RenderText.of((H.Status)Util.successStatus(), (String)msg, (Object[])args);
        }

        public static RenderText renderText(String msg, Object ... args) {
            return Util.text(msg, args);
        }

        public static RenderHtml html(String msg, Object ... args) {
            return RenderHtml.of((H.Status)Util.successStatus(), (String)msg, (Object[])args);
        }

        public static RenderHtml renderHtml(String msg, Object args) {
            return Util.html(msg, args);
        }

        public static RenderJSON json(String msg, Object ... args) {
            return RenderJSON.of((H.Status)Util.successStatus(), (String)msg, (Object[])args);
        }

        public static RenderJSON renderJson(String msg, Object ... args) {
            return Util.json(msg, args);
        }

        public static RenderJSON json(Object data) {
            return RenderJSON.of((H.Status)Util.successStatus(), (Object)data);
        }

        public static RenderJSON renderJson(Object data) {
            return Util.json(data);
        }

        public static RenderJsonMap jsonMap(Object ... data) {
            return RenderJsonMap.get();
        }

        public static RenderJsonMap renderJsonMap(Object ... data) {
            return Util.jsonMap(data);
        }

        public static RenderJwt renderJwt() {
            return RenderJwt.get();
        }

        public static RenderJwt jwt() {
            return RenderJwt.get();
        }

        public static RenderXML xml(String msg, Object ... args) {
            return RenderXML.of((H.Status)Util.successStatus(), (String)msg, (Object[])args);
        }

        public static RenderXML renderXml(String msg, Object ... args) {
            return Util.xml(msg, args);
        }

        public static RenderBinary binary(ISObject sobj) {
            return new RenderBinary(sobj.asInputStream(), sobj.getAttribute("filename"), sobj.getAttribute("content-type"), true);
        }

        public static RenderBinary renderBinary(ISObject sobj) {
            return Util.binary(sobj);
        }

        public static RenderBinary download(ISObject sobj) {
            return new RenderBinary(sobj.asInputStream(), sobj.getAttribute("filename"), sobj.getAttribute("content-type"), false);
        }

        public static RenderBinary binary(File file) {
            return new RenderBinary(file);
        }

        public static RenderBinary renderBinary(File file) {
            return Util.binary(file);
        }

        public static RenderBinary binary(Lang.Visitor<Output> outputStreamWriter) {
            return new RenderBinary(outputStreamWriter);
        }

        public static RenderBinary renderBinary(Lang.Visitor<Output> outputStreamWriter) {
            return Util.binary(outputStreamWriter);
        }

        public static RenderBinary download(URL url) {
            String file = url.getPath();
            String fileName = S.afterLast((String)file, (String)"/");
            return new RenderBinary(IO.is((URL)url), fileName, false);
        }

        public static RenderBinary download(URL url, String attachmentName) {
            return new RenderBinary(IO.is((URL)url), attachmentName, false);
        }

        public static RenderBinary download(File file) {
            return new RenderBinary(file, file.getName(), false);
        }

        public static RenderBinary download(File file, String attachmentName) {
            return new RenderBinary(file, attachmentName, false);
        }

        public static RenderBinary download(InputStream inputStream, String attachmentName) {
            return new RenderBinary(inputStream, attachmentName, false);
        }

        public static ZXingResult barcode(String content) {
            return ZXingResult.barcode(content);
        }

        public static ZXingResult renderBarcode(String content) {
            return Util.barcode(content);
        }

        public static ZXingResult qrcode(String content) {
            return ZXingResult.qrcode(content);
        }

        public static ZXingResult renderQrcode(String content) {
            return Util.qrcode(content);
        }

        public static RenderTemplate template(Map<String, Object> args) {
            return RenderTemplate.of(args);
        }

        public static RenderTemplate renderTemplate(Map<String, Object> args) {
            return Util.template(args);
        }

        public static RenderTemplate renderTemplate(Object ... args) {
            return RenderTemplate.get();
        }

        public static RenderTemplate template(Object ... args) {
            return RenderTemplate.get(ActionContext.current().successStatus());
        }

        public static RenderAny render(Object ... args) {
            return RenderAny.get();
        }

        public static Result inferResult(Result r, ActionContext actionContext) {
            return r;
        }

        public static Result inferPrimitiveResult(Object v, ActionContext actionContext, boolean requireJSON, boolean requireXML, boolean isArray, boolean isDateTime) {
            H.Status status = actionContext.successStatus();
            if (requireJSON) {
                if (isArray) {
                    return RenderJSON.of((H.Status)status, (String)$.toString2((Object)v));
                }
                return RenderJSON.of((H.Status)status, (Object)C.Map((Object[])new Object[]{"result", v}));
            }
            if (requireXML) {
                return RenderXML.of((H.Status)status, (String)S.concat((String)"<result>", (String)S.string((Object)v), (String)"</result>"));
            }
            if (v instanceof byte[]) {
                H.Format fmt = actionContext.accept();
                if (H.Format.UNKNOWN == fmt) {
                    actionContext.resp().contentType("application/octet-stream");
                }
                return new RenderBinary((byte[])v);
            }
            H.Format fmt = actionContext.accept();
            String s = $$.toString(v, isDateTime, isArray);
            if (H.Format.HTML == fmt || H.Format.UNKNOWN == fmt) {
                return RenderHtml.of((H.Status)status, (String)s);
            }
            if (fmt.isText()) {
                return RenderText.of((H.Status)status, (H.Format)fmt, (String)s, (Object[])new Object[]{status.toString()});
            }
            throw E.unexpected((String)"Cannot apply text result to format: %s", (Object[])new Object[]{fmt});
        }

        public static Result inferResult(Map<String, Object> map, ActionContext actionContext) {
            if (actionContext.acceptJson()) {
                return RenderJSON.of((H.Status)actionContext.successStatus(), map);
            }
            return RenderTemplate.of(actionContext.successStatus(), map);
        }

        public static Result inferResult(Object[] array, ActionContext actionContext) {
            if (actionContext.acceptJson()) {
                return RenderJSON.of((H.Status)actionContext.successStatus(), (Object)array);
            }
            throw E.tbd((String)"render template with render args in array");
        }

        public static Result inferResult(InputStream is, ActionContext actionContext) {
            if (actionContext.acceptJson()) {
                return RenderJSON.of((H.Status)actionContext.successStatus(), (String)IO.readContentAsString((InputStream)is));
            }
            return new RenderBinary(is, "", true).status(actionContext.successStatus());
        }

        public static Result inferResult(File file, ActionContext actionContext) {
            if (actionContext.acceptJson()) {
                return RenderJSON.of((H.Status)actionContext.successStatus(), (String)IO.readContentAsString((File)file));
            }
            return new RenderBinary(file).status(actionContext.successStatus());
        }

        public static Result inferResult(ISObject sobj, ActionContext context) {
            if (context.acceptJson()) {
                return RenderJSON.of((H.Status)context.successStatus(), (String)sobj.asString());
            }
            return Util.binary(sobj).status(context.successStatus());
        }

        public static Result inferResult(HandlerMethodMetaInfo meta, Object v, ActionContext context, boolean hasTemplate) {
            boolean requireXML;
            if (v instanceof Result) {
                return (Result)((Object)v);
            }
            H.Request req = context.req();
            H.Status status = context.successStatus();
            if (Act.isProd() && v instanceof Versioned && req.method().safe()) {
                Util.processEtag(meta, v, context, req);
            }
            if (hasTemplate) {
                if (v instanceof Map) {
                    return Util.inferToTemplate((Map)((Object)v), context);
                }
                return Util.inferToTemplate(v, context);
            }
            boolean requireJSON = context.acceptJson();
            boolean bl = requireXML = !requireJSON && context.acceptXML();
            if (null == v) {
                return null;
            }
            Class<?> vCls = v.getClass();
            boolean isDateTimeType = $$.isDateTimeType(vCls);
            if ($.isSimpleType(vCls) || isDateTimeType) {
                boolean isArray = vCls.isArray();
                return Util.inferPrimitiveResult(v, context, requireJSON, requireXML, isArray, isDateTimeType);
            }
            if (v instanceof InputStream) {
                return Util.inferResult((InputStream)((Object)v), context);
            }
            if (v instanceof File) {
                return Util.inferResult((File)((Object)v), context);
            }
            if (v instanceof ISObject) {
                return Util.inferResult((ISObject)v, context);
            }
            if (v instanceof Map) {
                return RenderJSON.of((H.Status)status, (Object)v);
            }
            if (requireJSON) {
                boolean isIterable = v instanceof Iterable;
                if (isIterable) {
                    v = new FastJsonIterable(v);
                }
                if (v instanceof Lang.Visitor) {
                    return RenderJSON.of((Lang.Visitor)((Lang.Visitor)v));
                }
                if (v instanceof Lang.Func0) {
                    return RenderJSON.of((Lang.Func0)((Lang.Func0)v));
                }
                PropertySpec.MetaInfo propertySpec = PropertySpec.MetaInfo.withCurrent(meta, (ActContext)context);
                boolean possibleLargeResponse = context.isLargeResponse();
                JsonUtilConfig.JsonWriter jsonWriter = new JsonUtilConfig.JsonWriter(v, propertySpec, false, context);
                return possibleLargeResponse ? RenderJSON.of((Lang.Visitor)jsonWriter) : RenderJSON.of(jsonWriter.asContentProducer());
            }
            if (context.acceptXML()) {
                PropertySpec.MetaInfo propertySpec = PropertySpec.MetaInfo.withCurrent(meta, (ActContext)context);
                return new FilteredRenderXML(status, v, propertySpec, context);
            }
            if (context.accept() == H.Format.CSV) {
                PropertySpec.MetaInfo propertySpec = PropertySpec.MetaInfo.withCurrent(meta, (ActContext)context);
                return RenderCSV.of(status, v, propertySpec, context);
            }
            boolean isArray = vCls.isArray();
            return Util.inferPrimitiveResult(v, context, false, requireXML, isArray, isDateTimeType);
        }

        private static void processEtag(HandlerMethodMetaInfo meta, Object v, ActionContext context, H.Request req) {
            if (!(v instanceof Versioned)) {
                return;
            }
            String version = ((Versioned)v)._version();
            String etagVersion = Util.etag(meta, version);
            if (req.etagMatches(etagVersion)) {
                throw NotModified.get();
            }
            context.resp().etag(etagVersion);
        }

        private static String etag(HandlerMethodMetaInfo meta, String version) {
            return S.newBuffer((String)version).append(meta.hashCode()).toString();
        }

        private static Result inferToTemplate(Object v, ActionContext actionContext) {
            actionContext.renderArg("result", v);
            return RenderTemplate.get();
        }

        private static Result inferToTemplate(Map map, ActionContext actionContext) {
            return RenderTemplate.of(map);
        }

        private static H.Status successStatus() {
            return ActionContext.current().successStatus();
        }
    }
}

