/*
 * Decompiled with CFR 0.152.
 */
package act.controller;

import act.ActResponse;
import act.controller.OutputStreamCache;
import act.controller.WriterCache;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.osgl.$;
import org.osgl.exception.UnexpectedIOException;
import org.osgl.http.H;
import org.osgl.storage.ISObject;
import org.osgl.util.Charsets;
import org.osgl.util.Output;

public class ResponseCache
extends ActResponse
implements Serializable {
    private Map<String, H.Cookie> cookies = new HashMap<String, H.Cookie>();
    private Map<String, String> headers = new HashMap<String, String>();
    private Long len;
    private H.Status status;
    private ByteBuffer buffer;
    private OutputStreamCache osCache;
    private WriterCache writerCache;
    private transient ActResponse realResponse;

    public ResponseCache() {
    }

    public ResponseCache(ActResponse realResponse) {
        this.realResponse = (ActResponse)((Object)$.requireNotNull((Object)((Object)realResponse)));
    }

    public void applyTo(ActResponse response) {
        for (H.Cookie cookie : this.cookies.values()) {
            response.addCookie(cookie);
        }
        for (Map.Entry entry : this.headers.entrySet()) {
            response.header((String)entry.getKey(), (String)entry.getValue());
        }
        if (null != this.contentType) {
            response.contentType(this.contentType);
        }
        if (null != this.charset) {
            response.characterEncoding(this.charset);
        }
        response.commitContentType();
        if (null != this.len) {
            response.contentLength(this.len);
        }
        if (null != this.locale) {
            response.locale(this.locale);
        }
        if (null != this.status) {
            response.status(this.status);
        }
        if (null != this.buffer) {
            response.writeContent(this.buffer.duplicate());
        } else if (null != this.osCache) {
            this.osCache.apply(response);
        } else if (null != this.writerCache) {
            this.writerCache.apply(response);
        }
    }

    public H.Response context(Object context) {
        this.realResponse.context(context);
        return this;
    }

    public Object context() {
        return this.realResponse.context();
    }

    public boolean writerCreated() {
        return this.realResponse.writerCreated();
    }

    public OutputStream outputStream() throws IllegalStateException, UnexpectedIOException {
        this.osCache = new OutputStreamCache(this.realResponse.outputStream());
        return this.osCache;
    }

    public Writer writer() throws IllegalStateException, UnexpectedIOException {
        this.writerCache = new WriterCache(this.realResponse.writer());
        return this.writerCache;
    }

    public PrintWriter printWriter() {
        Writer w = this.writer();
        if (w instanceof PrintWriter) {
            return (PrintWriter)w;
        }
        return new PrintWriter(w);
    }

    public H.Response contentType(String type) {
        this.realResponse.contentType(type);
        this.contentType = type;
        return this;
    }

    public ActResponse contentType(H.Format fmt) {
        this.contentType = fmt.contentType();
        return super.contentType(fmt);
    }

    public H.Response initContentType(String type) {
        this.realResponse.initContentType(type);
        if (null == this.contentType) {
            this.contentType = type;
        }
        return this;
    }

    public H.Response contentDisposition(String filename, boolean inline) {
        this.realResponse.contentDisposition(filename, inline);
        return this;
    }

    public H.Response prepareDownload(String filename) {
        this.realResponse.prepareDownload(filename);
        return this;
    }

    public H.Response etag(String etag) {
        this.realResponse.etag(etag);
        return this;
    }

    public H.Response locale(Locale locale) {
        this.realResponse.locale(locale);
        this.locale = locale;
        return this;
    }

    public H.Response sendError(int sc, String msg, Object ... args) {
        this.realResponse.sendError(sc, msg, args);
        return this;
    }

    public H.Response status(H.Status s) {
        this.realResponse.status(s);
        this.status = s;
        return this;
    }

    public H.Response addHeaderIfNotAdded(String name, String value) {
        this.realResponse.addHeaderIfNotAdded(name, value);
        if (!this.headers.containsKey(name)) {
            this.headers.put(name, value);
        }
        return this;
    }

    public H.Response writeBinary(ISObject binary) {
        this.realResponse.writeBinary(binary);
        byte[] ba = binary.asByteArray();
        ByteBuffer buffer = ByteBuffer.allocateDirect(ba.length);
        buffer.put(ba);
        buffer.flip();
        this.buffer = buffer;
        return this;
    }

    public H.Response writeContent(String s) {
        this.realResponse.writeContent(s);
        byte[] ba = s.getBytes(Charsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocateDirect(ba.length);
        buffer.put(ba);
        buffer.flip();
        this.buffer = buffer;
        return this;
    }

    public H.Response writeText(String content) {
        return this.writeContent(content, H.Format.TXT);
    }

    public H.Response writeHtml(String content) {
        return this.writeContent(content, H.Format.HTML);
    }

    public H.Response writeJSON(String content) {
        return this.writeContent(content, H.Format.JSON);
    }

    private H.Response writeContent(String content, H.Format contentType) {
        this.contentType(contentType.contentType());
        this.writeContent(content);
        return this;
    }

    protected Class _impl() {
        return this.getClass();
    }

    protected Output createOutput() {
        return null;
    }

    protected OutputStream createOutputStream() {
        return null;
    }

    @Override
    public String characterEncoding() {
        return this.charset;
    }

    @Override
    public ActResponse characterEncoding(String encoding) {
        this.realResponse.characterEncoding(encoding);
        super.characterEncoding(encoding);
        return this;
    }

    public H.Response contentLength(long len) {
        this.realResponse.contentLength(len);
        this.len = len;
        return this;
    }

    @Override
    protected void _setContentType(String type) {
        this.contentType = type;
    }

    protected void _setLocale(Locale loc) {
        this.locale = loc;
    }

    public Locale locale() {
        return this.realResponse.locale();
    }

    public void addCookie(H.Cookie cookie) {
        this.realResponse.addCookie(cookie);
        this.cookies.put(cookie.name(), cookie);
    }

    public boolean containsHeader(String name) {
        return this.realResponse.containsHeader(name);
    }

    @Override
    public ActResponse sendError(int sc, String msg) {
        this.realResponse.sendError(sc, msg);
        return this;
    }

    @Override
    public ActResponse sendError(int sc) {
        this.realResponse.sendError(sc);
        return this;
    }

    @Override
    public ActResponse sendRedirect(String location) {
        this.realResponse.sendRedirect(location);
        return this;
    }

    public H.Response header(String name, String value) {
        this.realResponse.header(name, value);
        return this;
    }

    @Override
    protected void _setStatusCode(int sc) {
        this.realResponse.status(sc);
        this.status = H.Status.of((int)sc);
    }

    public H.Response addHeader(String name, String value) {
        this.realResponse.addHeader(name, value);
        this.headers.put(name, value);
        return this;
    }

    public H.Response writeContent(ByteBuffer buffer) {
        this.realResponse.writeContent(buffer);
        return this;
    }

    public void commit() {
        this.realResponse.commit();
    }
}

