/*
 * Decompiled with CFR 0.152.
 */
package act.controller.meta;

import act.Act;
import act.app.AppClassLoader;
import act.controller.meta.ControllerClassMetaInfo;
import act.controller.meta.HandlerParamMetaInfo;
import act.controller.meta.InterceptorMethodMetaInfo;
import java.util.ArrayList;
import java.util.List;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.S;

public class CatchMethodMetaInfo
extends InterceptorMethodMetaInfo {
    private static final List<String> CATCH_THROWABLE = C.list((Object)Throwable.class.getName());
    private List<String> targetExceptionClassNames = CATCH_THROWABLE;
    private volatile Boolean paramTypeAnalyzed;

    protected CatchMethodMetaInfo(CatchMethodMetaInfo copy, ControllerClassMetaInfo clsInfo) {
        super(copy, clsInfo);
        this.targetExceptionClassNames = copy.targetExceptionClassNames;
    }

    public CatchMethodMetaInfo(ControllerClassMetaInfo clsInfo) {
        super(clsInfo);
    }

    @Override
    protected void releaseResources() {
        this.targetExceptionClassNames = null;
        super.releaseResources();
    }

    public CatchMethodMetaInfo exceptionClasses(List<String> list) {
        this.targetExceptionClassNames = C.newList(list);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> exceptionClasses() {
        if (null == this.paramTypeAnalyzed) {
            CatchMethodMetaInfo catchMethodMetaInfo = this;
            synchronized (catchMethodMetaInfo) {
                if (null == this.paramTypeAnalyzed) {
                    this.paramTypeAnalyzed = true;
                    this.analyzeParamTypes();
                }
            }
        }
        return this.targetExceptionClassNames;
    }

    private void analyzeParamTypes() {
        AppClassLoader cl = Act.app().classLoader();
        ArrayList<String> paramExceptions = new ArrayList<String>();
        int n = this.paramCount();
        for (int i = 0; i < n; ++i) {
            HandlerParamMetaInfo param = this.param(i);
            String className = param.type().getClassName();
            if (className.endsWith("Exception")) {
                paramExceptions.add(className);
                continue;
            }
            Class cls = $.classForName((String)className, (ClassLoader)cl);
            if (!Throwable.class.isAssignableFrom(cls)) continue;
            paramExceptions.add(className);
        }
        if (!paramExceptions.isEmpty()) {
            if (1 == this.targetExceptionClassNames.size() && Throwable.class.getName().equals(this.targetExceptionClassNames.get(0))) {
                this.targetExceptionClassNames = paramExceptions;
            } else {
                this.targetExceptionClassNames.addAll(paramExceptions);
            }
        }
    }

    @Override
    public String toString() {
        return this.toStrBuffer(S.newBuffer()).toString();
    }

    @Override
    protected S.Buffer toStrBuffer(S.Buffer sb) {
        StringBuilder prependix = S.builder((String)"catch").append(this.targetExceptionClassNames).append(" ");
        return super.toStrBuffer(sb).prepend(prependix);
    }

    @Override
    protected InterceptorMethodMetaInfo doExtend(ControllerClassMetaInfo clsInfo) {
        return new CatchMethodMetaInfo(this, clsInfo);
    }
}

