/*
 * Decompiled with CFR 0.152.
 */
package act.crypto;

import act.conf.AppConfig;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import org.mindrot.jbcrypt.BCrypt;
import org.osgl.exception.UnexpectedException;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.Crypto;
import org.osgl.util.E;
import org.osgl.util.S;
import org.osgl.util.Token;

public class AppCrypto {
    protected static final Logger LOGGER = LogManager.get(AppCrypto.class);
    private byte[] secret;
    private SecureRandom secureRandom = new SecureRandom();

    protected AppCrypto() {
    }

    public AppCrypto(String secret) {
        this.secret = secret.getBytes(StandardCharsets.UTF_8);
    }

    public AppCrypto(AppConfig config) {
        this.secret = config.secret().getBytes(StandardCharsets.UTF_8);
    }

    public String sign(String message) {
        return Crypto.sign((String)message, (byte[])this.secret);
    }

    public char[] passwordHash(char[] password) {
        return BCrypt.hashpw(password, BCrypt.gensalt());
    }

    public String passwordHash(String password) {
        return BCrypt.hashpw(password, BCrypt.gensalt());
    }

    public boolean verifyPassword(String password, String hash) {
        try {
            return BCrypt.checkpw(password, hash);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean verifyPassword(char[] password, String hash) {
        try {
            return BCrypt.checkpw(password, hash);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean verifyPassword(char[] password, char[] hash) {
        try {
            return BCrypt.checkpw(password, new String(hash));
        }
        catch (Exception e) {
            return false;
        }
    }

    public String encrypt(String message) {
        try {
            return Crypto.encryptAES((String)message, (byte[])this.secret);
        }
        catch (UnexpectedException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvalidKeyException) {
                LOGGER.error("Cannot encrypt/decrypt! Please download Java Crypto Extension pack from Oracle: http://www.oracle.com/technetwork/java/javase/tech/index-jsp-136007.html");
            }
            throw e;
        }
    }

    public String decrypt(String message) {
        try {
            return Crypto.decryptAES((String)message, (byte[])this.secret);
        }
        catch (UnexpectedException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvalidKeyException) {
                LOGGER.error("Cannot encrypt/decrypt! Please download Java Crypto Extension pack from Oracle: http://www.oracle.com/technetwork/java/javase/tech/index-jsp-136007.html");
            }
            throw e;
        }
    }

    public String checksum(InputStream is) {
        try {
            int nread;
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] dataBytes = new byte[1024];
            while ((nread = is.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = md.digest();
            S.Buffer sb = S.buffer();
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw E.unexpected((Throwable)e);
        }
    }

    public int generateRandomInt(int max) {
        return this.secureRandom.nextInt(max);
    }

    public int generateRandomInt() {
        return this.secureRandom.nextInt(Integer.MAX_VALUE);
    }

    public String generateToken(String id, String ... payload) {
        return Token.generateToken((byte[])this.secret, (String)id, (String[])payload);
    }

    public String generateToken(Token.Life expiration, String id, String ... payload) {
        return Token.generateToken((byte[])this.secret, (Token.Life)expiration, (String)id, (String[])payload);
    }

    public String generateToken(int seconds, String id, String ... payload) {
        return Token.generateToken((byte[])this.secret, (long)seconds, (String)id, (String[])payload);
    }

    public Token parseToken(String tokenString) {
        return Token.parseToken((byte[])this.secret, (String)tokenString);
    }
}

