/*
 * Decompiled with CFR 0.152.
 */
package act.crypto;

import act.crypto.HMAC;
import act.session.RotationSecretProvider;
import javax.crypto.Mac;
import org.osgl.$;

public class RotateSecretHMAC
extends HMAC {
    private RotationSecretProvider secretProvider;
    private boolean rotateEnabled;

    public RotateSecretHMAC(String algoKey, RotationSecretProvider secretProvider) {
        super(secretProvider.rawSecret(), algoKey);
        this.secretProvider = (RotationSecretProvider)$.requireNotNull((Object)secretProvider);
        this.rotateEnabled = secretProvider.isRotateEnabled();
    }

    public RotateSecretHMAC(HMAC.Algorithm algo, RotationSecretProvider secretProvider) {
        super(secretProvider.rawSecret(), algo);
        this.secretProvider = secretProvider;
    }

    @Override
    protected boolean verifyHash(byte[] payload, byte[] hash) {
        if (!this.rotateEnabled) {
            return super.verifyHash(payload, hash);
        }
        return this.verifyHash(payload, hash, this.curMac()) || this.verifyHash(payload, hash, this.prevMac()) || this.verifyHash(payload, hash, this.nextMac());
    }

    @Override
    protected byte[] doHash(byte[] bytes) {
        return this.rotateEnabled ? this.doHash(bytes, this.curMac()) : super.doHash(bytes);
    }

    private Mac curMac() {
        return this.algo.macOf(this.secretProvider.curSecret());
    }

    private Mac prevMac() {
        return this.algo.macOf(this.secretProvider.lastSecret());
    }

    private Mac nextMac() {
        return this.algo.macOf(this.secretProvider.nextSecret());
    }
}

