/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.Act;
import act.conf.AppConfig;
import act.data.annotation.DateFormatPattern;
import act.data.annotation.Pattern;
import act.util.ActContext;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.osgl.$;
import org.osgl.util.AnnotationAware;
import org.osgl.util.E;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;
import org.osgl.util.ValueObject;

public abstract class JodaDateTimeCodecBase<T>
extends StringValueResolver<T>
implements ValueObject.Codec<T> {
    private ConcurrentMap<Locale, DateTimeFormatter> localizedDateFormats = new ConcurrentHashMap<Locale, DateTimeFormatter>();
    private boolean i18n;
    private Locale defLocale;
    protected DateTimeFormatter formatter;
    private AppConfig conf;

    public JodaDateTimeCodecBase(DateTimeFormatter formatter) {
        E.NPE((Object)formatter);
        this.conf = Act.appConfig();
        this.i18n = this.conf.i18nEnabled();
        this.defLocale = this.conf.locale();
        this.initFormatter(formatter);
    }

    public JodaDateTimeCodecBase(String pattern) {
        E.illegalArgumentIf((boolean)S.blank((String)pattern));
        this.conf = Act.appConfig();
        this.i18n = this.conf.i18nEnabled();
        this.defLocale = this.conf.locale();
        this.initFormatter(this.formatter(pattern, this.defLocale));
    }

    public final T parse(String s) {
        return this.resolve(s);
    }

    public final Class<T> targetClass() {
        return this.targetType();
    }

    public final T resolve(String value) {
        return S.blank((String)value) ? null : (T)this.parse(this.formatter(), value);
    }

    public final String toJSONString(T o) {
        String s = this.toString(o);
        return S.newSizedBuffer((int)(s.length() + 2)).append("\"").append(s).append("\"").toString();
    }

    public final StringValueResolver<T> amended(AnnotationAware beanSpec) {
        DateFormatPattern dfp = (DateFormatPattern)beanSpec.getAnnotation(DateFormatPattern.class);
        if (null != dfp) {
            return this.create(dfp.value());
        }
        Pattern pattern = (Pattern)beanSpec.getAnnotation(Pattern.class);
        return null == pattern ? this : this.create(pattern.value());
    }

    protected abstract T parse(DateTimeFormatter var1, String var2);

    protected abstract DateTimeFormatter isoFormatter();

    protected abstract T now();

    private void verify() {
        T now = this.now();
        String s = this.toString(now);
        if (!s.equals(this.toString(this.parse(s)))) {
            throw new IllegalArgumentException("Invalid pattern");
        }
    }

    protected abstract JodaDateTimeCodecBase<T> create(String var1);

    protected final DateTimeFormatter formatter() {
        String sanitizedPattern;
        String pattern;
        ActContext.Base<?> ctx = ActContext.Base.currentContext();
        String string = pattern = null == ctx ? null : ctx.dateFormatPattern();
        if (S.notBlank((String)pattern) && null != (sanitizedPattern = this.sanitize(pattern))) {
            return this.formatter(sanitizedPattern, ctx.locale(true));
        }
        DateTimeFormatter formatter = this.defaultFormatter();
        if (!this.i18n) {
            return formatter;
        }
        if (null == ctx) {
            return formatter;
        }
        Locale locale = ctx.locale();
        if (null == locale) {
            return formatter;
        }
        if (locale.equals(this.defLocale)) {
            return formatter;
        }
        DateTimeFormatter localizedFormatter = (DateTimeFormatter)this.localizedDateFormats.get(locale);
        if (null == localizedFormatter) {
            localizedFormatter = this.formatter(this.dateTimePattern(this.conf, locale), locale);
            this.localizedDateFormats.putIfAbsent(locale, localizedFormatter);
        }
        return localizedFormatter;
    }

    protected abstract String dateTimePattern(AppConfig var1, Locale var2);

    protected String sanitize(String dateTimePattern) {
        return dateTimePattern;
    }

    protected DateTimeFormatter defaultFormatter() {
        return this.formatter;
    }

    private void initFormatter(DateTimeFormatter formatter) {
        this.formatter = (DateTimeFormatter)$.requireNotNull((Object)formatter);
        this.verify();
    }

    private DateTimeFormatter formatter(String pattern, Locale locale) {
        if (S.blank((String)pattern)) {
            return this.defaultFormatter();
        }
        return (JodaDateTimeCodecBase.isIsoStandard(pattern) ? this.isoFormatter() : DateTimeFormat.forPattern((String)pattern)).withLocale(locale);
    }

    public static boolean isIsoStandard(String pattern) {
        return null == pattern || pattern.contains("iso") || pattern.contains("ISO") || pattern.contains("8601");
    }
}

